/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.vocab;

import com.bigdata.io.SerializerUtil;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.vocab.NoVocabulary;
import com.bigdata.rdf.vocab.RDFSVocabulary;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.rdf.vocab.VocabularyDecl;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import junit.framework.TestCase2;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;

public class TestVocabulary
extends TestCase2 {
    public TestVocabulary() {
    }

    public TestVocabulary(String name) {
        super(name);
    }

    public void test_BasicVocabulary() {
        RDFSVocabulary vocab = new RDFSVocabulary(this.getName());
        vocab.init();
        if (log.isInfoEnabled()) {
            log.info((Object)("Vocabulary size: " + vocab.size()));
        }
        TestVocabulary.doRoundTripTest((Vocabulary)vocab);
        TestVocabulary.assertNotNull((Object)vocab.get((Value)RDF.TYPE));
        TestVocabulary.assertEquals((Object)RDF.TYPE, (Object)vocab.asValue(vocab.get((Value)RDF.TYPE)));
        TestVocabulary.assertNull((Object)vocab.get((Value)new URIImpl("http://www.bigdata.com/unknown-uri")));
        int nfound = 0;
        Iterator itr = vocab.values();
        while (itr.hasNext()) {
            BigdataValue v = (BigdataValue)itr.next();
            TestVocabulary.assertNotNull((Object)v.getIV());
            TestVocabulary.assertTrue((boolean)v.getIV().hasValue());
            TestVocabulary.assertEquals((Object)v, (Object)vocab.asValue(v.getIV()));
            TestVocabulary.assertNotNull((Object)vocab.getConstant((Value)v));
            TestVocabulary.assertEquals((Object)v.getIV(), (Object)vocab.getConstant((Value)v).get());
            ++nfound;
        }
        TestVocabulary.assertEquals((int)nfound, (int)vocab.size());
    }

    public void test_NoVocabulary() {
        NoVocabulary vocab = new NoVocabulary(this.getName());
        vocab.init();
        TestVocabulary.assertEquals((int)0, (int)vocab.size());
        TestVocabulary.assertFalse((boolean)vocab.values().hasNext());
        TestVocabulary.doRoundTripTest((Vocabulary)vocab);
        TestVocabulary.assertNull((Object)vocab.get((Value)new URIImpl("http://www.bigdata.com/unknown-uri")));
    }

    public void test_BigVocabulary() {
        BigVocabulary vocab = new BigVocabulary(this.getName());
        vocab.init();
        if (log.isInfoEnabled()) {
            log.info((Object)("Vocabulary size: " + vocab.size()));
        }
        TestVocabulary.doRoundTripTest((Vocabulary)vocab);
        TestVocabulary.assertNotNull((Object)vocab.get((Value)RDF.TYPE));
        TestVocabulary.assertEquals((Object)RDF.TYPE, (Object)vocab.asValue(vocab.get((Value)RDF.TYPE)));
        TestVocabulary.assertNull((Object)vocab.get((Value)new URIImpl("http://www.bigdata.com/unknown-uri")));
        int nfound = 0;
        Iterator itr = vocab.values();
        while (itr.hasNext()) {
            BigdataValue v = (BigdataValue)itr.next();
            TestVocabulary.assertNotNull((Object)v.getIV());
            TestVocabulary.assertTrue((boolean)v.getIV().hasValue());
            TestVocabulary.assertEquals((Object)v, (Object)vocab.asValue(v.getIV()));
            TestVocabulary.assertNotNull((Object)vocab.getConstant((Value)v));
            TestVocabulary.assertEquals((Object)v.getIV(), (Object)vocab.getConstant((Value)v).get());
            ++nfound;
        }
        TestVocabulary.assertEquals((int)nfound, (int)vocab.size());
    }

    static void doRoundTripTest(Vocabulary expected) {
        byte[] data = SerializerUtil.serialize((Object)expected);
        Vocabulary actual = (Vocabulary)SerializerUtil.deserialize((byte[])data);
        TestVocabulary.assertSameVocabulary(expected, actual);
    }

    public static void assertSameVocabulary(Vocabulary expected, Vocabulary actual) {
        TestVocabulary.assertEquals((String)"size", (int)expected.size(), (int)actual.size());
        Iterator itre = expected.values();
        while (itre.hasNext()) {
            Value value = (Value)itre.next();
            if (log.isInfoEnabled()) {
                log.info((Object)value.toString());
            }
            TestVocabulary.assertEquals((Object)expected.get(value), (Object)expected.get(value));
        }
    }

    private static class BigVocabulary
    extends RDFSVocabulary {
        public BigVocabulary() {
        }

        public BigVocabulary(String namespace) {
            super(namespace);
        }

        protected void addValues() {
            super.addValues();
            this.addDecl(new SampleDecl());
        }

        private static class SampleDecl
        implements VocabularyDecl {
            private static final String NAMESPACE = "http://sample.com/rdf#";
            private final URI[] uris = new URI[20000];

            public SampleDecl() {
                for (int i = 0; i < this.uris.length; ++i) {
                    this.uris[i] = new URIImpl(NAMESPACE + i);
                }
            }

            public Iterator<URI> values() {
                return Collections.unmodifiableList(Arrays.asList(this.uris)).iterator();
            }
        }
    }
}

