/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.Journal;
import com.bigdata.journal.TestHelper;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import java.util.Properties;
import junit.framework.TestCase;
import junit.framework.TestCase2;

public abstract class AbstractBigdataSailTestCase
extends TestCase2 {
    private long begin;
    private Properties m_properties;

    public AbstractBigdataSailTestCase() {
    }

    public AbstractBigdataSailTestCase(String name) {
        super(name);
    }

    protected void setUp(ProxyBigdataSailTestCase testCase) throws Exception {
        this.begin = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info((Object)("\n\n================:BEGIN:" + testCase.getName() + ":BEGIN:===================="));
        }
    }

    protected void tearDown(ProxyBigdataSailTestCase testCase) throws Exception {
        long elapsed = System.currentTimeMillis() - this.begin;
        if (log.isInfoEnabled()) {
            log.info((Object)("\n================:END:" + testCase.getName() + " (" + elapsed + "ms):END:====================\n"));
        }
        TestHelper.checkJournalsClosed((TestCase)testCase, (TestCase)this);
    }

    public Properties getProperties() {
        if (this.m_properties == null) {
            this.m_properties = new Properties(super.getProperties());
            this.m_properties.setProperty(Journal.Options.COLLECT_PLATFORM_STATISTICS, "false");
            this.m_properties.setProperty(Journal.Options.COLLECT_QUEUE_STATISTICS, "false");
            this.m_properties.setProperty(Journal.Options.HTTPD_PORT, "-1");
            this.m_properties.setProperty(BigdataSail.Options.BUFFER_MODE, BufferMode.Disk.toString());
            if (this.m_properties.get(BigdataSail.Options.FILE) == null) {
                this.m_properties.setProperty(BigdataSail.Options.CREATE_TEMP_FILE, "true");
                this.m_properties.setProperty(BigdataSail.Options.DELETE_ON_EXIT, "true");
            }
        }
        return new Properties(this.m_properties);
    }

    protected void checkIfProxy() {
        if (this instanceof ProxyBigdataSailTestCase) {
            throw new AssertionError();
        }
    }

    protected abstract BigdataSail getSail(Properties var1);

    protected abstract BigdataSail reopenSail(BigdataSail var1);
}

