/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.BindingImpl;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.openrdf.sail.SailException;

public class DavidsTestBOps
extends ProxyBigdataSailTestCase {
    private static final Logger log = Logger.getLogger(DavidsTestBOps.class);

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public DavidsTestBOps() {
    }

    public DavidsTestBOps(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImplementationDefinedDefaultGraph() throws Exception {
        BigdataSail sail = this.getTheSail();
        ValueFactory vf = sail.getValueFactory();
        try (RepositoryConnection cxn = this.getRepositoryConnection(sail);){
            String ns = "http://xyz.com/test#";
            String kb = String.format("<%ss> <%sp> <%so> .", "http://xyz.com/test#", "http://xyz.com/test#", "http://xyz.com/test#");
            String qs = String.format("select ?p ?o where { <%ss> ?p ?o .}", "http://xyz.com/test#");
            Resource[] graphs = new Resource[]{vf.createURI(String.format("%sg1", "http://xyz.com/test#")), vf.createURI(String.format("%sg2", "http://xyz.com/test#"))};
            Collection<BindingSet> expected = this.getExpected(this.createBindingSet(new Binding[]{new BindingImpl("p", (Value)new URIImpl(String.format("%sp", "http://xyz.com/test#"))), new BindingImpl("o", (Value)new URIImpl(String.format("%so", "http://xyz.com/test#")))}));
            this.run(sail, cxn, kb, graphs, qs, expected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExplicitDefaultGraph() throws Exception {
        BigdataSail sail = this.getTheSail();
        ValueFactory vf = sail.getValueFactory();
        try (RepositoryConnection cxn = this.getRepositoryConnection(sail);){
            String ns = "http://xyz.com/test#";
            String kb = String.format("<%ss> <%sp> <%so> .", ns, ns, ns);
            String qs = String.format("select ?p ?o from <%sg1> from <%sg2> where { <%ss> ?p ?o .}", ns, ns, ns);
            Resource[] graphs = new Resource[]{vf.createURI(String.format("%sg1", ns)), vf.createURI(String.format("%sg2", ns))};
            Collection<BindingSet> expected = this.getExpected(this.createBindingSet(new Binding[]{new BindingImpl("p", (Value)new URIImpl(String.format("%sp", ns))), new BindingImpl("o", (Value)new URIImpl(String.format("%so", ns)))}));
            this.run(sail, cxn, kb, graphs, qs, expected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNamedGraphNoGraphKeyword1() throws Exception {
        BigdataSail sail = this.getTheSail();
        ValueFactory vf = sail.getValueFactory();
        try (RepositoryConnection cxn = this.getRepositoryConnection(sail);){
            String ns = "http://xyz.com/test#";
            String kb = String.format("<%ss> <%sp> <%so> .", ns, ns, ns);
            String qs = String.format("select ?s from named <%sg2> where { ?s ?p ?o .}", ns);
            Resource[] graphs = new Resource[]{vf.createURI(String.format("%sg1", ns)), vf.createURI(String.format("%sg2", ns))};
            Collection<BindingSet> expected = this.getExpected(new BindingSet[0]);
            this.run(sail, cxn, kb, graphs, qs, expected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNamedGraphNoGraphKeyword2() throws Exception {
        BigdataSail sail = this.getTheSail();
        ValueFactory vf = sail.getValueFactory();
        try (RepositoryConnection cxn = this.getRepositoryConnection(sail);){
            String ns = "http://xyz.com/test#";
            String kb = String.format("<%ss> <%sp> <%so> .", ns, ns, ns);
            String qs = String.format("select ?s from named <%sg1> from named <%sg2> where { ?s ?p ?o .}", ns, ns);
            Resource[] graphs = new Resource[]{vf.createURI(String.format("%sg1", ns)), vf.createURI(String.format("%sg2", ns))};
            Collection<BindingSet> expected = this.getExpected(new BindingSet[0]);
            this.run(sail, cxn, kb, graphs, qs, expected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExplicitDefaultAndNamedGraphNoGraphKeyword() throws Exception {
        BigdataSail sail = this.getTheSail();
        ValueFactory vf = sail.getValueFactory();
        try (RepositoryConnection cxn = this.getRepositoryConnection(sail);){
            String ns = "http://xyz.com/test#";
            String kb = String.format("<%ss> <%sp> <%so> .", ns, ns, ns);
            String qs = String.format("select ?s from <%sg1> from named <%sg2> where { ?s ?p ?o .}", ns, ns);
            Resource[] graphs = new Resource[]{vf.createURI(String.format("%sg1", ns)), vf.createURI(String.format("%sg2", ns))};
            Collection<BindingSet> expected = this.getExpected(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)new URIImpl(String.format("%ss", ns)))}));
            this.run(sail, cxn, kb, graphs, qs, expected);
        }
    }

    private BigdataSail getTheSail() throws SailException {
        BigdataSail sail = this.getSail();
        sail.initialize();
        return sail;
    }

    private RepositoryConnection getRepositoryConnection(BigdataSail sail) throws RepositoryException {
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        BigdataSailRepositoryConnection cxn = repo.getConnection();
        cxn.setAutoCommit(false);
        return cxn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void run(BigdataSail sail, RepositoryConnection rc, String kb, Resource[] graphs, String qs, Collection<BindingSet> expected) {
        if (!((BigdataSailRepositoryConnection)rc).getSailConnection().isQuads()) {
            log.info((Object)"This test requires quads.");
            return;
        }
        try {
            for (Resource g : graphs) {
                this.load(rc, kb, g);
            }
            this.compare(this.query(rc, qs), expected);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            try {
                if (null != rc) {
                    rc.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (null != sail) {
                    sail.__tearDownUnitTest();
                }
            }
        }
    }

    private void load(RepositoryConnection rc, String kb, Resource g) throws RepositoryException, RDFParseException, IOException {
        rc.add((InputStream)new ByteArrayInputStream(kb.toString().getBytes("UTF-8")), "http://xyz.com/test", RDFFormat.TURTLE, new Resource[]{g});
        rc.commit();
    }

    private TupleQueryResult query(RepositoryConnection rc, String qs) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        return rc.prepareTupleQuery(QueryLanguage.SPARQL, qs).evaluate();
    }

    private Collection<BindingSet> getExpected(BindingSet ... bindingSets) {
        LinkedList<BindingSet> expected = new LinkedList<BindingSet>();
        for (BindingSet bs : bindingSets) {
            expected.add(bs);
        }
        return expected;
    }
}

