/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.sail.AbstractBigdataSailTestCase;
import com.bigdata.rdf.sail.BigdataSail;
import info.aduna.iteration.CloseableIteration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import junit.extensions.proxy.IProxyTest;
import junit.framework.Test;
import org.openrdf.model.Resource;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;

public abstract class ProxyBigdataSailTestCase
extends AbstractBigdataSailTestCase
implements IProxyTest {
    private Test m_delegate = null;
    private int startupActiveThreads = 0;
    private static boolean s_checkThreads = true;

    public ProxyBigdataSailTestCase() {
    }

    public ProxyBigdataSailTestCase(String name) {
        super(name);
    }

    public void setDelegate(Test delegate) {
        this.m_delegate = delegate;
    }

    public Test getDelegate() throws IllegalStateException {
        return this.m_delegate;
    }

    public AbstractBigdataSailTestCase getOurDelegate() {
        if (this.m_delegate == null) {
            String testClass = System.getProperty("testClass");
            if (testClass == null) {
                throw new IllegalStateException("testClass: property not defined, could not configure delegate.");
            }
            try {
                Class<?> cl = Class.forName(testClass);
                this.m_delegate = (Test)cl.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        if (this.m_delegate instanceof AbstractBigdataSailTestCase) {
            return (AbstractBigdataSailTestCase)this.m_delegate;
        }
        throw new IllegalStateException("The delegate MUST extend " + AbstractBigdataSailTestCase.class.getName() + ", not " + this.m_delegate.getClass().getName());
    }

    protected void setUp() throws Exception {
        this.startupActiveThreads = Thread.currentThread().getThreadGroup().activeCount();
        this.getOurDelegate().setUp(this);
    }

    protected void tearDown() throws Exception {
        ThreadGroup grp;
        int tearDownActiveThreads;
        this.getOurDelegate().tearDown(this);
        if (s_checkThreads && this.startupActiveThreads != (tearDownActiveThreads = (grp = Thread.currentThread().getThreadGroup()).activeCount())) {
            Thread[] threads = new Thread[tearDownActiveThreads];
            grp.enumerate(threads);
            StringBuilder info = new StringBuilder();
            boolean first = true;
            for (Thread t : threads) {
                if (t == null) continue;
                if (!first) {
                    info.append(',');
                }
                info.append("[" + t.getName() + "]");
                first = false;
            }
            String failMessage = "Threads left active after task: test=" + this.getName() + ", delegate=" + ((Object)((Object)this.getOurDelegate())).getClass().getName() + ", startupCount=" + this.startupActiveThreads + ", teardownCount=" + tearDownActiveThreads + ", thisThread=" + Thread.currentThread().getName() + ", threads: " + info;
            if (grp.activeCount() != this.startupActiveThreads) {
                log.error((Object)failMessage);
            }
            for (int i = 0; i < 20; ++i) {
                Thread.sleep(100L);
                if (grp.activeCount() != this.startupActiveThreads) break;
            }
        }
        super.tearDown();
    }

    @Override
    public Properties getProperties() {
        return this.getOurDelegate().getProperties();
    }

    protected BigdataSail getSail() {
        return this.getOurDelegate().getSail(this.getProperties());
    }

    @Override
    protected BigdataSail getSail(Properties properties) {
        return this.getOurDelegate().getSail(properties);
    }

    @Override
    protected BigdataSail reopenSail(BigdataSail sail) {
        return this.getOurDelegate().reopenSail(sail);
    }

    public static void assertSameIterationAnyOrder(Resource[] expected, CloseableIteration<?, ? extends Exception> actual) throws Exception {
        ProxyBigdataSailTestCase.assertSameIterationAnyOrder("", expected, actual);
    }

    public static void assertSameIterationAnyOrder(String msg, Resource[] expected, CloseableIteration<?, ? extends Exception> actual) throws Exception {
        int j;
        int nrange = expected.length;
        HashMap<Resource, Resource> range = new HashMap<Resource, Resource>();
        for (j = 0; j < nrange; ++j) {
            range.put(expected[j], expected[j]);
        }
        for (j = 0; j < nrange; ++j) {
            Object actualObject;
            if (!actual.hasNext()) {
                ProxyBigdataSailTestCase.fail((String)(msg + ": Index exhausted while expecting more object(s)" + ": index=" + j));
            }
            if (range.remove(actualObject = actual.next()) != null) continue;
            ProxyBigdataSailTestCase.fail((String)("Object not expected: index=" + j + ", object=" + actualObject));
        }
        if (actual.hasNext()) {
            ProxyBigdataSailTestCase.fail((String)"Iterator will deliver too many objects.");
        }
    }

    protected BindingSet createBindingSet(Binding ... bindings) {
        QueryBindingSet bindingSet = new QueryBindingSet();
        if (bindings != null) {
            for (Binding b : bindings) {
                bindingSet.addBinding(b);
            }
        }
        return bindingSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compare(TupleQueryResult actual, Collection<BindingSet> expected) throws QueryEvaluationException {
        try {
            LinkedList<BindingSet> extraResults = new LinkedList<BindingSet>();
            Collection<Object> missingResults = new LinkedList();
            int resultCount = 0;
            int nmatched = 0;
            while (actual.hasNext()) {
                BindingSet bindingSet = (BindingSet)actual.next();
                ++resultCount;
                boolean bl = false;
                if (log.isInfoEnabled()) {
                    log.info((Object)bindingSet);
                }
                Iterator<BindingSet> it = expected.iterator();
                while (it.hasNext()) {
                    if (!it.next().equals((Object)bindingSet)) continue;
                    it.remove();
                    bl = true;
                    ++nmatched;
                    break;
                }
                if (bl) continue;
                extraResults.add(bindingSet);
            }
            missingResults = expected;
            for (BindingSet bindingSet : extraResults) {
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("extra result: " + bindingSet));
            }
            for (BindingSet bindingSet : missingResults) {
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("missing result: " + bindingSet));
            }
            if (!extraResults.isEmpty() || !missingResults.isEmpty()) {
                ProxyBigdataSailTestCase.fail((String)("matchedResults=" + nmatched + ", extraResults=" + extraResults.size() + ", missingResults=" + missingResults.size()));
            }
        }
        finally {
            actual.close();
        }
    }
}

