/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

public class StressTest_ClosedByInterrupt_RW
extends TestCase {
    private static final Logger log = Logger.getLogger(StressTest_ClosedByInterrupt_RW.class);
    private static final int NUM_INSERT_DELETE_LOOPS = 10;
    private static final int NUM_INSERTS_PER_LOOP = 200000;
    private static final int NUM_DELETES_PER_LOOP = 23000;
    private static final long MILLIS_BETWEEN_INSERTS = -1L;
    private static final long MILLIS_BETWEEN_DELETES = -1L;
    private static final int NUM_STATEMENTS_PER_INSERT = 50;
    private static final int NUM_SELECTS = 5000;
    private static final int NUM_STATEMENTS_PER_SELECT = 23000;
    private static final long MILLIS_BETWEEN_QUERY_BURSTS = 1000L;
    private static boolean HALT_ON_ERROR = true;
    private volatile boolean stopRequested = false;

    public StressTest_ClosedByInterrupt_RW() {
    }

    public StressTest_ClosedByInterrupt_RW(String name) {
        super(name);
    }

    private void snooze(long millis) throws InterruptedException {
        if (millis > 0L) {
            Thread.sleep(millis);
        }
    }

    public void test() throws RepositoryException, InterruptedException {
        File jnlFile = new File("interrupted.jnl");
        if (jnlFile.exists()) {
            jnlFile.delete();
        }
        Properties props = new Properties();
        props.setProperty("com.bigdata.rdf.sail.namespace", "emc.srm.topology.kb");
        props.setProperty("com.bigdata.journal.AbstractJournal.bufferMode", "DiskRW");
        props.setProperty("com.bigdata.btree.writeRetentionQueue.capacity", "4000");
        props.setProperty("com.bigdata.btree.BTree.branchingFactor", "128");
        props.setProperty("com.bigdata.service.AbstractTransactionService.minReleaseAge", "1");
        props.setProperty("com.bigdata.rdf.store.AbstractTripleStore.textIndex", "false");
        props.setProperty("com.bigdata.rdf.rules.InferenceEngine.forwardChainOwlTransitiveProperty", "false");
        props.setProperty("com.bigdata.rdf.rules.InferenceEngine.forwardChainOwlSameAsClosure", "false");
        props.setProperty("com.bigdata.rdf.rules.InferenceEngine.forwardChainOwlSameAsProperties", "false");
        props.setProperty("com.bigdata.rdf.rules.InferenceEngine.forwardChainOwlInverseOf", "false");
        props.setProperty("com.bigdata.rdf.rules.InferenceEngine.forwardChainOwlEquivalentClass", "false");
        props.setProperty("com.bigdata.rdf.rules.InferenceEngine.forwardChainOwlEquivalentProperty", "false");
        props.setProperty("com.bigdata.rdf.rules.InferenceEngine.forwardChainOwlHasValue", "false");
        props.setProperty("com.bigdata.rdf.rules.InferenceEngine.forwardChainRdfTypeRdfsResource", "false");
        props.setProperty("com.bigdata.rdf.store.AbstractTripleStore.axiomsClass", "com.bigdata.rdf.axioms.NoAxioms");
        props.setProperty("com.bigdata.rdf.sail.truthMaintenance", "false");
        props.setProperty("com.bigdata.rdf.store.AbstractTripleStore.justify", "false");
        props.setProperty("com.bigdata.rdf.store.AbstractTripleStore.statementIdentifiers", "false");
        props.setProperty("com.bigdata.rdf.store.AbstractTripleStore.quadsMode", "true");
        props.setProperty("com.bigdata.journal.AbstractJournal.maximumExtent", "209715200");
        props.setProperty("com.bigdata.service.IBigdataClient.collectPlatformStatistics", "false");
        props.setProperty("com.bigdata.service.IBigdataClient.httpdPort", "-1");
        props.setProperty("com.bigdata.rdf.sail.bufferCapacity", "100000");
        props.setProperty("com.bigdata.rdf.store.AbstractTripleStore.bloomFilter", "false");
        props.setProperty(BigdataSail.Options.CREATE_TEMP_FILE, Boolean.FALSE.toString());
        props.setProperty(BigdataSail.Options.FILE, jnlFile.toString());
        BigdataSail sail = new BigdataSail(props);
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        repo.initialize();
        InsertDeleteRunner mapper = new InsertDeleteRunner(repo);
        ReadOnlyRunner mdp = new ReadOnlyRunner(repo);
        Thread mapperThread = new Thread(mapper);
        Thread mdpThread = new Thread(mdp);
        mapperThread.start();
        mdpThread.start();
        mapperThread.join();
        System.out.println("Mapper is done");
        this.stopRequested = true;
        mdpThread.join();
        System.out.println("MDP is done");
        repo.shutDown();
        System.out.println("Repository has shut down");
    }

    private void closeNoException(RepositoryConnection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (RepositoryException e) {
                log.error((Object)"closeNoException(conn)", (Throwable)e);
            }
        }
    }

    private void closeNoException(TupleQueryResult result) {
        if (result != null) {
            try {
                result.close();
            }
            catch (QueryEvaluationException e) {
                log.error((Object)"closeNoException(result)", (Throwable)e);
            }
        }
    }

    private void printError(String message, Throwable cause) {
        log.error((Object)message, cause);
        if (HALT_ON_ERROR) {
            System.exit(123);
        }
    }

    private class ReadOnlyRunner
    implements Runnable {
        private final BigdataSailRepository repo;

        public ReadOnlyRunner(BigdataSailRepository repo) {
            this.repo = repo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BigdataSailRepositoryConnection conn = null;
            TupleQueryResult result = null;
            int loop = 0;
            while (!StressTest_ClosedByInterrupt_RW.this.stopRequested) {
                try {
                    System.out.println("[Read      ] snooze");
                    StressTest_ClosedByInterrupt_RW.this.snooze(1000L);
                    System.out.println("[Read      ] enter loop " + loop);
                    for (int invocation = 0; invocation < 5000; ++invocation) {
                        conn = this.repo.getReadOnlyConnection();
                        conn.setAutoCommit(false);
                        String sparql = "SELECT ?s WHERE { ?s ?p ?o } LIMIT 23000";
                        TupleQuery query = conn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT ?s WHERE { ?s ?p ?o } LIMIT 23000");
                        result = query.evaluate();
                        ArrayList<String> duds = new ArrayList<String>();
                        while (result.hasNext()) {
                            BindingSet bindingSet = (BindingSet)result.next();
                            for (Binding b : bindingSet) {
                                if (b.getValue() == null) continue;
                                duds.add(b.getValue().stringValue());
                            }
                        }
                        result.close();
                        result = null;
                        conn.close();
                        conn = null;
                    }
                }
                catch (Throwable t) {
                    try {
                        StressTest_ClosedByInterrupt_RW.this.printError("Read Only threw in loop " + loop, t);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        StressTest_ClosedByInterrupt_RW.this.closeNoException(result);
                        StressTest_ClosedByInterrupt_RW.this.closeNoException(conn);
                    }
                }
                StressTest_ClosedByInterrupt_RW.this.closeNoException(result);
                StressTest_ClosedByInterrupt_RW.this.closeNoException((RepositoryConnection)conn);
                System.out.println("[Read      ] leave loop " + loop);
                ++loop;
            }
        }
    }

    private class InsertDeleteRunner
    implements Runnable {
        private final BigdataSailRepository repo;

        public InsertDeleteRunner(BigdataSailRepository repo) {
            this.repo = repo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (int loop = 0; loop < 10; ++loop) {
                int index;
                System.out.println("[Read/Write] enter loop " + loop);
                BigdataSailRepositoryConnection conn = null;
                try {
                    System.out.println("[Read/Write] inserting ...");
                    conn = this.repo.getConnection();
                    conn.setAutoCommit(false);
                    for (index = 0; index < 200000; ++index) {
                        this.doInsert((RepositoryConnection)conn, loop, index);
                        StressTest_ClosedByInterrupt_RW.this.snooze(-1L);
                    }
                    conn.commit();
                    conn.close();
                    conn = null;
                }
                catch (Throwable t) {
                    try {
                        StressTest_ClosedByInterrupt_RW.this.printError("Read/Write threw on insert in loop " + loop, t);
                    }
                    catch (Throwable throwable) {
                        StressTest_ClosedByInterrupt_RW.this.closeNoException(conn);
                        throw throwable;
                    }
                    StressTest_ClosedByInterrupt_RW.this.closeNoException((RepositoryConnection)conn);
                }
                StressTest_ClosedByInterrupt_RW.this.closeNoException((RepositoryConnection)conn);
                try {
                    System.out.println("[Read/Write] deleting ...");
                    conn = this.repo.getConnection();
                    conn.setAutoCommit(false);
                    for (index = 0; index < 23000; ++index) {
                        this.doDelete((RepositoryConnection)conn, loop, index);
                        StressTest_ClosedByInterrupt_RW.this.snooze(-1L);
                    }
                    conn.commit();
                    conn.close();
                    conn = null;
                }
                catch (Throwable t) {
                    StressTest_ClosedByInterrupt_RW.this.printError("Read/Write threw on delete in loop " + loop, t);
                }
                finally {
                    StressTest_ClosedByInterrupt_RW.this.closeNoException((RepositoryConnection)conn);
                }
                System.out.println("[Read/Write] leave loop " + loop);
            }
        }

        private void doInsert(RepositoryConnection conn, int loop, int index) throws RepositoryException {
            ValueFactory vf = conn.getValueFactory();
            URI c = vf.createURI("context:loop:" + loop + ":item:" + index);
            URI s = vf.createURI("subject:loop:" + loop + ":item:" + index);
            for (int x = 0; x < 50; ++x) {
                URI p = vf.createURI("predicate:" + x);
                Literal o = vf.createLiteral("SomeValue");
                conn.add((Resource)s, p, (Value)o, new Resource[]{c});
            }
        }

        private void doDelete(RepositoryConnection conn, int loop, int index) throws RepositoryException {
            ValueFactory vf = conn.getValueFactory();
            URI context = vf.createURI("context:loop:" + loop + ":item:" + index);
            Collection<Statement> statements = this.getStatementsForContext(conn, context);
            for (Statement statement : statements) {
                conn.remove(statement, new Resource[]{context});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection<Statement> getStatementsForContext(RepositoryConnection conn, URI context) throws RepositoryException {
            ArrayList<Statement> statements = new ArrayList<Statement>();
            try (RepositoryResult res = null;){
                res = conn.getStatements(null, null, null, false, new Resource[]{context});
                while (res.hasNext()) {
                    statements.add((Statement)res.next());
                }
            }
            return statements;
        }
    }
}

