/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.BindingImpl;

public class TestBOps
extends ProxyBigdataSailTestCase {
    private static final Logger log = Logger.getLogger(TestBOps.class);

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "true");
        return props;
    }

    public TestBOps() {
    }

    public TestBOps(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleJoin() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn.setAutoCommit(false);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                String ns = "http://www.bigdata.com/rdf#";
                URIImpl mike = new URIImpl("http://www.bigdata.com/rdf#Mike");
                URIImpl bryan = new URIImpl("http://www.bigdata.com/rdf#Bryan");
                URIImpl person = new URIImpl("http://www.bigdata.com/rdf#Person");
                URIImpl likes = new URIImpl("http://www.bigdata.com/rdf#likes");
                URIImpl rdf = new URIImpl("http://www.bigdata.com/rdf#RDF");
                LiteralImpl l1 = new LiteralImpl("Mike");
                LiteralImpl l2 = new LiteralImpl("Bryan");
                cxn.setNamespace("ns", "http://www.bigdata.com/rdf#");
                cxn.add((Resource)mike, RDF.TYPE, (Value)person, new Resource[0]);
                cxn.add((Resource)mike, (URI)likes, (Value)rdf, new Resource[0]);
                cxn.add((Resource)mike, RDFS.LABEL, (Value)l1, new Resource[0]);
                cxn.add((Resource)bryan, RDF.TYPE, (Value)person, new Resource[0]);
                cxn.add((Resource)bryan, (URI)likes, (Value)rdf, new Resource[0]);
                cxn.add((Resource)bryan, RDFS.LABEL, (Value)l2, new Resource[0]);
                cxn.flush();
                cxn.commit();
                if (log.isInfoEnabled()) {
                    log.info((Object)("\n" + cxn.getTripleStore().dumpStore()));
                }
                String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX ns: <http://www.bigdata.com/rdf#> select * WHERE {   ?s rdf:type ns:Person .   ?s ns:likes ?likes .   ?s rdfs:label ?label . }";
                TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX ns: <http://www.bigdata.com/rdf#> select * WHERE {   ?s rdf:type ns:Person .   ?s ns:likes ?likes .   ?s rdfs:label ?label . }");
                TupleQueryResult result = tupleQuery.evaluate();
                LinkedList<BindingSet> solution = new LinkedList<BindingSet>();
                solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)mike), new BindingImpl("likes", (Value)rdf), new BindingImpl("label", (Value)l1)}));
                solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)bryan), new BindingImpl("likes", (Value)rdf), new BindingImpl("label", (Value)l2)}));
                this.compare(result, solution);
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleConstraint() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn.setAutoCommit(false);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                ValueFactory vf = sail.getValueFactory();
                String ns = "http://www.bigdata.com/rdf#";
                URIImpl jill = new URIImpl("http://www.bigdata.com/rdf#Jill");
                URIImpl jane = new URIImpl("http://www.bigdata.com/rdf#Jane");
                URIImpl person = new URIImpl("http://www.bigdata.com/rdf#Person");
                URIImpl age = new URIImpl("http://www.bigdata.com/rdf#age");
                URIImpl IQ = new URIImpl("http://www.bigdata.com/rdf#IQ");
                LiteralImpl l1 = new LiteralImpl("Jill");
                LiteralImpl l2 = new LiteralImpl("Jane");
                Literal age1 = vf.createLiteral(20);
                Literal age2 = vf.createLiteral(30);
                Literal IQ1 = vf.createLiteral(130);
                Literal IQ2 = vf.createLiteral(140);
                cxn.setNamespace("ns", "http://www.bigdata.com/rdf#");
                cxn.add((Resource)jill, RDF.TYPE, (Value)person, new Resource[0]);
                cxn.add((Resource)jill, RDFS.LABEL, (Value)l1, new Resource[0]);
                cxn.add((Resource)jill, (URI)age, (Value)age1, new Resource[0]);
                cxn.add((Resource)jill, (URI)IQ, (Value)IQ1, new Resource[0]);
                cxn.add((Resource)jane, RDF.TYPE, (Value)person, new Resource[0]);
                cxn.add((Resource)jane, RDFS.LABEL, (Value)l2, new Resource[0]);
                cxn.add((Resource)jane, (URI)age, (Value)age2, new Resource[0]);
                cxn.add((Resource)jane, (URI)IQ, (Value)IQ2, new Resource[0]);
                cxn.flush();
                cxn.commit();
                if (log.isInfoEnabled()) {
                    log.info((Object)("\n" + cxn.getTripleStore().dumpStore()));
                }
                String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX ns: <http://www.bigdata.com/rdf#> select * WHERE {   ?s rdf:type ns:Person .   ?s ns:age ?age .   ?s ns:IQ ?iq .   ?s rdfs:label ?label .   FILTER( ?age < 25 && ?iq > 125 ) . }";
                TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX ns: <http://www.bigdata.com/rdf#> select * WHERE {   ?s rdf:type ns:Person .   ?s ns:age ?age .   ?s ns:IQ ?iq .   ?s rdfs:label ?label .   FILTER( ?age < 25 && ?iq > 125 ) . }");
                TupleQueryResult result = tupleQuery.evaluate();
                LinkedList<BindingSet> solution = new LinkedList<BindingSet>();
                solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)jill), new BindingImpl("age", (Value)age1), new BindingImpl("iq", (Value)IQ1), new BindingImpl("label", (Value)l1)}));
                this.compare(result, solution);
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleOptional() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn.setAutoCommit(false);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                String ns = "http://www.bigdata.com/rdf#";
                URIImpl mike = new URIImpl("http://www.bigdata.com/rdf#Mike");
                URIImpl bryan = new URIImpl("http://www.bigdata.com/rdf#Bryan");
                URIImpl person = new URIImpl("http://www.bigdata.com/rdf#Person");
                URIImpl likes = new URIImpl("http://www.bigdata.com/rdf#likes");
                URIImpl rdf = new URIImpl("http://www.bigdata.com/rdf#RDF");
                LiteralImpl l1 = new LiteralImpl("Mike");
                cxn.setNamespace("ns", "http://www.bigdata.com/rdf#");
                cxn.add((Resource)mike, RDF.TYPE, (Value)person, new Resource[0]);
                cxn.add((Resource)mike, (URI)likes, (Value)rdf, new Resource[0]);
                cxn.add((Resource)mike, RDFS.LABEL, (Value)l1, new Resource[0]);
                cxn.add((Resource)bryan, RDF.TYPE, (Value)person, new Resource[0]);
                cxn.add((Resource)bryan, (URI)likes, (Value)rdf, new Resource[0]);
                cxn.flush();
                cxn.commit();
                if (log.isInfoEnabled()) {
                    log.info((Object)("\n" + cxn.getTripleStore().dumpStore()));
                }
                String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX ns: <http://www.bigdata.com/rdf#> select * WHERE {   ?s rdf:type ns:Person .   ?s ns:likes ?likes .   OPTIONAL { ?s rdfs:label ?label . } }";
                TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX ns: <http://www.bigdata.com/rdf#> select * WHERE {   ?s rdf:type ns:Person .   ?s ns:likes ?likes .   OPTIONAL { ?s rdfs:label ?label . } }");
                TupleQueryResult result = tupleQuery.evaluate();
                LinkedList<BindingSet> solution = new LinkedList<BindingSet>();
                solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)mike), new BindingImpl("likes", (Value)rdf), new BindingImpl("label", (Value)l1)}));
                solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)bryan), new BindingImpl("likes", (Value)rdf)}));
                this.compare(result, solution);
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrEquals() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn.setAutoCommit(false);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                String ns = "http://www.bigdata.com/rdf#";
                URIImpl mike = new URIImpl("http://www.bigdata.com/rdf#Mike");
                URIImpl bryan = new URIImpl("http://www.bigdata.com/rdf#Bryan");
                URIImpl martyn = new URIImpl("http://www.bigdata.com/rdf#Martyn");
                URIImpl person = new URIImpl("http://www.bigdata.com/rdf#Person");
                URIImpl p = new URIImpl("http://www.bigdata.com/rdf#p");
                LiteralImpl l1 = new LiteralImpl("Mike");
                LiteralImpl l2 = new LiteralImpl("Bryan");
                LiteralImpl l3 = new LiteralImpl("Martyn");
                cxn.setNamespace("ns", "http://www.bigdata.com/rdf#");
                cxn.add((Resource)mike, RDF.TYPE, (Value)person, new Resource[0]);
                cxn.add((Resource)mike, RDFS.LABEL, (Value)l1, new Resource[0]);
                cxn.add((Resource)bryan, RDF.TYPE, (Value)person, new Resource[0]);
                cxn.add((Resource)bryan, RDFS.COMMENT, (Value)l2, new Resource[0]);
                cxn.add((Resource)martyn, RDF.TYPE, (Value)person, new Resource[0]);
                cxn.add((Resource)martyn, (URI)p, (Value)l3, new Resource[0]);
                cxn.flush();
                cxn.commit();
                if (log.isInfoEnabled()) {
                    log.info((Object)("\n" + cxn.getTripleStore().dumpStore()));
                }
                String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX ns: <http://www.bigdata.com/rdf#> select * WHERE {   ?s rdf:type ns:Person .   ?s ?p ?label .   FILTER ( ?p = rdfs:label || ?p = rdfs:comment ) . }";
                TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                TupleQueryResult result = tupleQuery.evaluate();
                LinkedList<BindingSet> solution = new LinkedList<BindingSet>();
                solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)mike), new BindingImpl("p", (Value)RDFS.LABEL), new BindingImpl("label", (Value)l1)}));
                solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)bryan), new BindingImpl("p", (Value)RDFS.COMMENT), new BindingImpl("label", (Value)l2)}));
                this.compare(result, solution);
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcat() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn.setAutoCommit(false);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                String ns = "http://www.bigdata.com/rdf#";
                URIImpl foo = new URIImpl("http://www.bigdata.com/rdf#foo");
                URIImpl bar = new URIImpl("http://www.bigdata.com/rdf#bar");
                URIImpl plain = new URIImpl("http://www.bigdata.com/rdf#plain");
                URIImpl language = new URIImpl("http://www.bigdata.com/rdf#language");
                URIImpl string = new URIImpl("http://www.bigdata.com/rdf#string");
                LiteralImpl fooPlain = new LiteralImpl("foo");
                LiteralImpl fooLanguage = new LiteralImpl("foo", "en");
                LiteralImpl fooString = new LiteralImpl("foo", XMLSchema.STRING);
                LiteralImpl barPlain = new LiteralImpl("bar");
                LiteralImpl barLanguage = new LiteralImpl("bar", "en");
                LiteralImpl barString = new LiteralImpl("bar", XMLSchema.STRING);
                LiteralImpl foobarPlain = new LiteralImpl("foobar");
                LiteralImpl foobarLanguage = new LiteralImpl("foobar", "en");
                LiteralImpl foobarString = new LiteralImpl("foobar", XMLSchema.STRING);
                cxn.setNamespace("ns", "http://www.bigdata.com/rdf#");
                cxn.add((Resource)foo, (URI)plain, (Value)fooPlain, new Resource[0]);
                cxn.add((Resource)bar, (URI)plain, (Value)barPlain, new Resource[0]);
                cxn.add((Resource)foo, (URI)language, (Value)fooLanguage, new Resource[0]);
                cxn.add((Resource)bar, (URI)language, (Value)barLanguage, new Resource[0]);
                cxn.add((Resource)foo, (URI)string, (Value)fooString, new Resource[0]);
                cxn.add((Resource)bar, (URI)string, (Value)barString, new Resource[0]);
                cxn.add((Resource)plain, (URI)plain, (Value)foobarPlain, new Resource[0]);
                cxn.add((Resource)language, (URI)language, (Value)foobarLanguage, new Resource[0]);
                cxn.add((Resource)string, (URI)string, (Value)foobarString, new Resource[0]);
                cxn.add((Resource)plain, (URI)string, (Value)foobarPlain, new Resource[0]);
                cxn.add((Resource)language, (URI)plain, (Value)foobarPlain, new Resource[0]);
                cxn.add((Resource)language, (URI)string, (Value)foobarPlain, new Resource[0]);
                cxn.flush();
                cxn.commit();
                if (log.isInfoEnabled()) {
                    log.info((Object)("\n" + cxn.getTripleStore().dumpStore()));
                }
                String query = "select ?o1 ?o2 ?o3 WHERE {   ?s1 ?p1 ?o1 .   ?s2 ?p2 ?o2 .   ?p1 ?p2 ?o3 .   FILTER(concat(?o1, ?o2) = ?o3)}";
                TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                int cnt = 0;
                try (TupleQueryResult result = tupleQuery.evaluate();){
                    while (result.hasNext()) {
                        ++cnt;
                    }
                }
                TestBOps.assertEquals((int)6, (int)cnt);
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }
}

