/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.journal.BufferMode;
import com.bigdata.rdf.sail.AbstractBigdataSailTestCase;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.DavidsTestBOps;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.sail.TestBigdataValueReplacer;
import com.bigdata.rdf.sail.TestLexJoinOps;
import com.bigdata.rdf.sail.TestMaterialization;
import com.bigdata.rdf.sail.TestOptionals;
import com.bigdata.rdf.sail.TestProvenanceQuery;
import com.bigdata.rdf.sail.TestPruneBindingSets;
import com.bigdata.rdf.sail.TestQuadsAPI;
import com.bigdata.rdf.sail.TestSearchQuery;
import com.bigdata.rdf.sail.TestUnions;
import com.bigdata.rdf.sail.tck.BigdataEmbeddedFederationSparqlTest;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.ScaleOutTripleStore;
import com.bigdata.resources.ResourceManager;
import com.bigdata.service.DistributedTransactionService;
import com.bigdata.service.EmbeddedClient;
import com.bigdata.service.IBigdataClient;
import com.bigdata.service.IBigdataFederation;
import java.io.File;
import java.util.Properties;
import junit.extensions.proxy.ProxyTestSuite;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestBigdataSailEmbeddedFederationWithQuads
extends AbstractBigdataSailTestCase {
    private static final String NAMESPACE = "TestBigdataSailEmbeddedFederationWithQuads";
    private Properties properties = null;
    private IBigdataClient<?> client;
    private IBigdataFederation<?> fed;

    public TestBigdataSailEmbeddedFederationWithQuads() {
    }

    public TestBigdataSailEmbeddedFederationWithQuads(String name) {
        super(name);
    }

    public static Test suite() {
        TestBigdataSailEmbeddedFederationWithQuads delegate = new TestBigdataSailEmbeddedFederationWithQuads();
        ProxyTestSuite suite = new ProxyTestSuite((Test)delegate, "SAIL with Quads (embedded federation)");
        suite.addTestSuite(TestBigdataValueReplacer.class);
        suite.addTestSuite(TestPruneBindingSets.class);
        suite.addTestSuite(TestQuadsAPI.class);
        suite.addTestSuite(TestOptionals.class);
        suite.addTestSuite(TestSearchQuery.class);
        suite.addTestSuite(TestProvenanceQuery.class);
        suite.addTestSuite(TestUnions.class);
        suite.addTestSuite(DavidsTestBOps.class);
        suite.addTestSuite(TestLexJoinOps.class);
        suite.addTestSuite(TestMaterialization.class);
        TestSuite tckSuite = new TestSuite("Sesame 2.x TCK");
        try {
            tckSuite.addTest(BigdataEmbeddedFederationSparqlTest.suite());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        suite.addTest((Test)tckSuite);
        return suite;
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties(super.getProperties());
        properties.setProperty(BigdataSail.Options.QUADS_MODE, "true");
        properties.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        properties.setProperty(BigdataSail.Options.BUFFER_MODE, BufferMode.Transient.toString());
        properties.setProperty(EmbeddedClient.Options.NDATA_SERVICES, "1");
        properties.setProperty(EmbeddedClient.Options.DATA_DIR, NAMESPACE);
        properties.setProperty(DistributedTransactionService.Options.DATA_DIR, new File(NAMESPACE, "txService").toString());
        properties.setProperty(IBigdataClient.Options.COLLECT_PLATFORM_STATISTICS, "false");
        properties.setProperty(ResourceManager.Options.MAXIMUM_MOVES_PER_TARGET, "0");
        return properties;
    }

    @Override
    protected BigdataSail getSail(Properties properties) {
        this.properties = properties;
        return new BigdataSail(this.openTripleStore(NAMESPACE, properties));
    }

    @Override
    protected BigdataSail reopenSail(BigdataSail sail) {
        if (sail.isOpen()) {
            try {
                sail.shutDown();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.getSail(this.properties);
    }

    @Override
    protected void setUp(ProxyBigdataSailTestCase testCase) throws Exception {
        File dataDir = new File(NAMESPACE);
        if (dataDir.exists() && dataDir.isDirectory()) {
            this.recursiveDelete(dataDir);
        }
        this.client = new EmbeddedClient(this.getProperties());
        this.fed = this.client.connect();
    }

    @Override
    protected void tearDown(ProxyBigdataSailTestCase testCase) throws Exception {
        if (this.fed != null) {
            this.fed.destroy();
            this.fed = null;
        }
        if (this.client != null) {
            this.client.disconnect(true);
            this.client = null;
        }
        this.properties = null;
        super.tearDown(testCase);
    }

    private void recursiveDelete(File f) {
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            for (int i = 0; i < children.length; ++i) {
                this.recursiveDelete(children[i]);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Removing: " + f));
        }
        if (!f.delete()) {
            throw new RuntimeException("Could not remove: " + f);
        }
    }

    private AbstractTripleStore openTripleStore(String namespace, Properties properties) {
        AbstractTripleStore tripleStore = (AbstractTripleStore)this.fed.getResourceLocator().locate(namespace, 0L);
        if (tripleStore == null) {
            tripleStore = new ScaleOutTripleStore(this.fed, namespace, Long.valueOf(0L), properties);
            tripleStore.create();
        }
        return tripleStore;
    }
}

