/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.LinkedList;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.repository.RepositoryException;
import org.openrdf.sail.SailException;

public class TestBigdataValueReplacer
extends ProxyBigdataSailTestCase {
    public TestBigdataValueReplacer() {
    }

    public TestBigdataValueReplacer(String name) {
        super(name);
    }

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_dropUnusedBindings() throws RepositoryException, SailException, MalformedQueryException, QueryEvaluationException {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                cxn.setAutoCommit(false);
                cxn.add((Resource)new URIImpl("s:1"), (URI)new URIImpl("p:1"), (Value)new URIImpl("s:2"), new Resource[0]);
                String query = "select ?a ?b WHERE {?a <p:1> ?b}";
                TupleQuery q = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "select ?a ?b WHERE {?a <p:1> ?b}");
                q.setBinding("a", (Value)new URIImpl("s:1"));
                q.setBinding("b", (Value)new URIImpl("s:2"));
                q.setBinding("notused", (Value)new LiteralImpl("lit"));
                LinkedList<BindingSet> expected = new LinkedList<BindingSet>();
                MapBindingSet bset = new MapBindingSet();
                bset.addBinding("a", (Value)new URIImpl("s:1"));
                bset.addBinding("b", (Value)new URIImpl("s:2"));
                expected.add((BindingSet)bset);
                try (TupleQueryResult result = q.evaluate();){
                    this.compare(result, expected);
                }
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }
}

