/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.concurrent.AccessSemaphore;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.LocalTripleStore;
import com.bigdata.util.InnerCause;
import info.aduna.iteration.CloseableIteration;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import junit.framework.TestCase;
import junit.framework.TestCase2;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class TestBootstrapBigdataSail
extends TestCase2 {
    public TestBootstrapBigdataSail() {
    }

    public TestBootstrapBigdataSail(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_ctor_1() throws SailException, IOException {
        File file = new File("bigdata.jnl");
        if (file.exists() && !file.delete()) {
            throw new IOException("Unable to remove default file:" + file);
        }
        BigdataSail sail = new BigdataSail();
        try {
            if (!file.exists()) {
                TestBootstrapBigdataSail.fail((String)("Expected file does not exist: " + file));
            }
            sail.initialize();
            sail.shutDown();
        }
        finally {
            sail.getIndexManager().destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_ctor_2() throws SailException {
        File file = new File(this.getName() + ".jnl");
        if (file.exists() && !file.delete()) {
            TestBootstrapBigdataSail.fail((String)("Could not delete file before test: " + file));
        }
        Properties properties = new Properties();
        properties.setProperty(BigdataSail.Options.FILE, file.toString());
        BigdataSail sail = new BigdataSail(properties);
        try {
            sail.initialize();
            sail.shutDown();
        }
        finally {
            if (!file.exists()) {
                TestBootstrapBigdataSail.fail((String)("Could not locate store: " + file));
                if (!file.delete()) {
                    TestBootstrapBigdataSail.fail((String)("Could not delete file after test: " + file));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_getConnection() throws SailException {
        Properties properties = new Properties();
        properties.setProperty(BigdataSail.Options.CREATE_TEMP_FILE, "true");
        BigdataSail sail = new BigdataSail(properties);
        try {
            sail.initialize();
            BigdataSail.BigdataSailConnection conn = sail.getConnection();
            conn.close();
            sail.shutDown();
        }
        finally {
            sail.getIndexManager().destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_getConnectionAllowedExactlyOnce1_oneThread() throws SailException, InterruptedException, ExecutionException {
        Properties properties = new Properties();
        properties.setProperty(BigdataSail.Options.CREATE_TEMP_FILE, "true");
        ExecutorService service = null;
        final BigdataSail sail = new BigdataSail(properties);
        try {
            sail.initialize();
            service = Executors.newSingleThreadExecutor();
            Future<Void> f = null;
            try {
                Callable<Void> task = new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        BigdataSail.BigdataSailConnection conn1 = null;
                        BigdataSail.BigdataSailConnection conn2 = null;
                        try {
                            block7: {
                                log.info((Object)"Requesting 1st unisolated connection.");
                                conn1 = sail.getUnisolatedConnection();
                                log.info((Object)"Requesting 2nd unisolated connection.");
                                try {
                                    conn2 = sail.getUnisolatedConnection();
                                    TestCase.fail((String)"Not expecting a 2nd unisolated connection");
                                }
                                catch (IllegalStateException ex) {
                                    if (!log.isInfoEnabled()) break block7;
                                    log.info((Object)("Ignoring expected exception: " + ex));
                                }
                            }
                            Void void_ = null;
                            return void_;
                        }
                        finally {
                            if (conn1 != null) {
                                conn1.close();
                            }
                            if (conn2 != null) {
                                conn2.close();
                            }
                        }
                    }
                };
                f = service.submit(task);
                f.get();
            }
            finally {
                if (f != null) {
                    f.cancel(true);
                }
                sail.shutDown();
            }
        }
        finally {
            if (service != null) {
                service.shutdownNow();
            }
            sail.getIndexManager().destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_getConnectionAllowedExactlyOnce1_twoThreads() throws SailException, InterruptedException, ExecutionException, TimeoutException {
        Properties properties = new Properties();
        properties.setProperty(BigdataSail.Options.CREATE_TEMP_FILE, "true");
        ExecutorService service = null;
        final BigdataSail sail = new BigdataSail(properties);
        try {
            sail.initialize();
            service = Executors.newFixedThreadPool(2);
            Future<Void> f = null;
            Future<Void> f2 = null;
            final ReentrantLock lock = new ReentrantLock();
            final AtomicBoolean haveFirst = new AtomicBoolean(false);
            final AtomicBoolean releaseFirst = new AtomicBoolean(false);
            final Condition haveFirstConnection = lock.newCondition();
            final Condition releaseFirstConnection = lock.newCondition();
            try {
                Callable<Void> task1 = new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        try (BigdataSail.BigdataSailConnection conn1 = null;){
                            log.info((Object)"Requesting 1st unisolated connection.");
                            lock.lock();
                            try {
                                conn1 = sail.getUnisolatedConnection();
                                haveFirst.set(true);
                                haveFirstConnection.signal();
                                while (!releaseFirst.get()) {
                                    releaseFirstConnection.await();
                                }
                                log.info((Object)"Releasing 1st unisolated connection.");
                            }
                            finally {
                                lock.unlock();
                            }
                            Void void_ = null;
                            return void_;
                        }
                    }
                };
                Callable<Void> task2 = new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        try (BigdataSail.BigdataSailConnection conn2 = null;){
                            log.info((Object)"Requesting 2nd unisolated connection.");
                            conn2 = sail.getUnisolatedConnection();
                            log.info((Object)"Have 2nd unisolated connection");
                            Void void_ = null;
                            return void_;
                        }
                    }
                };
                f = service.submit(task1);
                lock.lock();
                try {
                    while (!haveFirst.get()) {
                        haveFirstConnection.await();
                    }
                    f2 = service.submit(task2);
                    log.info((Object)"Will instruct to release 1st connection.");
                    releaseFirst.set(true);
                    releaseFirstConnection.signal();
                }
                finally {
                    lock.unlock();
                }
                f.get(1000L, TimeUnit.MILLISECONDS);
                f2.get(1000L, TimeUnit.MILLISECONDS);
            }
            finally {
                if (f != null) {
                    f.cancel(true);
                }
                if (f2 != null) {
                    f2.cancel(true);
                }
                sail.shutDown();
            }
        }
        finally {
            if (service != null) {
                service.shutdownNow();
            }
            sail.getIndexManager().destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_getConnectionAllowedExactlyOnce2() throws SailException, InterruptedException, ExecutionException {
        block12: {
            Properties properties = new Properties();
            properties.setProperty(BigdataSail.Options.CREATE_TEMP_FILE, "true");
            ExecutorService service = null;
            final BigdataSail sail = new BigdataSail(properties);
            try {
                sail.initialize();
                service = Executors.newSingleThreadExecutor();
                final BigdataSail sail2 = new BigdataSail(sail.getNamespace(), sail.getIndexManager());
                sail2.initialize();
                Future<Void> f = null;
                try {
                    Callable<Void> task = new Callable<Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Void call() throws Exception {
                            BigdataSail.BigdataSailConnection conn1 = null;
                            BigdataSail.BigdataSailConnection conn2 = null;
                            try {
                                log.info((Object)"Requesting 1st unisolated connection.");
                                conn1 = sail.getUnisolatedConnection();
                                log.info((Object)"Requesting 2nd unisolated connection.");
                                conn2 = sail2.getUnisolatedConnection();
                                TestCase.fail((String)"Not expecting a 2nd unisolated connection");
                                Void void_ = null;
                                return void_;
                            }
                            finally {
                                if (conn1 != null) {
                                    conn1.close();
                                }
                                if (conn2 != null) {
                                    conn2.close();
                                }
                            }
                        }
                    };
                    f = service.submit(task);
                    f.get();
                }
                catch (ExecutionException e) {
                    if (InnerCause.isInnerCause((Throwable)e, AccessSemaphore.AccessSemaphoreNotReentrantException.class)) {
                        log.info((Object)e);
                        break block12;
                    }
                    throw e;
                }
                finally {
                    if (f != null) {
                        f.cancel(true);
                    }
                    if (sail2 != null) {
                        sail2.shutDown();
                    }
                    sail.shutDown();
                }
            }
            finally {
                if (service != null) {
                    service.shutdownNow();
                }
                sail.getIndexManager().destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_getConnectionAllowedExactlyOnce3() throws SailException, InterruptedException, ExecutionException {
        Properties properties = new Properties();
        properties.setProperty(BigdataSail.Options.CREATE_TEMP_FILE, "true");
        ExecutorService service = null;
        final BigdataSail sail = new BigdataSail(properties);
        try {
            sail.initialize();
            service = Executors.newFixedThreadPool(3);
            Journal jnl = (Journal)sail.getIndexManager();
            LocalTripleStore tripleStore = new LocalTripleStore((IIndexManager)jnl, "foo", Long.valueOf(0L), properties);
            tripleStore.create();
            BigdataSail sail2 = new BigdataSail((AbstractTripleStore)tripleStore);
            sail2.initialize();
            try {
                Callable<SailConnection> task = new Callable<SailConnection>(){

                    @Override
                    public SailConnection call() throws Exception {
                        BigdataSail.BigdataSailConnection conn1 = null;
                        log.info((Object)"Requesting 1st unisolated connection.");
                        conn1 = sail.getUnisolatedConnection();
                        return conn1;
                    }
                };
                Future<SailConnection> f1 = service.submit(task);
                Future<SailConnection> f2 = service.submit(task);
                try {
                    f2.get(250L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    log.info((Object)"timeout");
                }
                f1.get().close();
                try {
                    f2.get(250L, TimeUnit.MILLISECONDS).close();
                }
                catch (TimeoutException e) {
                    TestBootstrapBigdataSail.fail((String)"Should have been able to get second connection");
                }
            }
            finally {
                if (sail2 != null) {
                    sail2.shutDown();
                }
                sail.shutDown();
            }
        }
        finally {
            if (service != null) {
                service.shutdownNow();
            }
            sail.getIndexManager().destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_isolationOfUnisolatedConnection() throws SailException, InterruptedException {
        Properties properties = new Properties();
        properties.setProperty(BigdataSail.Options.CREATE_TEMP_FILE, "true");
        BigdataSail.BigdataSailConnection conn = null;
        BigdataSail.BigdataSailConnection readConn = null;
        BigdataSail sail = new BigdataSail(properties);
        try {
            BigdataStatement stmt;
            sail.initialize();
            conn = sail.getUnisolatedConnection();
            readConn = sail.getReadOnlyConnection();
            URIImpl s = new URIImpl("http://www.bigdata.com/s");
            URIImpl p = new URIImpl("http://www.bigdata.com/p");
            LiteralImpl o = new LiteralImpl("o");
            conn.addStatement((Resource)s, (URI)p, (Value)o, new Resource[0]);
            int n = 0;
            try (CloseableIteration itr = conn.getStatements((Resource)s, (URI)p, (Value)o, false, new Resource[0]);){
                while (itr.hasNext()) {
                    stmt = (BigdataStatement)itr.next();
                    TestBootstrapBigdataSail.assertEquals((String)"subject", (Object)s, (Object)stmt.getSubject());
                    TestBootstrapBigdataSail.assertEquals((String)"predicate", (Object)p, (Object)stmt.getPredicate());
                    TestBootstrapBigdataSail.assertEquals((String)"object", (Object)o, (Object)stmt.getObject());
                    ++n;
                }
            }
            TestBootstrapBigdataSail.assertEquals((String)"#statements visited", (int)1, (int)n);
            n = 0;
            itr = readConn.getStatements((Resource)s, (URI)p, (Value)o, false, new Resource[0]);
            try {
                while (itr.hasNext()) {
                    itr.next();
                    ++n;
                }
            }
            finally {
                itr.close();
            }
            TestBootstrapBigdataSail.assertEquals((String)"#statements visited", (int)0, (int)n);
            conn.commit();
            n = 0;
            itr = conn.getStatements((Resource)s, (URI)p, (Value)o, false, new Resource[0]);
            try {
                while (itr.hasNext()) {
                    stmt = (BigdataStatement)itr.next();
                    TestBootstrapBigdataSail.assertEquals((String)"subject", (Object)s, (Object)stmt.getSubject());
                    TestBootstrapBigdataSail.assertEquals((String)"predicate", (Object)p, (Object)stmt.getPredicate());
                    TestBootstrapBigdataSail.assertEquals((String)"object", (Object)o, (Object)stmt.getObject());
                    ++n;
                }
            }
            finally {
                itr.close();
            }
            TestBootstrapBigdataSail.assertEquals((String)"#statements visited", (int)1, (int)n);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
            if (readConn != null) {
                readConn.close();
            }
            sail.getIndexManager().destroy();
        }
    }
}

