/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.axioms.OwlAxioms;
import com.bigdata.rdf.changesets.ChangeAction;
import com.bigdata.rdf.changesets.ChangeRecord;
import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.changesets.IChangeRecord;
import com.bigdata.rdf.changesets.InMemChangeLog;
import com.bigdata.rdf.changesets.InferenceChangeLogReporter;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.ModifiedEnum;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.NoVocabulary;
import com.bigdata.rdf.vocab.RDFSVocabulary;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class TestChangeSets
extends ProxyBigdataSailTestCase {
    private static final Logger log = Logger.getLogger(TestChangeSets.class);

    public Properties getTriplesNoInference() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.QUADS, "false");
        props.setProperty(BigdataSail.Options.STATEMENT_IDENTIFIERS, "false");
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public Properties getTriplesWithInference() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.QUADS, "false");
        props.setProperty(BigdataSail.Options.STATEMENT_IDENTIFIERS, "false");
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "true");
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, OwlAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, RDFSVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.JUSTIFY, "true");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public TestChangeSets() {
    }

    public TestChangeSets(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleAdd() throws Exception {
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getTriplesNoInference());
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            cxn.setAutoCommit(false);
            AbstractTripleStore tripleStore = cxn.getTripleStore();
            InMemChangeLog changeLog = new InMemChangeLog();
            cxn.addChangeLog((IChangeLog)changeLog);
            BigdataValueFactory vf = (BigdataValueFactory)sail.getValueFactory();
            String ns = "http://www.bigdata.com/rdf#";
            BigdataURI a = vf.createURI("http://www.bigdata.com/rdf#A");
            BigdataURI b = vf.createURI("http://www.bigdata.com/rdf#B");
            BigdataURI c = vf.createURI("http://www.bigdata.com/rdf#C");
            BigdataStatement[] stmts = new BigdataStatement[]{vf.createStatement((Resource)a, RDFS.SUBCLASSOF, (Value)b), vf.createStatement((Resource)b, RDFS.SUBCLASSOF, (Value)c)};
            BigdataStatement[] stmts2 = new BigdataStatement[]{vf.createStatement((Resource)a, RDFS.SUBCLASSOF, (Value)c)};
            cxn.setNamespace("ns", "http://www.bigdata.com/rdf#");
            for (BigdataStatement stmt : stmts) {
                cxn.add((Statement)stmt, new Resource[0]);
            }
            cxn.commit();
            LinkedList<Object> expected = new LinkedList<IChangeRecord>();
            for (BigdataStatement stmt : stmts) {
                expected.add((IChangeRecord)new ChangeRecord((ISPO)stmt, ChangeAction.INSERTED));
            }
            this.compare(expected, changeLog.getLastCommit(tripleStore));
            for (BigdataStatement stmt : stmts) {
                cxn.add((Statement)stmt, new Resource[0]);
            }
            cxn.commit();
            this.compare(new LinkedList<IChangeRecord>(), changeLog.getLastCommit(tripleStore));
            for (BigdataStatement stmt : stmts2) {
                cxn.add((Statement)stmt, new Resource[0]);
            }
            cxn.commit();
            expected = new LinkedList();
            for (BigdataStatement stmt : stmts2) {
                expected.add((IChangeRecord)new ChangeRecord((ISPO)stmt, ChangeAction.INSERTED));
            }
            this.compare(expected, changeLog.getLastCommit(tripleStore));
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n" + tripleStore.dumpStore(true, true, false)));
            }
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleTxAdd() throws Exception {
        BigdataSailRepositoryConnection cxn = null;
        Properties properties = this.getTriplesNoInference();
        properties.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "true");
        BigdataSail sail = this.getSail(properties);
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            cxn.setAutoCommit(false);
            AbstractTripleStore tripleStore = cxn.getTripleStore();
            InMemChangeLog changeLog = new InMemChangeLog();
            cxn.addChangeLog((IChangeLog)changeLog);
            BigdataValueFactory vf = (BigdataValueFactory)sail.getValueFactory();
            String ns = "http://www.bigdata.com/rdf#";
            BigdataURI a = vf.createURI("http://www.bigdata.com/rdf#A");
            BigdataURI b = vf.createURI("http://www.bigdata.com/rdf#B");
            BigdataURI c = vf.createURI("http://www.bigdata.com/rdf#C");
            BigdataStatement[] stmts = new BigdataStatement[]{vf.createStatement((Resource)a, RDFS.SUBCLASSOF, (Value)b), vf.createStatement((Resource)b, RDFS.SUBCLASSOF, (Value)c)};
            BigdataStatement[] stmts2 = new BigdataStatement[]{vf.createStatement((Resource)a, RDFS.SUBCLASSOF, (Value)c)};
            cxn.setNamespace("ns", "http://www.bigdata.com/rdf#");
            for (BigdataStatement stmt : stmts) {
                cxn.add((Statement)stmt, new Resource[0]);
            }
            cxn.commit();
            LinkedList<Object> expected = new LinkedList<IChangeRecord>();
            for (BigdataStatement stmt : stmts) {
                expected.add((IChangeRecord)new ChangeRecord((ISPO)stmt, ChangeAction.INSERTED));
            }
            this.compare(expected, changeLog.getLastCommit(tripleStore));
            for (BigdataStatement stmt : stmts) {
                cxn.add((Statement)stmt, new Resource[0]);
            }
            cxn.commit();
            this.compare(new LinkedList<IChangeRecord>(), changeLog.getLastCommit(tripleStore));
            for (BigdataStatement stmt : stmts2) {
                cxn.add((Statement)stmt, new Resource[0]);
            }
            cxn.commit();
            expected = new LinkedList();
            for (BigdataStatement stmt : stmts2) {
                expected.add((IChangeRecord)new ChangeRecord((ISPO)stmt, ChangeAction.INSERTED));
            }
            this.compare(expected, changeLog.getLastCommit(tripleStore));
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n" + tripleStore.dumpStore(true, true, false)));
            }
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleRemove() throws Exception {
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getTriplesNoInference());
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            cxn.setAutoCommit(false);
            AbstractTripleStore tripleStore = cxn.getTripleStore();
            InMemChangeLog changeLog = new InMemChangeLog();
            cxn.addChangeLog((IChangeLog)changeLog);
            BigdataValueFactory vf = (BigdataValueFactory)sail.getValueFactory();
            String ns = "http://www.bigdata.com/rdf#";
            BigdataURI a = vf.createURI("http://www.bigdata.com/rdf#A");
            BigdataURI b = vf.createURI("http://www.bigdata.com/rdf#B");
            BigdataURI c = vf.createURI("http://www.bigdata.com/rdf#C");
            BigdataStatement[] stmts = new BigdataStatement[]{vf.createStatement((Resource)a, RDFS.SUBCLASSOF, (Value)b), vf.createStatement((Resource)b, RDFS.SUBCLASSOF, (Value)c)};
            cxn.setNamespace("ns", "http://www.bigdata.com/rdf#");
            for (BigdataStatement stmt : stmts) {
                cxn.add((Statement)stmt, new Resource[0]);
            }
            cxn.commit();
            for (BigdataStatement stmt : stmts) {
                stmt.setModified(ModifiedEnum.NONE);
                cxn.remove((Statement)stmt, new Resource[0]);
            }
            cxn.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("\ndump store:\n" + tripleStore.dumpStore(true, true, false)));
            }
            LinkedList<IChangeRecord> expected = new LinkedList<IChangeRecord>();
            for (BigdataStatement stmt : stmts) {
                expected.add((IChangeRecord)new ChangeRecord((ISPO)stmt, ChangeAction.REMOVED));
            }
            this.compare(expected, changeLog.getLastCommit(tripleStore));
            for (BigdataStatement stmt : stmts) {
                cxn.remove((Statement)stmt, new Resource[0]);
            }
            cxn.commit();
            this.compare(new LinkedList<IChangeRecord>(), changeLog.getLastCommit(tripleStore));
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSids() throws Exception {
        if (!Boolean.valueOf(this.getProperties().getProperty(BigdataSail.Options.STATEMENT_IDENTIFIERS, "false")).booleanValue()) {
            log.warn((Object)"cannot run this test without sids enabled");
            return;
        }
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getTriplesNoInference());
        try {
            int i;
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            cxn.setAutoCommit(false);
            InMemChangeLog changeLog = new InMemChangeLog();
            cxn.addChangeLog((IChangeLog)changeLog);
            BigdataValueFactory vf = (BigdataValueFactory)sail.getValueFactory();
            String ns = "http://www.bigdata.com/rdf#";
            BigdataURI a = vf.createURI("http://www.bigdata.com/rdf#A");
            BigdataURI b = vf.createURI("http://www.bigdata.com/rdf#B");
            BigdataURI c = vf.createURI("http://www.bigdata.com/rdf#C");
            BigdataURI d = vf.createURI("http://www.bigdata.com/rdf#D");
            BigdataURI x = vf.createURI("http://www.bigdata.com/rdf#X");
            BigdataURI y = vf.createURI("http://www.bigdata.com/rdf#Y");
            BigdataURI z = vf.createURI("http://www.bigdata.com/rdf#Z");
            BigdataStatement axb = vf.createStatement((Resource)a, (URI)x, (Value)b);
            BigdataBNode sid1 = vf.createBNode(axb);
            BigdataStatement[] add = new BigdataStatement[]{axb, vf.createStatement((Resource)sid1, (URI)y, (Value)c), vf.createStatement((Resource)d, (URI)z, (Value)sid1)};
            BigdataStatement[] explicitRemove = new BigdataStatement[]{axb};
            BigdataStatement[] inferredRemove = new BigdataStatement[]{vf.createStatement((Resource)sid1, (URI)y, (Value)c), vf.createStatement((Resource)d, (URI)z, (Value)sid1)};
            cxn.setNamespace("ns", "http://www.bigdata.com/rdf#");
            for (BigdataStatement stmt : add) {
                cxn.add((Statement)stmt, new Resource[0]);
            }
            cxn.commit();
            AbstractTripleStore tripleStore = cxn.getTripleStore();
            for (i = 0; i < add.length; ++i) {
                add[i] = tripleStore.getStatement((Statement)add[i]);
            }
            for (i = 0; i < explicitRemove.length; ++i) {
                explicitRemove[i] = tripleStore.getStatement((Statement)explicitRemove[i]);
            }
            for (i = 0; i < inferredRemove.length; ++i) {
                inferredRemove[i] = tripleStore.getStatement((Statement)inferredRemove[i]);
            }
            LinkedList<Object> expected = new LinkedList<IChangeRecord>();
            for (BigdataStatement stmt : add) {
                expected.add((IChangeRecord)new ChangeRecord((ISPO)stmt, ChangeAction.INSERTED));
            }
            this.compare(expected, changeLog.getLastCommit(tripleStore));
            for (BigdataStatement stmt : explicitRemove) {
                cxn.remove((Statement)stmt, new Resource[0]);
            }
            cxn.commit();
            expected = new LinkedList();
            for (BigdataStatement stmt : explicitRemove) {
                expected.add((IChangeRecord)new ChangeRecord((ISPO)stmt, ChangeAction.REMOVED));
            }
            for (BigdataStatement stmt : inferredRemove) {
                expected.add(new ChangeRecord((ISPO)stmt, ChangeAction.REMOVED));
            }
            this.compare(expected, changeLog.getLastCommit(tripleStore));
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n" + tripleStore.dumpStore(true, true, false)));
            }
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTMAdd() throws Exception {
        if (!Boolean.valueOf(this.getProperties().getProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "true")).booleanValue()) {
            log.warn((Object)"cannot run this test without TM enabled");
            return;
        }
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getTriplesWithInference());
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            cxn.setAutoCommit(false);
            AbstractTripleStore tripleStore = cxn.getTripleStore();
            InMemChangeLog changeLog = new InMemChangeLog();
            cxn.addChangeLog((IChangeLog)changeLog);
            InferenceChangeLogReporter changeLog2 = new InferenceChangeLogReporter(tripleStore);
            cxn.addChangeLog((IChangeLog)changeLog2);
            BigdataValueFactory vf = (BigdataValueFactory)sail.getValueFactory();
            String ns = "http://www.bigdata.com/rdf#";
            BigdataURI a = vf.createURI("http://www.bigdata.com/rdf#A");
            BigdataURI b = vf.createURI("http://www.bigdata.com/rdf#B");
            BigdataURI c = vf.createURI("http://www.bigdata.com/rdf#C");
            BigdataStatement[] explicit = new BigdataStatement[]{vf.createStatement((Resource)a, RDFS.SUBCLASSOF, (Value)b), vf.createStatement((Resource)b, RDFS.SUBCLASSOF, (Value)c)};
            Object[] inferred = new BigdataStatement[]{vf.createStatement((Resource)a, RDF.TYPE, (Value)RDFS.CLASS), vf.createStatement((Resource)a, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE), vf.createStatement((Resource)a, RDFS.SUBCLASSOF, (Value)a), vf.createStatement((Resource)a, RDFS.SUBCLASSOF, (Value)c), vf.createStatement((Resource)b, RDF.TYPE, (Value)RDFS.CLASS), vf.createStatement((Resource)b, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE), vf.createStatement((Resource)b, RDFS.SUBCLASSOF, (Value)b), vf.createStatement((Resource)c, RDF.TYPE, (Value)RDFS.CLASS), vf.createStatement((Resource)c, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE), vf.createStatement((Resource)c, RDFS.SUBCLASSOF, (Value)c)};
            BigdataStatement[] upgrades = new BigdataStatement[]{vf.createStatement((Resource)a, RDFS.SUBCLASSOF, (Value)c)};
            cxn.setNamespace("ns", "http://www.bigdata.com/rdf#");
            for (BigdataStatement stmt : explicit) {
                cxn.add((Statement)stmt, new Resource[0]);
            }
            cxn.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n" + tripleStore.dumpStore(true, true, false)));
            }
            LinkedList<Object> expected = new LinkedList<IChangeRecord>();
            for (BigdataStatement bigdataStatement : explicit) {
                expected.add(new ChangeRecord((ISPO)bigdataStatement, ChangeAction.INSERTED));
            }
            for (BigdataStatement bigdataStatement : inferred) {
                expected.add((IChangeRecord)new ChangeRecord((ISPO)bigdataStatement, ChangeAction.INSERTED));
            }
            this.compare(expected, changeLog.getLastCommit(tripleStore));
            TestChangeSets.assertSameIteratorAnyOrder((Object[])inferred, (Iterator)changeLog2.addedIterator());
            TestChangeSets.assertSameIteratorAnyOrder((Object[])new BigdataStatement[0], (Iterator)changeLog2.removedIterator());
            for (BigdataStatement stmt : upgrades) {
                cxn.add((Statement)stmt, new Resource[0]);
            }
            cxn.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n" + tripleStore.dumpStore(true, true, false)));
            }
            expected = new LinkedList();
            for (BigdataStatement bigdataStatement : upgrades) {
                expected.add((IChangeRecord)new ChangeRecord((ISPO)bigdataStatement, ChangeAction.UPDATED));
            }
            this.compare(expected, changeLog.getLastCommit(tripleStore));
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTMRetract() throws Exception {
        if (!Boolean.valueOf(this.getProperties().getProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "true")).booleanValue()) {
            log.warn((Object)"cannot run this test without TM enabled");
            return;
        }
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getTriplesWithInference());
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            cxn.setAutoCommit(false);
            AbstractTripleStore tripleStore = cxn.getTripleStore();
            InMemChangeLog changeLog = new InMemChangeLog();
            cxn.addChangeLog((IChangeLog)changeLog);
            InferenceChangeLogReporter changeLog2 = new InferenceChangeLogReporter(tripleStore);
            cxn.addChangeLog((IChangeLog)changeLog2);
            BigdataValueFactory vf = (BigdataValueFactory)sail.getValueFactory();
            String ns = "http://www.bigdata.com/rdf#";
            BigdataURI a = vf.createURI("http://www.bigdata.com/rdf#A");
            BigdataURI b = vf.createURI("http://www.bigdata.com/rdf#B");
            BigdataURI c = vf.createURI("http://www.bigdata.com/rdf#C");
            BigdataStatement[] explicitAdd = new BigdataStatement[]{vf.createStatement((Resource)a, RDFS.SUBCLASSOF, (Value)b), vf.createStatement((Resource)b, RDFS.SUBCLASSOF, (Value)c)};
            Object[] inferredAdd = new BigdataStatement[]{vf.createStatement((Resource)a, RDF.TYPE, (Value)RDFS.CLASS), vf.createStatement((Resource)a, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE), vf.createStatement((Resource)a, RDFS.SUBCLASSOF, (Value)a), vf.createStatement((Resource)a, RDFS.SUBCLASSOF, (Value)c), vf.createStatement((Resource)b, RDF.TYPE, (Value)RDFS.CLASS), vf.createStatement((Resource)b, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE), vf.createStatement((Resource)b, RDFS.SUBCLASSOF, (Value)b), vf.createStatement((Resource)c, RDF.TYPE, (Value)RDFS.CLASS), vf.createStatement((Resource)c, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE), vf.createStatement((Resource)c, RDFS.SUBCLASSOF, (Value)c)};
            BigdataStatement[] explicitRemove = new BigdataStatement[]{vf.createStatement((Resource)b, RDFS.SUBCLASSOF, (Value)c)};
            Object[] inferredRemove = new BigdataStatement[]{vf.createStatement((Resource)a, RDFS.SUBCLASSOF, (Value)c), vf.createStatement((Resource)c, RDF.TYPE, (Value)RDFS.CLASS), vf.createStatement((Resource)c, RDFS.SUBCLASSOF, (Value)RDFS.RESOURCE), vf.createStatement((Resource)c, RDFS.SUBCLASSOF, (Value)c)};
            cxn.setNamespace("ns", "http://www.bigdata.com/rdf#");
            for (BigdataStatement stmt : explicitAdd) {
                cxn.add((Statement)stmt, new Resource[0]);
            }
            cxn.commit();
            LinkedList<Object> expected = new LinkedList<IChangeRecord>();
            for (BigdataStatement bigdataStatement : explicitAdd) {
                expected.add(new ChangeRecord((ISPO)bigdataStatement, ChangeAction.INSERTED));
            }
            for (BigdataStatement bigdataStatement : inferredAdd) {
                expected.add((IChangeRecord)new ChangeRecord((ISPO)bigdataStatement, ChangeAction.INSERTED));
            }
            this.compare(expected, changeLog.getLastCommit(tripleStore));
            TestChangeSets.assertSameIteratorAnyOrder((Object[])inferredAdd, (Iterator)changeLog2.addedIterator());
            TestChangeSets.assertSameIteratorAnyOrder((Object[])new BigdataStatement[0], (Iterator)changeLog2.removedIterator());
            changeLog2.clear();
            for (BigdataStatement stmt : explicitRemove) {
                cxn.remove((Statement)stmt, new Resource[0]);
            }
            cxn.commit();
            expected = new LinkedList();
            for (BigdataStatement bigdataStatement : explicitRemove) {
                expected.add((IChangeRecord)new ChangeRecord((ISPO)bigdataStatement, ChangeAction.REMOVED));
            }
            for (BigdataStatement bigdataStatement : inferredRemove) {
                expected.add(new ChangeRecord((ISPO)bigdataStatement, ChangeAction.REMOVED));
            }
            this.compare(expected, changeLog.getLastCommit(tripleStore));
            TestChangeSets.assertSameIteratorAnyOrder((Object[])new BigdataStatement[0], (Iterator)changeLog2.addedIterator());
            TestChangeSets.assertSameIteratorAnyOrder((Object[])inferredRemove, (Iterator)changeLog2.removedIterator());
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n" + tripleStore.dumpStore(true, true, false)));
            }
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTMUpdate() throws Exception {
        if (!Boolean.valueOf(this.getProperties().getProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "true")).booleanValue()) {
            log.warn((Object)"cannot run this test without TM enabled");
            return;
        }
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getTriplesWithInference());
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            cxn.setAutoCommit(false);
            AbstractTripleStore tripleStore = cxn.getTripleStore();
            InMemChangeLog changeLog = new InMemChangeLog();
            cxn.addChangeLog((IChangeLog)changeLog);
            BigdataValueFactory vf = (BigdataValueFactory)sail.getValueFactory();
            String ns = "http://www.bigdata.com/rdf#";
            BigdataURI a = vf.createURI("http://www.bigdata.com/rdf#A");
            BigdataURI b = vf.createURI("http://www.bigdata.com/rdf#B");
            BigdataURI c = vf.createURI("http://www.bigdata.com/rdf#C");
            BigdataStatement[] explicit = new BigdataStatement[]{vf.createStatement((Resource)a, RDFS.SUBCLASSOF, (Value)b), vf.createStatement((Resource)b, RDFS.SUBCLASSOF, (Value)c)};
            BigdataStatement update = vf.createStatement((Resource)a, RDFS.SUBCLASSOF, (Value)c);
            cxn.setNamespace("ns", "http://www.bigdata.com/rdf#");
            for (BigdataStatement stmt : explicit) {
                cxn.add((Statement)stmt, new Resource[0]);
            }
            cxn.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n" + tripleStore.dumpStore(true, true, false)));
            }
            cxn.add((Statement)update, new Resource[0]);
            cxn.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n" + tripleStore.dumpStore(true, true, false)));
            }
            LinkedList<Object> expected = new LinkedList<IChangeRecord>();
            expected.add(new ChangeRecord((ISPO)update, ChangeAction.UPDATED));
            this.compare(expected, changeLog.getLastCommit(tripleStore));
            update = tripleStore.getStatement((Statement)update);
            TestChangeSets.assertTrue((String)"wrong type", (boolean)update.isExplicit());
            cxn.remove((Statement)update, new Resource[0]);
            cxn.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n" + tripleStore.dumpStore(true, true, false)));
            }
            expected = new LinkedList();
            expected.add((IChangeRecord)new ChangeRecord((ISPO)update, ChangeAction.UPDATED));
            this.compare(expected, changeLog.getLastCommit(tripleStore));
            update = tripleStore.getStatement((Statement)update);
            TestChangeSets.assertTrue((String)"wrong type", (boolean)update.isInferred());
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }

    private void compare(Collection<IChangeRecord> expected, Collection<IChangeRecord> actual) {
        LinkedList<IChangeRecord> extra = new LinkedList<IChangeRecord>();
        Collection<Object> missing = new LinkedList();
        int nmatched = 0;
        for (IChangeRecord iChangeRecord : actual) {
            boolean match = false;
            if (log.isInfoEnabled()) {
                log.info((Object)iChangeRecord);
            }
            Iterator<IChangeRecord> it = expected.iterator();
            while (it.hasNext()) {
                if (!it.next().equals(iChangeRecord)) continue;
                it.remove();
                match = true;
                ++nmatched;
                break;
            }
            if (match) continue;
            extra.add(iChangeRecord);
        }
        missing = expected;
        for (IChangeRecord iChangeRecord : extra) {
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("extra result: " + iChangeRecord));
        }
        for (IChangeRecord iChangeRecord : missing) {
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("missing result: " + iChangeRecord));
        }
        if (!extra.isEmpty() || !missing.isEmpty()) {
            TestChangeSets.fail((String)("matchedResults=" + nmatched + ", extraResults=" + extra.size() + ", missingResults=" + missing.size()));
        }
    }
}

