/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.openrdf.sail.SailException;

public class TestCnxnCreate
extends ProxyBigdataSailTestCase {
    public TestCnxnCreate() {
    }

    public TestCnxnCreate(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_manageConnections() throws SailException, InterruptedException, IOException {
        Properties properties = this.getProperties();
        properties.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "true");
        properties.setProperty(AbstractTripleStore.Options.JUSTIFY, "false");
        properties.setProperty(AbstractTripleStore.Options.INLINE_DATE_TIMES, "false");
        BigdataSail sail = new BigdataSail(properties);
        try {
            sail.initialize();
            log.info((Object)"Sail is initialized.");
            BigdataSail.BigdataSailConnection uicnxn = sail.getUnisolatedConnection();
            TestCnxnCreate.assertTrue((boolean)uicnxn.isOpen());
            BigdataSail.BigdataSailConnection rocnxn = sail.getReadOnlyConnection();
            TestCnxnCreate.assertTrue((boolean)rocnxn.isOpen());
            sail.shutDown();
            log.info((Object)"done - sail.shutDown()");
            TestCnxnCreate.assertTrue((!uicnxn.isOpen() ? 1 : 0) != 0);
            TestCnxnCreate.assertTrue((!rocnxn.isOpen() ? 1 : 0) != 0);
        }
        finally {
            log.info((Object)"__tearDownUnitTest");
            sail.__tearDownUnitTest();
            log.info((Object)"done - __tearDownUnitTest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_manageDefaultConnection() throws SailException, InterruptedException, IOException {
        Properties properties = this.getProperties();
        properties.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "true");
        properties.setProperty(AbstractTripleStore.Options.JUSTIFY, "false");
        properties.setProperty(AbstractTripleStore.Options.INLINE_DATE_TIMES, "false");
        BigdataSail sail = new BigdataSail(properties);
        try {
            sail.initialize();
            log.info((Object)"Sail is initialized.");
            BigdataSail.BigdataSailConnection cnxn = sail.getConnection();
            TestCnxnCreate.assertTrue((boolean)cnxn.isOpen());
            sail.shutDown();
            log.info((Object)"done - sail.shutDown()");
            TestCnxnCreate.assertTrue((!cnxn.isOpen() ? 1 : 0) != 0);
        }
        finally {
            log.info((Object)"__tearDownUnitTest");
            sail.__tearDownUnitTest();
            log.info((Object)"done - __tearDownUnitTest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_manageThreadConnections() throws SailException, InterruptedException, IOException {
        Properties properties = this.getProperties();
        properties.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        properties.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        properties.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "true");
        properties.setProperty(AbstractTripleStore.Options.JUSTIFY, "false");
        properties.setProperty(AbstractTripleStore.Options.INLINE_DATE_TIMES, "false");
        final BigdataSail sail = new BigdataSail(properties);
        try {
            sail.initialize();
            log.info((Object)"Sail is initialized.");
            final AtomicReference uicnxn = new AtomicReference();
            final Semaphore c1 = new Semaphore(0);
            Thread t = new Thread(){

                @Override
                public void run() {
                    System.out.println("Running...");
                    try {
                        uicnxn.set(sail.getUnisolatedConnection());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    System.out.println("Releasing permit");
                    c1.release();
                }
            };
            t.start();
            c1.acquire();
            TestCnxnCreate.assertTrue((boolean)((BigdataSail.BigdataSailConnection)uicnxn.get()).isOpen());
            BigdataSail.BigdataSailConnection rocnxn = sail.getReadOnlyConnection();
            TestCnxnCreate.assertTrue((boolean)rocnxn.isOpen());
            sail.shutDown();
            log.warn((Object)"don - sail.shutDown()");
            TestCnxnCreate.assertTrue((!((BigdataSail.BigdataSailConnection)uicnxn.get()).isOpen() ? 1 : 0) != 0);
            TestCnxnCreate.assertTrue((!rocnxn.isOpen() ? 1 : 0) != 0);
        }
        finally {
            log.warn((Object)"__tearDownUnitTest");
            sail.__tearDownUnitTest();
            log.warn((Object)"done - __tearDownUnitTest");
        }
    }
}

