/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.BigdataStatics;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.CreateKBTask;
import com.bigdata.rdf.sail.DestroyKBTask;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.sail.webapp.DatasetNotFoundException;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.task.AbstractApiTask;
import com.bigdata.rdf.task.IApiTask;
import com.bigdata.rdf.vocab.BSBMVocabulary;
import com.bigdata.rdf.vocab.RDFSVocabulary;
import com.bigdata.util.InnerCause;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.openrdf.repository.RepositoryException;
import org.openrdf.sail.SailException;

public abstract class TestConcurrentKBCreate
extends ProxyBigdataSailTestCase {
    public TestConcurrentKBCreate() {
    }

    public TestConcurrentKBCreate(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_KBCreateAndDiscovery() throws Exception {
        String namespace = this.getName();
        Properties properties = this.getProperties();
        Journal jnl = null;
        try {
            jnl = new Journal(properties);
            this.assertKBNotFound(jnl, namespace);
            AbstractApiTask.submitApiTask((IIndexManager)jnl, (IApiTask)new CreateKBTask(namespace, properties)).get();
            this.assertKBExists(jnl, namespace);
        }
        finally {
            if (jnl != null) {
                jnl.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_KBCreateAndDestroy() throws Exception {
        String namespace = this.getName();
        Properties properties = this.getProperties();
        Journal jnl = null;
        try {
            jnl = new Journal(properties);
            this.assertKBNotFound(jnl, namespace);
            AbstractApiTask.submitApiTask((IIndexManager)jnl, (IApiTask)new CreateKBTask(namespace, properties)).get();
            this.assertKBExists(jnl, namespace);
            AbstractApiTask.submitApiTask((IIndexManager)jnl, (IApiTask)new DestroyKBTask(namespace)).get();
            this.assertKBNotFound(jnl, namespace);
        }
        finally {
            if (jnl != null) {
                jnl.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertKBExists(Journal jnl, String namespace) throws RepositoryException, SailException {
        try (BigdataSailRepositoryConnection conn = null;){
            conn = this.getQueryConnection((IIndexManager)jnl, namespace, -1L);
            TestConcurrentKBCreate.assertNotNull((String)namespace, (Object)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertKBNotFound(Journal jnl, String namespace) throws RepositoryException, SailException {
        try (BigdataSailRepositoryConnection conn = null;){
            conn = this.getQueryConnection((IIndexManager)jnl, namespace, -1L);
            TestConcurrentKBCreate.assertNull((String)namespace, (Object)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_2KBCreateAndDiscovery() throws Exception {
        String namespace = this.getName();
        String namespace2 = this.getName() + "2";
        Properties properties = this.getProperties();
        Journal jnl = null;
        try {
            jnl = new Journal(properties);
            this.assertKBNotFound(jnl, namespace);
            AbstractApiTask.submitApiTask((IIndexManager)jnl, (IApiTask)new CreateKBTask(namespace, properties)).get();
            this.assertKBExists(jnl, namespace);
            AbstractApiTask.submitApiTask((IIndexManager)jnl, (IApiTask)new CreateKBTask(namespace2, properties)).get();
            this.assertKBExists(jnl, namespace2);
        }
        finally {
            if (jnl != null) {
                jnl.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_CreateDestroy_ticket_948_00() throws Exception {
        String namespace = this.getName();
        Properties properties1 = new Properties(this.getProperties());
        properties1.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, BSBMVocabulary.class.getName());
        Journal jnl = null;
        try {
            jnl = new Journal(this.getProperties());
            this.assertKBNotFound(jnl, namespace);
            AbstractApiTask.submitApiTask((IIndexManager)jnl, (IApiTask)new CreateKBTask(namespace, properties1)).get();
            this.assertKBExists(jnl, namespace);
            AbstractApiTask.submitApiTask((IIndexManager)jnl, (IApiTask)new DestroyKBTask(namespace)).get();
            this.assertKBNotFound(jnl, namespace);
            AbstractApiTask.submitApiTask((IIndexManager)jnl, (IApiTask)new CreateKBTask(namespace, properties1)).get();
            this.assertKBExists(jnl, namespace);
        }
        finally {
            if (jnl != null) {
                jnl.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_CreateDestroy_ticket_948_01() throws Exception {
        if (!BigdataStatics.runKnownBadTests) {
            return;
        }
        String namespace = this.getName();
        Properties properties1 = new Properties(this.getProperties());
        properties1.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, BSBMVocabulary.class.getName());
        Properties properties2 = new Properties(this.getProperties());
        properties2.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, RDFSVocabulary.class.getName());
        Journal jnl = null;
        try {
            jnl = new Journal(this.getProperties());
            this.assertKBNotFound(jnl, namespace);
            AbstractApiTask.submitApiTask((IIndexManager)jnl, (IApiTask)new CreateKBTask(namespace, properties1)).get();
            this.assertKBExists(jnl, namespace);
            AbstractApiTask.submitApiTask((IIndexManager)jnl, (IApiTask)new DestroyKBTask(namespace)).get();
            this.assertKBNotFound(jnl, namespace);
            AbstractApiTask.submitApiTask((IIndexManager)jnl, (IApiTask)new CreateKBTask(namespace, properties2)).get();
            this.assertKBExists(jnl, namespace);
        }
        finally {
            if (jnl != null) {
                jnl.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_CreateDestroy_ticket_948_02() throws Exception {
        if (!BigdataStatics.runKnownBadTests) {
            return;
        }
        String namespace = this.getName();
        Properties properties1 = new Properties(this.getProperties());
        properties1.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, BSBMVocabulary.class.getName());
        Properties properties2 = new Properties(this.getProperties());
        properties2.setProperty(AbstractTripleStore.Options.VOCABULARY_CLASS, RDFSVocabulary.class.getName());
        Journal jnl = null;
        try {
            jnl = new Journal(this.getProperties());
            this.assertKBNotFound(jnl, namespace);
            AbstractApiTask.submitApiTask((IIndexManager)jnl, (IApiTask)new CreateKBTask(namespace, properties1)).get();
            this.assertKBExists(jnl, namespace);
            AbstractApiTask.submitApiTask((IIndexManager)jnl, (IApiTask)new DestroyKBTask(namespace)).get();
            this.assertKBNotFound(jnl, namespace);
            jnl.shutdown();
            jnl = new Journal(this.getProperties());
            AbstractApiTask.submitApiTask((IIndexManager)jnl, (IApiTask)new CreateKBTask(namespace, properties2)).get();
            this.assertKBExists(jnl, namespace);
        }
        finally {
            if (jnl != null) {
                jnl.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_concurrentKBCreateAndDiscovery() throws Exception {
        String namespace = this.getName();
        Properties properties = this.getProperties();
        Journal jnl = null;
        try {
            jnl = new Journal(properties);
            this.doConcurrentCreateAndDiscoveryTest((IIndexManager)jnl, namespace);
        }
        finally {
            if (jnl != null) {
                jnl.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_concurrentKBCreateAndDiscoveryStressTestOnSharedJournal() throws Exception {
        Properties properties = this.getProperties();
        Journal jnl = null;
        try {
            jnl = new Journal(properties);
            for (int i = 0; i < 100; ++i) {
                String namespace = this.getName() + "-" + i;
                this.doConcurrentCreateAndDiscoveryTest((IIndexManager)jnl, namespace);
            }
        }
        finally {
            if (jnl != null) {
                jnl.destroy();
            }
        }
    }

    public void test_concurrentKBCreateAndDiscoveryStressTestOnDistinctJournals() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.test_concurrentKBCreateAndDiscovery();
        }
    }

    private void doConcurrentCreateAndDiscoveryTest(final IIndexManager indexManager, final String namespace) throws Exception {
        int i;
        final AtomicBoolean created = new AtomicBoolean(false);
        AtomicBoolean discovered = new AtomicBoolean(false);
        AtomicInteger errorCount = new AtomicInteger(0);
        LinkedList<Callable<Void>> tasks = new LinkedList<Callable<Void>>();
        int numBefore = 10;
        int numAfter = 10;
        for (i = 0; i < 10; ++i) {
            tasks.add(new DiscoveryTask(indexManager, namespace, discovered, errorCount));
        }
        tasks.add(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AbstractApiTask.submitApiTask((IIndexManager)indexManager, (IApiTask)new CreateKBTask(namespace, ((Journal)indexManager).getProperties())).get();
                    created.set(true);
                    return null;
                }
                catch (Throwable t) {
                    log.error((Object)t, t);
                    throw new RuntimeException(t);
                }
            }
        });
        for (i = 0; i < 10; ++i) {
            tasks.add(new DiscoveryTask(indexManager, namespace, discovered, errorCount));
        }
        ((ThreadPoolExecutor)indexManager.getExecutorService()).setCorePoolSize(tasks.size());
        ((ThreadPoolExecutor)indexManager.getExecutorService()).prestartAllCoreThreads();
        List futures = indexManager.getExecutorService().invokeAll(tasks);
        for (Future f : futures) {
            f.get();
        }
        TestConcurrentKBCreate.assertTrue((String)"KB was not created.", (boolean)created.get());
        if (!discovered.get()) {
            new DiscoveryTask(indexManager, namespace, discovered, errorCount).call();
        }
        TestConcurrentKBCreate.assertTrue((String)"KB was not discovered.", (boolean)created.get());
        TestConcurrentKBCreate.assertEquals((String)"Error count", (int)0, (int)errorCount.get());
    }

    private BigdataSailRepositoryConnection getQueryConnection(IIndexManager indexManager, String namespace, long timestamp) throws RepositoryException, SailException {
        AbstractTripleStore tripleStore = this.getTripleStore(indexManager, namespace, timestamp);
        if (tripleStore == null) {
            return null;
        }
        try {
            BigdataSail sail = new BigdataSail(tripleStore);
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            repo.initialize();
            if (TimestampUtility.isReadOnly((long)timestamp)) {
                return repo.getReadOnlyConnection(timestamp);
            }
            BigdataSailRepositoryConnection conn = repo.getConnection();
            conn.setAutoCommit(false);
            return conn;
        }
        catch (Throwable t) {
            if (InnerCause.isInnerCause((Throwable)t, DatasetNotFoundException.class)) {
                return null;
            }
            throw new RuntimeException(t);
        }
    }

    private AbstractTripleStore getTripleStore(IIndexManager indexManager, String namespace, long timestamp) {
        AbstractTripleStore tripleStore = (AbstractTripleStore)indexManager.getResourceLocator().locate(namespace, timestamp);
        return tripleStore;
    }

    static /* synthetic */ Logger access$200() {
        return log;
    }

    private class DiscoveryTask
    implements Callable<Void> {
        private final IIndexManager indexManager;
        private final String namespace;
        private final AtomicBoolean discovered;
        private final AtomicInteger errorCount;

        public DiscoveryTask(IIndexManager indexManager, String namespace, AtomicBoolean discovered, AtomicInteger errorCount) {
            this.indexManager = indexManager;
            this.namespace = namespace;
            this.discovered = discovered;
            this.errorCount = errorCount;
        }

        @Override
        public Void call() throws Exception {
            try (BigdataSailRepositoryConnection conn = null;){
                conn = TestConcurrentKBCreate.this.getQueryConnection(this.indexManager, this.namespace, -1L);
                if (conn != null) {
                    this.discovered.set(true);
                }
            }
            return null;
        }
    }

    public static class TestWithoutGroupCommit
    extends TestConcurrentKBCreate {
        public TestWithoutGroupCommit() {
        }

        public TestWithoutGroupCommit(String name) {
            super(name);
        }

        @Override
        public Properties getProperties() {
            Properties properties = new Properties(super.getProperties());
            properties.setProperty(Journal.Options.GROUP_COMMIT, "false");
            return properties;
        }
    }

    public static class TestWithGroupCommit
    extends TestConcurrentKBCreate {
        public TestWithGroupCommit() {
        }

        public TestWithGroupCommit(String name) {
            super(name);
        }

        @Override
        public Properties getProperties() {
            Properties properties = new Properties(super.getProperties());
            properties.setProperty(Journal.Options.GROUP_COMMIT, "true");
            return properties;
        }
    }
}

