/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITuple;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.changesets.ChangeAction;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.sparql.ast.service.history.HistoryChangeRecord;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPORelation;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.AbstractRelation;
import com.bigdata.relation.IRelation;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import java.util.Iterator;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.sail.SailException;

public class TestHistoryIndex
extends ProxyBigdataSailTestCase {
    public TestHistoryIndex() {
    }

    public TestHistoryIndex(String name) {
        super(name);
    }

    private IIndex getHistoryIndex(AbstractTripleStore tripleStore) {
        SPORelation spoRelation = tripleStore.getSPORelation();
        String fqn = AbstractRelation.getFQN((IRelation)spoRelation, (String)"HIST");
        IIndex ndx = spoRelation.getIndex(fqn);
        return ndx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_historyIndexDisabled() throws SailException {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.HISTORY_SERVICE, "false");
        BigdataSail sail = this.getSail(properties);
        try {
            sail.initialize();
            try (BigdataSail.BigdataSailConnection conn = sail.getConnection();){
                IIndex ndx = this.getHistoryIndex(conn.getTripleStore());
                TestHistoryIndex.assertNull((Object)ndx);
                conn.rollback();
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_historyIndex01() throws SailException {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.HISTORY_SERVICE, "true");
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        BigdataSail sail = this.getSail(properties);
        try {
            SPO stmt1;
            SPO stmt0;
            long revisionTime0;
            sail.initialize();
            try (BigdataSail.BigdataSailConnection conn = sail.getConnection();){
                revisionTime0 = conn.getTripleStore().getIndexManager().getLastCommitTime() + 1L;
                IIndex ndx = this.getHistoryIndex(conn.getTripleStore());
                TestHistoryIndex.assertNotNull((Object)ndx);
                TestHistoryIndex.assertEquals((long)0L, (long)ndx.rangeCount());
                BigdataValueFactory f = (BigdataValueFactory)sail.getValueFactory();
                BigdataURI A = f.createURI("http://www.bigdata.com/A");
                BigdataURI B = f.createURI("http://www.bigdata.com/B");
                BigdataURI C = f.createURI("http://www.bigdata.com/C");
                BigdataURI rdfType = f.asValue(RDF.TYPE);
                conn.addStatement((Resource)A, (URI)rdfType, (Value)B, new Resource[0]);
                conn.addStatement((Resource)A, (URI)rdfType, (Value)C, new Resource[0]);
                conn.commit();
                TestHistoryIndex.assertEquals((long)2L, (long)ndx.rangeCount());
                stmt0 = new SPO(A.getIV(), rdfType.getIV(), B.getIV(), StatementEnum.Explicit);
                stmt1 = new SPO(A.getIV(), rdfType.getIV(), C.getIV(), StatementEnum.Explicit);
                IStriterator itr = new Striterator((Iterator)ndx.rangeIterator()).addFilter((IFilter)new Resolver(){
                    private static final long serialVersionUID = 1L;

                    protected Object resolve(Object obj) {
                        return ((ITuple)obj).getObject();
                    }
                });
                Object[] a = new HistoryChangeRecord[]{new HistoryChangeRecord((ISPO)stmt0, ChangeAction.INSERTED, revisionTime0), new HistoryChangeRecord((ISPO)stmt1, ChangeAction.INSERTED, revisionTime0)};
                TestHistoryIndex.assertSameIteratorAnyOrder((Object[])a, (Iterator)itr);
            }
            try (BigdataSail.BigdataSailConnection conn = sail.getConnection();){
                long revisionTime1 = conn.getTripleStore().getIndexManager().getLastCommitTime() + 1L;
                IIndex ndx = this.getHistoryIndex(conn.getTripleStore());
                TestHistoryIndex.assertNotNull((Object)ndx);
                TestHistoryIndex.assertEquals((long)2L, (long)ndx.rangeCount());
                BigdataValueFactory f = (BigdataValueFactory)sail.getValueFactory();
                BigdataURI A = f.createURI("http://www.bigdata.com/A");
                BigdataURI B = f.createURI("http://www.bigdata.com/B");
                BigdataURI rdfType = f.asValue(RDF.TYPE);
                conn.removeStatements((Resource)A, (URI)rdfType, (Value)B, new Resource[0]);
                conn.commit();
                TestHistoryIndex.assertEquals((long)3L, (long)ndx.rangeCount());
                IStriterator itr = new Striterator((Iterator)ndx.rangeIterator()).addFilter((IFilter)new Resolver(){
                    private static final long serialVersionUID = 1L;

                    protected Object resolve(Object obj) {
                        return ((ITuple)obj).getObject();
                    }
                });
                Object[] a = new HistoryChangeRecord[]{new HistoryChangeRecord((ISPO)stmt0, ChangeAction.INSERTED, revisionTime0), new HistoryChangeRecord((ISPO)stmt1, ChangeAction.INSERTED, revisionTime0), new HistoryChangeRecord((ISPO)stmt0, ChangeAction.REMOVED, revisionTime1)};
                TestHistoryIndex.assertSameIteratorAnyOrder((Object[])a, (Iterator)itr);
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_historyIndexWithPruning01() throws SailException {
        Properties properties = this.getProperties();
        properties.setProperty(AbstractTripleStore.Options.HISTORY_SERVICE, "true");
        properties.setProperty(AbstractTripleStore.Options.HISTORY_SERVICE_MIN_RELEASE_AGE, "1");
        properties.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        BigdataSail sail = this.getSail(properties);
        try {
            SPO stmt0;
            sail.initialize();
            try (BigdataSail.BigdataSailConnection conn = sail.getConnection();){
                long revisionTime0 = conn.getTripleStore().getIndexManager().getLastCommitTime() + 1L;
                IIndex ndx = this.getHistoryIndex(conn.getTripleStore());
                TestHistoryIndex.assertNotNull((Object)ndx);
                TestHistoryIndex.assertEquals((long)0L, (long)ndx.rangeCount());
                BigdataValueFactory f = (BigdataValueFactory)sail.getValueFactory();
                BigdataURI A = f.createURI("http://www.bigdata.com/A");
                BigdataURI B = f.createURI("http://www.bigdata.com/B");
                BigdataURI C = f.createURI("http://www.bigdata.com/C");
                BigdataURI rdfType = f.asValue(RDF.TYPE);
                conn.addStatement((Resource)A, (URI)rdfType, (Value)B, new Resource[0]);
                conn.addStatement((Resource)A, (URI)rdfType, (Value)C, new Resource[0]);
                conn.commit();
                TestHistoryIndex.assertEquals((long)2L, (long)ndx.rangeCount());
                stmt0 = new SPO(A.getIV(), rdfType.getIV(), B.getIV(), StatementEnum.Explicit);
                SPO stmt1 = new SPO(A.getIV(), rdfType.getIV(), C.getIV(), StatementEnum.Explicit);
                IStriterator itr = new Striterator((Iterator)ndx.rangeIterator()).addFilter((IFilter)new Resolver(){
                    private static final long serialVersionUID = 1L;

                    protected Object resolve(Object obj) {
                        return ((ITuple)obj).getObject();
                    }
                });
                Object[] a = new HistoryChangeRecord[]{new HistoryChangeRecord((ISPO)stmt0, ChangeAction.INSERTED, revisionTime0), new HistoryChangeRecord((ISPO)stmt1, ChangeAction.INSERTED, revisionTime0)};
                TestHistoryIndex.assertSameIteratorAnyOrder((Object[])a, (Iterator)itr);
            }
            try (BigdataSail.BigdataSailConnection conn = sail.getConnection();){
                long revisionTime1 = conn.getTripleStore().getIndexManager().getLastCommitTime() + 1L;
                IIndex ndx = this.getHistoryIndex(conn.getTripleStore());
                TestHistoryIndex.assertNotNull((Object)ndx);
                TestHistoryIndex.assertEquals((long)2L, (long)ndx.rangeCount());
                BigdataValueFactory f = (BigdataValueFactory)sail.getValueFactory();
                BigdataURI A = f.createURI("http://www.bigdata.com/A");
                BigdataURI B = f.createURI("http://www.bigdata.com/B");
                BigdataURI rdfType = f.asValue(RDF.TYPE);
                conn.removeStatements((Resource)A, (URI)rdfType, (Value)B, new Resource[0]);
                conn.commit();
                TestHistoryIndex.assertEquals((long)1L, (long)ndx.rangeCount());
                IStriterator itr = new Striterator((Iterator)ndx.rangeIterator()).addFilter((IFilter)new Resolver(){
                    private static final long serialVersionUID = 1L;

                    protected Object resolve(Object obj) {
                        return ((ITuple)obj).getObject();
                    }
                });
                Object[] a = new HistoryChangeRecord[]{new HistoryChangeRecord((ISPO)stmt0, ChangeAction.REMOVED, revisionTime1)};
                TestHistoryIndex.assertSameIteratorAnyOrder((Object[])a, (Iterator)itr);
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }
}

