/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.BindingImpl;

public class TestInlineValues
extends ProxyBigdataSailTestCase {
    protected static final Logger log = Logger.getLogger(TestInlineValues.class);

    @Override
    public Properties getProperties() {
        Properties props = new Properties(super.getProperties());
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public TestInlineValues() {
    }

    public TestInlineValues(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInlineValuesLT() throws Exception {
        BigdataSail sail = this.getSail();
        sail.initialize();
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        BigdataSailRepositoryConnection cxn = repo.getConnection();
        cxn.setAutoCommit(false);
        try {
            ValueFactory vf = sail.getValueFactory();
            URI A = vf.createURI("_:A");
            URI B = vf.createURI("_:B");
            URI X = vf.createURI("_:X");
            URI AGE = vf.createURI("_:AGE");
            Literal _25 = vf.createLiteral(25);
            Literal _45 = vf.createLiteral(45);
            cxn.add((Resource)A, RDF.TYPE, (Value)X, new Resource[0]);
            cxn.add((Resource)B, RDF.TYPE, (Value)X, new Resource[0]);
            cxn.add((Resource)A, AGE, (Value)_25, new Resource[0]);
            cxn.add((Resource)B, AGE, (Value)_45, new Resource[0]);
            cxn.flush();
            if (log.isInfoEnabled()) {
                log.info((Object)cxn.getTripleStore().dumpStore());
            }
            String query = "select ?s ?age WHERE {   ?s <" + RDF.TYPE + "> <" + X + "> . " + "  ?s <" + AGE + "> ?age . " + "  FILTER( ?age < 35 ) . " + "}";
            TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            TupleQueryResult result = tupleQuery.evaluate();
            LinkedList<BindingSet> solution = new LinkedList<BindingSet>();
            solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)A), new BindingImpl("age", (Value)_25)}));
            this.compare(result, solution);
        }
        finally {
            cxn.close();
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInlineValuesGT() throws Exception {
        BigdataSail sail = this.getSail();
        sail.initialize();
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        BigdataSailRepositoryConnection cxn = repo.getConnection();
        cxn.setAutoCommit(false);
        try {
            ValueFactory vf = sail.getValueFactory();
            URI A = vf.createURI("_:A");
            URI B = vf.createURI("_:B");
            URI X = vf.createURI("_:X");
            URI AGE = vf.createURI("_:AGE");
            Literal _25 = vf.createLiteral(25);
            Literal _45 = vf.createLiteral(45);
            cxn.add((Resource)A, RDF.TYPE, (Value)X, new Resource[0]);
            cxn.add((Resource)B, RDF.TYPE, (Value)X, new Resource[0]);
            cxn.add((Resource)A, AGE, (Value)_25, new Resource[0]);
            cxn.add((Resource)B, AGE, (Value)_45, new Resource[0]);
            cxn.flush();
            if (log.isInfoEnabled()) {
                log.info((Object)cxn.getTripleStore().dumpStore());
            }
            String query = "select ?s ?age WHERE {   ?s <" + RDF.TYPE + "> <" + X + "> . " + "  ?s <" + AGE + "> ?age . " + "  FILTER( ?age > 35 ) . " + "}";
            TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            TupleQueryResult result = tupleQuery.evaluate();
            LinkedList<BindingSet> solution = new LinkedList<BindingSet>();
            solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)B), new BindingImpl("age", (Value)_45)}));
            this.compare(result, solution);
        }
        finally {
            cxn.close();
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsLiteral() throws Exception {
        BigdataSail sail = this.getSail();
        sail.initialize();
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        BigdataSailRepositoryConnection cxn = repo.getConnection();
        cxn.setAutoCommit(false);
        try {
            TupleQueryResult result;
            ValueFactory vf = sail.getValueFactory();
            URI A = vf.createURI("_:A");
            URI B = vf.createURI("_:B");
            URI X = vf.createURI("_:X");
            URI AGE = vf.createURI("_:AGE");
            Literal _25 = vf.createLiteral(25);
            Literal _45 = vf.createLiteral(45);
            cxn.add((Resource)A, RDF.TYPE, (Value)X, new Resource[0]);
            cxn.add((Resource)B, RDF.TYPE, (Value)X, new Resource[0]);
            cxn.add((Resource)A, AGE, (Value)_25, new Resource[0]);
            cxn.add((Resource)B, AGE, (Value)_45, new Resource[0]);
            cxn.flush();
            if (log.isInfoEnabled()) {
                log.info((Object)cxn.getTripleStore().dumpStore());
            }
            String query = "select ?s ?age WHERE {   ?s <" + RDF.TYPE + "> <" + X + "> . " + "  ?s <" + AGE + "> ?age . " + "  FILTER( isLiteral(?age) ) . " + "}";
            TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            if (log.isInfoEnabled()) {
                result = tupleQuery.evaluate();
                log.info((Object)"results:");
                if (!result.hasNext()) {
                    log.info((Object)"no results.");
                }
                while (result.hasNext()) {
                    log.info(result.next());
                }
            }
            result = tupleQuery.evaluate();
            LinkedList<Object> solution = new LinkedList<BindingSet>();
            solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)A), new BindingImpl("age", (Value)_25)}));
            solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)B), new BindingImpl("age", (Value)_45)}));
            this.compare(result, solution);
            query = "select ?s ?age WHERE {   ?s <" + RDF.TYPE + "> <" + X + "> . " + "  ?s <" + AGE + "> ?age . " + "  FILTER( isLiteral(" + _25.toString() + ") ) . " + "}";
            tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            if (log.isInfoEnabled()) {
                result = tupleQuery.evaluate();
                log.info((Object)"results:");
                if (!result.hasNext()) {
                    log.info((Object)"no results.");
                }
                while (result.hasNext()) {
                    log.info(result.next());
                }
            }
            result = tupleQuery.evaluate();
            solution = new LinkedList();
            solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)A), new BindingImpl("age", (Value)_25)}));
            solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)B), new BindingImpl("age", (Value)_45)}));
            this.compare(result, solution);
        }
        finally {
            cxn.close();
            sail.__tearDownUnitTest();
        }
    }
}

