/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.QuadsTestCase;
import java.net.URL;
import java.util.LinkedList;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.repository.sail.SailTupleQuery;
import org.openrdf.rio.RDFFormat;

public class TestJoinScope
extends QuadsTestCase {
    final String FOAF = "http://xmlns.com/foaf/0.1/";
    final URI FOAF_NAME = new URIImpl("http://xmlns.com/foaf/0.1/name");
    final URI FOAF_MBOX = new URIImpl("http://xmlns.com/foaf/0.1/mbox");
    final URI FOAF_NICK = new URIImpl("http://xmlns.com/foaf/0.1/nick");
    final URI FOAF_PPD = new URIImpl("http://xmlns.com/foaf/0.1/PersonalProfileDocument");
    final URI FOAF_KNOWS = new URIImpl("http://xmlns.com/foaf/0.1/knows");
    final String DC = "http://purl.org/dc/elements/1.1/";
    final URI DC_PUBLISHER = new URIImpl("http://purl.org/dc/elements/1.1/publisher");

    public TestJoinScope() {
    }

    public TestJoinScope(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJoinScope() throws Exception {
        BigdataSail sail = this.getSail();
        sail.initialize();
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        BigdataSailRepositoryConnection cxn = repo.getConnection();
        cxn.setAutoCommit(false);
        try {
            BNodeImpl a = new BNodeImpl("_:a");
            BNodeImpl b = new BNodeImpl("_:b");
            URIImpl graphA = new URIImpl("http://www.bigdata.com/rdf#graphA");
            URIImpl graphB = new URIImpl("http://www.bigdata.com/rdf#graphB");
            URIImpl s = new URIImpl("http://www.bigdata.com/rdf#s");
            URIImpl p1 = new URIImpl("http://www.bigdata.com/rdf#p1");
            URIImpl o1 = new URIImpl("http://www.bigdata.com/rdf#o1");
            URIImpl p2 = new URIImpl("http://www.bigdata.com/rdf#p2");
            URIImpl o2 = new URIImpl("http://www.bigdata.com/rdf#o2");
            URL url = new URL("file:/C:/DOCUME~1/mike/LOCALS~1/Temp/sparql2303/testcases-dawg/data-r2/algebra/var-scope-join-1.ttl");
            cxn.add(url, "", RDFFormat.TURTLE, new Resource[0]);
            cxn.flush();
            if (log.isInfoEnabled()) {
                log.info((Object)cxn.getTripleStore().dumpStore());
            }
            String query = "PREFIX : <http://example/>     SELECT *     {        ?X  :name \"paul\" .       ?X  :name \"sue\" .       ?Y :name \"george\" .       OPTIONAL { ?X :email ?Z }       OPTIONAL { ?X :address ?A }     }";
            SailTupleQuery tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            tupleQuery.setIncludeInferred(true);
            TupleQueryResult result = tupleQuery.evaluate();
            TupleExpr tupleExpr = tupleQuery.getParsedQuery().getTupleExpr();
            LinkedList<BindingSet> answer = new LinkedList<BindingSet>();
            this.compare(result, answer);
        }
        finally {
            cxn.close();
            sail.__tearDownUnitTest();
        }
    }
}

