/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.QuadsTestCase;
import com.bigdata.rdf.sparql.ast.QueryOptimizerEnum;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.BindingImpl;
import org.openrdf.repository.sail.SailTupleQuery;

public class TestLexJoinOps
extends QuadsTestCase {
    private static final Logger log = Logger.getLogger(TestLexJoinOps.class);

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public TestLexJoinOps() {
    }

    public TestLexJoinOps(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStr() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                cxn.setAutoCommit(false);
                ValueFactory vf = sail.getValueFactory();
                URI X = vf.createURI("http://www.bigdata.com/rdf#X");
                URI dt = vf.createURI("http://www.bigdata.com/rdf#myDatatype");
                Literal _1 = vf.createLiteral("foo");
                Literal _2 = vf.createLiteral("foo", XSD.STRING);
                Literal _3 = vf.createLiteral("foo", dt);
                Literal _4 = vf.createLiteral("foo", "EN");
                Literal _5 = vf.createLiteral(true);
                Literal _6 = vf.createLiteral(1000L);
                cxn.add((Resource)X, RDF.TYPE, (Value)RDFS.RESOURCE, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_1, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_2, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_3, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_4, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_5, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_6, new Resource[0]);
                cxn.commit();
                if (log.isInfoEnabled()) {
                    log.info((Object)cxn.getTripleStore().dumpStore());
                }
                String query = "prefix bd: <http://www.bigdata.com/rdf#> prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> select ?o where {   hint:Query hint:optimizer \"" + QueryOptimizerEnum.None + "\"." + "  ?s rdf:type rdfs:Resource . " + "  ?s ?p ?o . " + "  filter(str(?o) = \"foo\") " + "}";
                SailTupleQuery tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                tupleQuery.setIncludeInferred(false);
                if (log.isInfoEnabled()) {
                    log.info((Object)query);
                    TupleQueryResult result = tupleQuery.evaluate();
                    while (result.hasNext()) {
                        log.info(result.next());
                    }
                }
                LinkedList<BindingSet> answer = new LinkedList<BindingSet>();
                answer.add(this.createBindingSet(new Binding[]{new BindingImpl("o", (Value)_1)}));
                answer.add(this.createBindingSet(new Binding[]{new BindingImpl("o", (Value)_2)}));
                answer.add(this.createBindingSet(new Binding[]{new BindingImpl("o", (Value)_3)}));
                answer.add(this.createBindingSet(new Binding[]{new BindingImpl("o", (Value)_4)}));
                TupleQueryResult result = tupleQuery.evaluate();
                this.compare(result, answer);
            }
        }
        finally {
            if (sail instanceof BigdataSail) {
                sail.__tearDownUnitTest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegex() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                cxn.setAutoCommit(false);
                ValueFactory vf = sail.getValueFactory();
                URI X = vf.createURI("http://www.bigdata.com/rdf#X");
                URI dt = vf.createURI("http://www.bigdata.com/rdf#myDatatype");
                Literal _1 = vf.createLiteral("foo");
                Literal _2 = vf.createLiteral("foo", XSD.STRING);
                Literal _3 = vf.createLiteral("foo", dt);
                Literal _4 = vf.createLiteral("foo", "EN");
                Literal _5 = vf.createLiteral(true);
                Literal _6 = vf.createLiteral(1000L);
                cxn.add((Resource)X, RDF.TYPE, (Value)RDFS.RESOURCE, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_1, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_2, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_3, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_4, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_5, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_6, new Resource[0]);
                cxn.commit();
                if (log.isInfoEnabled()) {
                    log.info((Object)cxn.getTripleStore().dumpStore());
                }
                String query = "prefix bd: <http://www.bigdata.com/rdf#> prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> select ?o where {   hint:Query hint:optimizer \"" + QueryOptimizerEnum.None + "\"." + "  ?s rdf:type rdfs:Resource . " + "  ?s ?p ?o . " + "  filter(regex(str(?o), \"FOO\", \"i\")) " + "}";
                SailTupleQuery tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                tupleQuery.setIncludeInferred(false);
                if (log.isInfoEnabled()) {
                    log.info((Object)query);
                    TupleQueryResult result = tupleQuery.evaluate();
                    while (result.hasNext()) {
                        log.info(result.next());
                    }
                }
                LinkedList<BindingSet> answer = new LinkedList<BindingSet>();
                answer.add(this.createBindingSet(new Binding[]{new BindingImpl("o", (Value)_1)}));
                answer.add(this.createBindingSet(new Binding[]{new BindingImpl("o", (Value)_2)}));
                answer.add(this.createBindingSet(new Binding[]{new BindingImpl("o", (Value)_3)}));
                answer.add(this.createBindingSet(new Binding[]{new BindingImpl("o", (Value)_4)}));
                TupleQueryResult result = tupleQuery.evaluate();
                this.compare(result, answer);
            }
        }
        finally {
            if (sail instanceof BigdataSail) {
                sail.__tearDownUnitTest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCastAndDatatype() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                cxn.setAutoCommit(false);
                ValueFactory vf = sail.getValueFactory();
                URI X = vf.createURI("http://www.bigdata.com/rdf#X");
                URI dt = vf.createURI("http://www.bigdata.com/rdf#myDatatype");
                Literal _1 = vf.createLiteral("foo");
                Literal _2 = vf.createLiteral("foo", XSD.STRING);
                Literal _3 = vf.createLiteral("foo", dt);
                Literal _4 = vf.createLiteral("foo", "EN");
                Literal _5 = vf.createLiteral(true);
                Literal _6 = vf.createLiteral(1000L);
                cxn.add((Resource)X, RDF.TYPE, (Value)RDFS.RESOURCE, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_1, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_2, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_3, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_4, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_5, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_6, new Resource[0]);
                cxn.commit();
                if (log.isInfoEnabled()) {
                    log.info((Object)cxn.getTripleStore().dumpStore());
                }
                String query = "prefix bd: <http://www.bigdata.com/rdf#> prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> select ?o where {   hint:Query hint:optimizer \"" + QueryOptimizerEnum.None + "\"." + "  ?s rdf:type rdfs:Resource . " + "  ?s ?p ?o . " + "  FILTER(datatype(xsd:boolean(?o)) = xsd:boolean) . " + "}";
                SailTupleQuery tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                tupleQuery.setIncludeInferred(false);
                if (log.isInfoEnabled()) {
                    log.info((Object)query);
                    TupleQueryResult result = tupleQuery.evaluate();
                    while (result.hasNext()) {
                        log.info(result.next());
                    }
                }
                LinkedList<BindingSet> answer = new LinkedList<BindingSet>();
                answer.add(this.createBindingSet(new Binding[]{new BindingImpl("o", (Value)_5)}));
                answer.add(this.createBindingSet(new Binding[]{new BindingImpl("o", (Value)_6)}));
                TupleQueryResult result = tupleQuery.evaluate();
                this.compare(result, answer);
            }
        }
        finally {
            if (sail instanceof BigdataSail) {
                sail.__tearDownUnitTest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLang() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                cxn.setAutoCommit(false);
                ValueFactory vf = sail.getValueFactory();
                URI X = vf.createURI("http://www.bigdata.com/rdf#X");
                URI Y = vf.createURI("http://www.bigdata.com/rdf#Y");
                Literal _1 = vf.createLiteral("That Seventies Show", "en");
                Literal _2 = vf.createLiteral("Cette S\ufffdrie des Ann\ufffdes Soixante-dix", "fr");
                Literal _3 = vf.createLiteral("Cette S\ufffdrie des Ann\ufffdes Septante", "fr-BE");
                Literal _4 = vf.createLiteral("Il Buono, il Bruto, il Cattivo");
                cxn.add((Resource)X, RDFS.LABEL, (Value)_1, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_2, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_3, new Resource[0]);
                cxn.add((Resource)Y, RDFS.LABEL, (Value)_4, new Resource[0]);
                cxn.commit();
                if (log.isInfoEnabled()) {
                    log.info((Object)cxn.getTripleStore().dumpStore());
                }
                String query = "prefix bd: <http://www.bigdata.com/rdf#> prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> select ?title where {   hint:Query hint:optimizer \"" + QueryOptimizerEnum.None + "\"." + "  ?s rdfs:label \"That Seventies Show\"@en . " + "  ?s rdfs:label ?title . " + "  FILTER langMatches( lang(?title), \"FR\" ) . " + "}";
                SailTupleQuery tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                tupleQuery.setIncludeInferred(false);
                if (log.isInfoEnabled()) {
                    log.info((Object)query);
                    TupleQueryResult result = tupleQuery.evaluate();
                    while (result.hasNext()) {
                        log.info(result.next());
                    }
                }
                LinkedList<BindingSet> answer = new LinkedList<BindingSet>();
                answer.add(this.createBindingSet(new Binding[]{new BindingImpl("title", (Value)_2)}));
                answer.add(this.createBindingSet(new Binding[]{new BindingImpl("title", (Value)_3)}));
                TupleQueryResult result = tupleQuery.evaluate();
                this.compare(result, answer);
            }
        }
        finally {
            if (sail instanceof BigdataSail) {
                sail.__tearDownUnitTest();
            }
        }
    }
}

