/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.btree.AbstractNode;
import com.bigdata.btree.BTree;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.counters.CAT;
import com.bigdata.journal.BufferMode;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import com.bigdata.service.AbstractTransactionService;
import com.bigdata.util.DaemonThreadFactory;
import com.bigdata.util.InnerCause;
import info.aduna.iteration.CloseableIteration;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sail.SailException;

public abstract class TestMROWTransactions
extends ProxyBigdataSailTestCase {
    TestMROWTransactions() {
    }

    TestMROWTransactions(String arg0) {
        super(arg0);
    }

    void domultiple_csem_transaction2(int retentionMillis, int nreaderThreads, int nwriters, int nreaders, boolean isolatableIndices) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)"=================================================================================");
            log.info((Object)("retentionMillis=" + retentionMillis + ", nreaderThreads=" + nreaderThreads + ", nwriters=" + nwriters + ", nreaders=" + nreaders + ", isolatableIndices=" + isolatableIndices));
            log.info((Object)"=================================================================================");
        }
        BigdataSail sail = this.getSail(this.getProperties(retentionMillis, isolatableIndices));
        TestMROWTransactions.domultiple_csem_transaction2(sail, nreaderThreads, nwriters, nreaders, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void domultiple_csem_transaction2(BigdataSail sail, int nreaderThreads, int nwriters, int nreaders, boolean teardown) throws Exception {
        int nuris = 2000;
        int npreds = 50;
        Random r = new Random();
        CAT commits = new CAT();
        CAT aborts = new CAT();
        CAT nreadersDone = new CAT();
        AtomicReference<Object> failex = new AtomicReference<Object>(null);
        AtomicBoolean success = new AtomicBoolean(false);
        try {
            sail.initialize();
            URI[] subs = new URI[2000];
            for (int i = 0; i < 2000; ++i) {
                subs[i] = TestMROWTransactions.uri("uri:" + i);
            }
            URI[] preds = new URI[50];
            for (int i = 0; i < 50; ++i) {
                preds[i] = TestMROWTransactions.uri("pred:" + i);
            }
            ExecutorService writers = null;
            ExecutorService readers = null;
            try {
                Throwable ex;
                writers = Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory("test-writer-pool"));
                readers = Executors.newFixedThreadPool(nreaderThreads, (ThreadFactory)new DaemonThreadFactory("test-reader-pool"));
                Future<Long> lastWriterFuture = null;
                Future<Long> lastReaderFuture = null;
                for (int i = 0; i < nwriters; ++i) {
                    lastWriterFuture = writers.submit(new Writer(r, 500, sail, commits, aborts, failex, subs, preds));
                }
                for (int rdrs = 0; rdrs < nreaders; ++rdrs) {
                    int nreads = rdrs == 0 ? Integer.MAX_VALUE : 60;
                    lastReaderFuture = readers.submit(new Reader(r, nreads, nwriters, sail, failex, commits, nreadersDone, subs));
                }
                while (!lastWriterFuture.isDone() && failex.get() == null) {
                    Thread.sleep(250L);
                }
                if (failex.get() == null) {
                    success.set(true);
                }
                writers.shutdownNow();
                readers.shutdownNow();
                writers.awaitTermination(5L, TimeUnit.SECONDS);
                readers.awaitTermination(5L, TimeUnit.SECONDS);
                if (!success.get() && (ex = (Throwable)failex.get()) != null) {
                    TestMROWTransactions.fail((String)("Test failed: firstCause=" + ex + ", nreaderThreads=" + nreaderThreads + ", nwriters=" + nwriters + ", nreaders=" + nreaders + ", indexManager=" + sail.getIndexManager()), (Throwable)ex);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Writers committed: " + commits.get() + ", writers aborted: " + aborts.get() + ", readers done: " + nreadersDone.get()));
                }
            }
            finally {
                if (writers != null) {
                    writers.shutdownNow();
                }
                if (readers != null) {
                    readers.shutdownNow();
                }
            }
        }
        finally {
            if (teardown) {
                try {
                    sail.__tearDownUnitTest();
                }
                catch (Throwable t) {
                    log.error((Object)("Problem with test shutdown: " + t), t);
                }
            }
        }
    }

    protected static URI uri(String s) {
        return new URIImpl("http://www.bigdata.com/rdf#" + s);
    }

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        props.setProperty(BigdataSail.Options.BUFFER_MODE, BufferMode.DiskRW.toString());
        props.setProperty(IndexMetadata.Options.WRITE_RETENTION_QUEUE_CAPACITY, "500");
        props.setProperty(IndexMetadata.Options.WRITE_RETENTION_QUEUE_SCAN, "10");
        return props;
    }

    protected Properties getProperties(int retention, boolean isolatableIndices) {
        Properties props = this.getProperties();
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        props.setProperty(BigdataSail.Options.BUFFER_MODE, BufferMode.DiskRW.toString());
        props.setProperty(IndexMetadata.Options.WRITE_RETENTION_QUEUE_CAPACITY, "500");
        props.setProperty(IndexMetadata.Options.WRITE_RETENTION_QUEUE_SCAN, "10");
        TestMROWTransactions.setProperties(props, retention, isolatableIndices);
        return props;
    }

    static void setProperties(Properties props, int retention, boolean isolatableIndices) {
        props.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, Boolean.toString(isolatableIndices));
        props.setProperty(AbstractTransactionService.Options.MIN_RELEASE_AGE, "" + retention);
        boolean isQuads = Boolean.valueOf(props.getProperty(BigdataSail.Options.QUADS_MODE, "false"));
        if (!isolatableIndices) {
            String name = isQuads ? "SPOC" : "SPO";
            props.setProperty("com.bigdata.namespace.kb.spo." + name + ".com.bigdata.btree.BTree.className", MyBTree.class.getName());
        }
    }

    static long getLongArg(String[] args, String arg, long def) {
        String sv = TestMROWTransactions.getArg(args, arg, null);
        return sv == null ? def : Long.parseLong(sv);
    }

    static String getArg(String[] args, String arg, String def) {
        for (int p = 0; p < args.length; p += 2) {
            if (!arg.equals(args[p])) continue;
            return args[p + 1];
        }
        return def;
    }

    public static void main(String[] args) throws Exception {
        String propertyFile = TestMROWTransactions.getArg(args, "-propertyfile", null);
        if (propertyFile == null) {
            System.out.println("-propertyfile <properties> must be specified");
            return;
        }
        Properties props = new Properties();
        props.load(new FileInputStream(propertyFile));
        final AtomicReference<BigdataSail> sail = new AtomicReference<BigdataSail>(new BigdataSail(props));
        int nreaderThreads = (int)TestMROWTransactions.getLongArg(args, "-nreaderthreads", 20L);
        long nwriters = TestMROWTransactions.getLongArg(args, "-nwriters", 100L);
        long nreaders = TestMROWTransactions.getLongArg(args, "-nreaders", 400L);
        long nruns = TestMROWTransactions.getLongArg(args, "-nruns", 1L);
        Thread sailShutdown = new Thread(){

            @Override
            public void run() {
                Random r = new Random();
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(r.nextInt(50000));
                            if (!((BigdataSail)sail.get()).isOpen()) continue;
                            log.warn((Object)"SHUTDOWN NOW");
                            ((BigdataSail)sail.get()).shutDown();
                        }
                    }
                    catch (InterruptedException e) {
                    }
                    catch (SailException e) {
                        log.warn((Object)e);
                        continue;
                    }
                    break;
                }
            }
        };
        sailShutdown.start();
        int i = 0;
        while ((long)i < nruns) {
            try {
                TestMROWTransactions.domultiple_csem_transaction2(sail.get(), nreaderThreads, (int)nwriters, (int)nreaders, false);
                if (sail.get().isOpen()) {
                    sail.get().shutDown();
                }
            }
            catch (Throwable e) {
                log.warn((Object)"OOPS", e);
            }
            sail.set(new BigdataSail(props));
            System.out.println("Completed run: " + i);
            ++i;
        }
        sailShutdown.interrupt();
    }

    private static class MyBTreeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public MyBTreeException(String string) {
            super(string);
        }
    }

    public static class MyBTree
    extends BTree {
        private final Random r = new Random(12L);

        public MyBTree(IRawStore store, Checkpoint checkpoint, IndexMetadata metadata, boolean readOnly) {
            super(store, checkpoint, metadata, readOnly);
        }

        protected long writeNodeOrLeaf(AbstractNode<?> node) {
            if (node.isLeaf() && this.r.nextInt(500) == 0) {
                throw new MyBTreeException("Forcing abort: " + (Object)((Object)this));
            }
            long addr = super.writeNodeOrLeaf(node);
            return addr;
        }
    }

    private static class Reader
    implements Callable<Long> {
        final Random r;
        final int nreads;
        final int nwriters;
        final BigdataSail sail;
        final AtomicReference<Throwable> failex;
        final CAT commits;
        final CAT nreadersDone;
        final int nuris;
        final URI[] subs;

        Reader(Random r, int nreads, int nwriters, BigdataSail sail, AtomicReference<Throwable> failex, CAT commits, CAT nreadersDone, URI[] subs) {
            this.r = r;
            this.nreads = nreads;
            this.nwriters = nwriters;
            this.sail = sail;
            this.failex = failex;
            this.commits = commits;
            this.nreadersDone = nreadersDone;
            this.nuris = subs.length;
            this.subs = subs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long call() throws Exception {
            BigdataSail.BigdataSailConnection con = null;
            try {
                con = this.sail.getReadOnlyConnection();
                if (this.commits.get() < (long)Math.max(this.nwriters, 5)) {
                    Thread.sleep(2000L);
                }
                for (int i = 0; i < this.nreads; ++i) {
                    try (CloseableIteration stats = con.getStatements((Resource)this.subs[this.r.nextInt(this.nuris)], (URI)null, (Value)null, (Resource)null);){
                        while (stats.hasNext()) {
                            stats.next();
                        }
                        continue;
                    }
                }
            }
            catch (Throwable ise) {
                if (InnerCause.isInnerCause((Throwable)ise, InterruptedException.class)) {
                } else if (this.failex.compareAndSet(null, ise)) {
                    log.error((Object)("firstCause:" + ise), ise);
                } else if (log.isInfoEnabled()) {
                    log.info((Object)("Other error: " + ise), ise);
                }
            }
            finally {
                if (con != null) {
                    con.rollback();
                    con.close();
                }
                this.nreadersDone.increment();
            }
            return null;
        }
    }

    private static class Writer
    implements Callable<Long> {
        final Random r;
        final int nwrites;
        final BigdataSail sail;
        final CAT commits;
        final CAT aborts;
        final AtomicReference<Throwable> failex;
        final int nuris;
        final int npreds;
        final URI[] subs;
        final URI[] preds;

        Writer(Random r, int nwrites, BigdataSail sail, CAT commits, CAT aborts, AtomicReference<Throwable> failex, URI[] subs, URI[] preds) {
            this.r = r;
            this.nwrites = nwrites;
            this.sail = sail;
            this.commits = commits;
            this.aborts = aborts;
            this.failex = failex;
            this.nuris = subs.length;
            this.npreds = preds.length;
            this.subs = subs;
            this.preds = preds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long call() throws Exception {
            BigdataSail.BigdataSailConnection con = null;
            boolean ok = false;
            try {
                con = this.sail.getConnection();
                boolean isQuads = con.isQuads();
                for (int i = 0; i < this.nwrites; ++i) {
                    con.addStatement((Resource)this.subs[this.r.nextInt(this.nuris)], this.preds[this.r.nextInt(this.npreds)], (Value)this.subs[this.r.nextInt(this.nuris)], new Resource[]{isQuads ? this.subs[this.r.nextInt(this.nuris)] : null});
                }
                con.commit();
                ok = true;
                this.commits.increment();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Commit #" + this.commits));
                }
            }
            catch (Throwable ise) {
                if (InnerCause.isInnerCause((Throwable)ise, InterruptedException.class)) {
                } else if (InnerCause.isInnerCause((Throwable)ise, MyBTreeException.class)) {
                } else {
                    log.warn((Object)ise, ise);
                    if (this.failex.compareAndSet(null, ise)) {
                        log.error((Object)("firstCause:" + ise), ise);
                    }
                }
            }
            finally {
                if (con != null) {
                    if (!ok) {
                        con.rollback();
                        this.aborts.increment();
                        log.error((Object)("Abort #" + this.aborts + " (with " + this.commits.get() + " commits)"));
                    }
                    con.close();
                }
            }
            return null;
        }
    }
}

