/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.sail.SailTupleQuery;

public class TestMaterialization
extends ProxyBigdataSailTestCase {
    protected static final Logger log = Logger.getLogger(TestMaterialization.class);
    protected static final boolean INFO = log.isInfoEnabled();

    public TestMaterialization() {
    }

    public TestMaterialization(String arg0) {
        super(arg0);
    }

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "true");
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegex() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                cxn.setAutoCommit(false);
                ValueFactory vf = sail.getValueFactory();
                URI X = vf.createURI("http://www.bigdata.com/rdf#X");
                Literal label = vf.createLiteral("John");
                cxn.add((Resource)X, RDF.TYPE, (Value)RDFS.RESOURCE, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)label, new Resource[0]);
                cxn.commit();
                if (log.isInfoEnabled()) {
                    log.info((Object)cxn.getTripleStore().dumpStore());
                }
                String query = "select * where { ?s ?p ?o . FILTER (regex(?o,\"John\",\"i\")) }";
                SailTupleQuery tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, "select * where { ?s ?p ?o . FILTER (regex(?o,\"John\",\"i\")) }");
                tupleQuery.setIncludeInferred(true);
                if (log.isInfoEnabled()) {
                    log.info((Object)"select * where { ?s ?p ?o . FILTER (regex(?o,\"John\",\"i\")) }");
                    TupleQueryResult result = tupleQuery.evaluate();
                    while (result.hasNext()) {
                        log.info(result.next());
                    }
                }
            }
        }
        finally {
            if (sail instanceof BigdataSail) {
                sail.__tearDownUnitTest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStr() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                cxn.setAutoCommit(false);
                ValueFactory vf = sail.getValueFactory();
                URI X = vf.createURI("http://www.bigdata.com/rdf#X");
                Literal label = vf.createLiteral("John");
                cxn.add((Resource)X, RDF.TYPE, (Value)RDFS.RESOURCE, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)label, new Resource[0]);
                cxn.commit();
                if (log.isInfoEnabled()) {
                    log.info((Object)cxn.getTripleStore().dumpStore());
                }
                String query = "select * where { ?s ?p ?o . FILTER (str(?o) = \"" + RDF.PROPERTY + "\") }";
                SailTupleQuery tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                tupleQuery.setIncludeInferred(true);
                if (log.isInfoEnabled()) {
                    log.info((Object)query);
                    TupleQueryResult result = tupleQuery.evaluate();
                    if (result.hasNext()) {
                        while (result.hasNext()) {
                            log.info(result.next());
                        }
                    } else {
                        TestMaterialization.fail((String)"expecting result from the vocab");
                    }
                }
            }
        }
        finally {
            if (sail instanceof BigdataSail) {
                sail.__tearDownUnitTest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testXsdStr() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                cxn.setAutoCommit(false);
                ValueFactory vf = sail.getValueFactory();
                URI X = vf.createURI("http://www.bigdata.com/rdf#X");
                Literal label = vf.createLiteral("John");
                cxn.add((Resource)X, RDF.TYPE, (Value)RDFS.RESOURCE, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)label, new Resource[0]);
                cxn.commit();
                if (log.isInfoEnabled()) {
                    log.info((Object)cxn.getTripleStore().dumpStore());
                }
                String query = "select * where { ?s ?p ?o . FILTER (xsd:string(?o) = \"" + RDF.PROPERTY + "\"^^xsd:string) }";
                SailTupleQuery tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                tupleQuery.setIncludeInferred(true);
                if (log.isInfoEnabled()) {
                    log.info((Object)query);
                    TupleQueryResult result = tupleQuery.evaluate();
                    if (result.hasNext()) {
                        while (result.hasNext()) {
                            log.info(result.next());
                        }
                    } else {
                        TestMaterialization.fail((String)"expecting result from the vocab");
                    }
                }
            }
        }
        finally {
            if (sail instanceof BigdataSail) {
                sail.__tearDownUnitTest();
            }
        }
    }
}

