/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.Options;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.QuadsTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.SailTupleQuery;
import org.openrdf.rio.RDFFormat;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class TestMillisecondPrecisionForInlineDateTimes
extends QuadsTestCase {
    private static final Logger log = Logger.getLogger(TestMillisecondPrecisionForInlineDateTimes.class);

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        props.setProperty(BigdataSail.Options.INLINE_DATE_TIMES, "true");
        props.setProperty(BigdataSail.Options.INLINE_DATE_TIMES_TIMEZONE, "GMT");
        props.setProperty(Options.BUFFER_MODE, BufferMode.Transient.toString());
        return props;
    }

    public TestMillisecondPrecisionForInlineDateTimes() {
    }

    public TestMillisecondPrecisionForInlineDateTimes(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug() throws Exception {
        MemoryStore sesameSail = null;
        BigdataSail bigdataSail = null;
        try {
            TupleQueryResult result;
            SailTupleQuery tupleQuery;
            sesameSail = new MemoryStore();
            bigdataSail = this.getSail();
            String data = "TestMillisecondPrecisionForInlineDateTimes.ttl";
            String baseURI = "";
            RDFFormat format = RDFFormat.TURTLE;
            String query = "prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> SELECT DISTINCT ?ar WHERE {\n  FILTER(?datePub>=\"2011-03-08T08:48:27.003\"^^<http://www.w3.org/2001/XMLSchema#dateTime>).\n  ?ar <os:prop/analysis/datePublished> ?datePub\n} ORDER BY DESC(?datePub)";
            sesameSail.initialize();
            bigdataSail.initialize();
            SailRepository sesameRepo = new SailRepository((Sail)sesameSail);
            BigdataSailRepository bigdataRepo = new BigdataSailRepository(bigdataSail);
            try (RepositoryConnection cxn = sesameRepo.getConnection();){
                cxn.setAutoCommit(false);
                cxn.add(((Object)((Object)this)).getClass().getResourceAsStream("TestMillisecondPrecisionForInlineDateTimes.ttl"), "", format, new Resource[0]);
                cxn.commit();
            }
            cxn = bigdataRepo.getConnection();
            try {
                cxn.setAutoCommit(false);
                cxn.add(((Object)((Object)this)).getClass().getResourceAsStream("TestMillisecondPrecisionForInlineDateTimes.ttl"), "", format, new Resource[0]);
                cxn.commit();
            }
            finally {
                cxn.close();
            }
            LinkedList<BindingSet> answer = new LinkedList<BindingSet>();
            try (RepositoryConnection cxn = sesameRepo.getConnection();){
                tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, "prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> SELECT DISTINCT ?ar WHERE {\n  FILTER(?datePub>=\"2011-03-08T08:48:27.003\"^^<http://www.w3.org/2001/XMLSchema#dateTime>).\n  ?ar <os:prop/analysis/datePublished> ?datePub\n} ORDER BY DESC(?datePub)");
                tupleQuery.setIncludeInferred(false);
                result = tupleQuery.evaluate();
                if (log.isInfoEnabled()) {
                    log.info((Object)"sesame results:");
                    if (!result.hasNext()) {
                        log.info((Object)"no results.");
                    }
                }
                while (result.hasNext()) {
                    BindingSet bs = (BindingSet)result.next();
                    answer.add(bs);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)bs);
                }
            }
            cxn = bigdataRepo.getReadOnlyConnection();
            try {
                tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, "prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> SELECT DISTINCT ?ar WHERE {\n  FILTER(?datePub>=\"2011-03-08T08:48:27.003\"^^<http://www.w3.org/2001/XMLSchema#dateTime>).\n  ?ar <os:prop/analysis/datePublished> ?datePub\n} ORDER BY DESC(?datePub)");
                tupleQuery.setIncludeInferred(false);
                if (log.isInfoEnabled()) {
                    result = tupleQuery.evaluate();
                    log.info((Object)"bigdata results:");
                    if (!result.hasNext()) {
                        log.info((Object)"no results.");
                    }
                    while (result.hasNext()) {
                        log.info(result.next());
                    }
                }
                result = tupleQuery.evaluate();
                this.compare(result, answer);
            }
            finally {
                cxn.close();
            }
        }
        finally {
            if (sesameSail != null) {
                sesameSail.shutDown();
            }
            if (bigdataSail != null) {
                bigdataSail.__tearDownUnitTest();
            }
        }
    }
}

