/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.BindingImpl;
import org.openrdf.repository.sail.SailRepositoryConnection;

public class TestMultiGraphs
extends ProxyBigdataSailTestCase {
    protected static final Logger log = Logger.getLogger(TestMultiGraphs.class);

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public TestMultiGraphs() {
    }

    public TestMultiGraphs(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiGraphs() throws Exception {
        BigdataSail bdSail;
        BigdataSail sail = bdSail = this.getSail();
        BigdataSailRepository repo = new BigdataSailRepository(bdSail);
        repo.initialize();
        SailRepositoryConnection cxn = repo.getConnection();
        try {
            if (cxn instanceof BigdataSailRepositoryConnection && !((BigdataSailRepositoryConnection)cxn).getTripleStore().isQuads()) {
                sail.__tearDownUnitTest();
                return;
            }
            cxn.setAutoCommit(false);
            ValueFactory vf = sail.getValueFactory();
            String ns = "http://www.bigdata.com/rdf#";
            URI mike = vf.createURI("http://www.bigdata.com/rdf#Mike");
            URI person = vf.createURI("http://www.bigdata.com/rdf#Person");
            URI likes = vf.createURI("http://www.bigdata.com/rdf#likes");
            URI rdf = vf.createURI("http://www.bigdata.com/rdf#RDF");
            Literal l1 = vf.createLiteral("Mike");
            URI g1 = vf.createURI("http://www.bigdata.com/rdf#graph1");
            URI g2 = vf.createURI("http://www.bigdata.com/rdf#graph2");
            cxn.setNamespace("ns", "http://www.bigdata.com/rdf#");
            cxn.add((Resource)mike, RDF.TYPE, (Value)person, new Resource[]{g1, g2});
            cxn.add((Resource)mike, likes, (Value)rdf, new Resource[]{g1, g2});
            cxn.add((Resource)mike, RDFS.LABEL, (Value)l1, new Resource[]{g1, g2});
            cxn.commit();
            if (log.isInfoEnabled() && sail instanceof BigdataSail) {
                log.info((Object)("\n" + ((BigdataSailRepositoryConnection)cxn).getTripleStore().dumpStore()));
            }
            String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX ns: <http://www.bigdata.com/rdf#> select distinct ?p ?o WHERE {   ns:Mike ?p ?o . }";
            TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            TupleQueryResult result = tupleQuery.evaluate();
            LinkedList<Object> solution = new LinkedList<BindingSet>();
            solution.add(this.createBindingSet(new Binding[]{new BindingImpl("p", (Value)RDF.TYPE), new BindingImpl("o", (Value)person)}));
            solution.add(this.createBindingSet(new Binding[]{new BindingImpl("p", (Value)likes), new BindingImpl("o", (Value)rdf)}));
            solution.add(this.createBindingSet(new Binding[]{new BindingImpl("p", (Value)RDFS.LABEL), new BindingImpl("o", (Value)l1)}));
            this.compare(result, solution);
            query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX ns: <http://www.bigdata.com/rdf#> select ?p ?o from <" + g1 + ">" + "from <" + g2 + ">" + "WHERE { " + "  ns:Mike ?p ?o . " + "}";
            tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            result = tupleQuery.evaluate();
            solution = new LinkedList();
            solution.add(this.createBindingSet(new Binding[]{new BindingImpl("p", (Value)RDF.TYPE), new BindingImpl("o", (Value)person)}));
            solution.add(this.createBindingSet(new Binding[]{new BindingImpl("p", (Value)likes), new BindingImpl("o", (Value)rdf)}));
            solution.add(this.createBindingSet(new Binding[]{new BindingImpl("p", (Value)RDFS.LABEL), new BindingImpl("o", (Value)l1)}));
            this.compare(result, solution);
        }
        finally {
            cxn.close();
            if (sail instanceof BigdataSail) {
                sail.__tearDownUnitTest();
            }
        }
    }
}

