/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.AbstractBigdataSailTestCase;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.QuadsTestCase;
import com.bigdata.rdf.sail.TestBigdataSailWithQuads;
import com.bigdata.rdf.sail.sparql.ast.ParseException;
import com.bigdata.rdf.sail.sparql.ast.TokenMgrError;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import junit.framework.Test;
import org.apache.commons.io.IOUtils;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;

public class TestNoExceptions
extends QuadsTestCase {
    public TestNoExceptions() {
    }

    public TestNoExceptions(String name) {
        super(name);
    }

    @Override
    public AbstractBigdataSailTestCase getOurDelegate() {
        if (this.getDelegate() == null) {
            String testClass = System.getProperty("testClass");
            if (testClass != null) {
                return super.getOurDelegate();
            }
            this.setDelegate((Test)new TestBigdataSailWithQuads());
        }
        return (AbstractBigdataSailTestCase)super.getDelegate();
    }

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.STATEMENT_IDENTIFIERS, "false");
        return props;
    }

    public void test_namedSubquery746() throws Exception, TokenMgrError, ParseException, IOException {
        this.optimizeQuery("ticket746");
    }

    public void test_filterSubselect737() throws Exception, TokenMgrError, ParseException, IOException {
        this.optimizeQuery("filterSubselect737");
    }

    public void test_nestedSubselectsWithUnion737() throws Exception, TokenMgrError, ParseException, IOException {
        this.optimizeQuery("nestedSubselectsWithUnion737");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void optimizeQuery(String queryfile) throws Exception {
        String sparql = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(queryfile + ".rq"));
        BigdataSail sail = this.getSail();
        try {
            this.executeQuery((SailRepository)new BigdataSailRepository(sail), sparql);
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery(SailRepository repo, String query) throws RepositoryException, MalformedQueryException, QueryEvaluationException, RDFParseException, IOException, RDFHandlerException {
        try {
            repo.initialize();
            conn.setAutoCommit(false);
            try (SailRepositoryConnection conn = repo.getConnection();){
                ValueFactory vf = conn.getValueFactory();
                conn.commit();
                TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                TupleQueryResult tqr = tq.evaluate();
                tqr.close();
            }
        }
        finally {
            repo.shutDown();
        }
    }
}

