/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.QuadsTestCase;
import java.util.LinkedList;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.BindingImpl;

public class TestOptionals
extends QuadsTestCase {
    final String FOAF = "http://xmlns.com/foaf/0.1/";
    final URI FOAF_NAME = new URIImpl("http://xmlns.com/foaf/0.1/name");
    final URI FOAF_MBOX = new URIImpl("http://xmlns.com/foaf/0.1/mbox");
    final URI FOAF_NICK = new URIImpl("http://xmlns.com/foaf/0.1/nick");
    final URI FOAF_PPD = new URIImpl("http://xmlns.com/foaf/0.1/PersonalProfileDocument");
    final URI FOAF_KNOWS = new URIImpl("http://xmlns.com/foaf/0.1/knows");
    final String DC = "http://purl.org/dc/elements/1.1/";
    final URI DC_PUBLISHER = new URIImpl("http://purl.org/dc/elements/1.1/publisher");
    final URI DC_TITLE = new URIImpl("http://purl.org/dc/elements/1.1/title");

    public TestOptionals() {
    }

    public TestOptionals(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLeftJoins() throws Exception {
        BigdataSail sail = this.getSail();
        sail.initialize();
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        BigdataSailRepositoryConnection cxn = repo.getConnection();
        cxn.setAutoCommit(false);
        try {
            URIImpl book1 = new URIImpl("http://www.bigdata.com/rdf#book1");
            URIImpl book2 = new URIImpl("http://www.bigdata.com/rdf#book2");
            URIImpl book3 = new URIImpl("http://www.bigdata.com/rdf#book3");
            URIImpl price = new URIImpl("http://www.bigdata.com/rdf#price");
            URIImpl XSD_INTEGER = new URIImpl("http://www.w3.org/2001/XMLSchema#integer");
            cxn.add((Resource)book1, this.DC_TITLE, (Value)new LiteralImpl("TITLE 1"), new Resource[0]);
            cxn.add((Resource)book1, (URI)price, (Value)new LiteralImpl("10", (URI)XSD_INTEGER), new Resource[0]);
            cxn.add((Resource)book2, this.DC_TITLE, (Value)new LiteralImpl("TITLE 2"), new Resource[0]);
            cxn.add((Resource)book2, (URI)price, (Value)new LiteralImpl("20", (URI)XSD_INTEGER), new Resource[0]);
            cxn.add((Resource)book3, this.DC_TITLE, (Value)new LiteralImpl("TITLE 3"), new Resource[0]);
            cxn.commit();
            if (log.isInfoEnabled()) {
                log.info((Object)cxn.getTripleStore().dumpStore());
            }
            String query = "SELECT ?title ?price WHERE { ?book <" + this.DC_TITLE + "> ?title . " + "OPTIONAL { ?book <" + price + "> ?price . } . " + "}";
            TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            tupleQuery.setIncludeInferred(true);
            TupleQueryResult result = tupleQuery.evaluate();
            LinkedList<BindingSet> answer = new LinkedList<BindingSet>();
            answer.add(this.createBindingSet(new Binding[]{new BindingImpl("title", (Value)new LiteralImpl("TITLE 1")), new BindingImpl("price", (Value)new LiteralImpl("10", (URI)XSD_INTEGER))}));
            answer.add(this.createBindingSet(new Binding[]{new BindingImpl("title", (Value)new LiteralImpl("TITLE 2")), new BindingImpl("price", (Value)new LiteralImpl("20", (URI)XSD_INTEGER))}));
            answer.add(this.createBindingSet(new Binding[]{new BindingImpl("title", (Value)new LiteralImpl("TITLE 3"))}));
            this.compare(result, answer);
        }
        finally {
            cxn.close();
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptional() throws Exception {
        Properties properties = this.getProperties();
        properties.put("com.bigdata.rdf.store.AbstractTripleStore.axiomsClass", "com.bigdata.rdf.axioms.NoAxioms");
        properties.put("com.bigdata.rdf.sail.truthMaintenance", "false");
        properties.put("com.bigdata.rdf.store.AbstractTripleStore.vocabularyClass", "com.bigdata.rdf.vocab.NoVocabulary");
        properties.put("com.bigdata.rdf.store.AbstractTripleStore.justify", "false");
        BigdataSail sail = this.getSail(properties);
        sail.initialize();
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        BigdataSailRepositoryConnection cxn = repo.getConnection();
        cxn.setAutoCommit(false);
        try {
            ValueFactory vf = sail.getValueFactory();
            cxn.add((Resource)vf.createURI("u:1"), vf.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (Value)vf.createURI("u:2"), new Resource[0]);
            cxn.commit();
            String query = "SELECT REDUCED ?subj ?subj_class ?subj_label WHERE {   ?subj a ?subj_class .   OPTIONAL { ?subj <http://www.w3.org/2000/01/rdf-schema#label> ?subj_label } }";
            TupleQuery q = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            q.setBinding("subj", (Value)vf.createURI("u:1"));
            TupleQueryResult tqr = q.evaluate();
            TestOptionals.assertTrue((boolean)tqr.hasNext());
            BindingSet tmp = (BindingSet)tqr.next();
            if (log.isInfoEnabled()) {
                log.info((Object)tmp);
            }
            tqr.close();
        }
        finally {
            cxn.close();
            sail.__tearDownUnitTest();
        }
    }
}

