/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;

public class TestOrderBy
extends ProxyBigdataSailTestCase {
    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "true");
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public TestOrderBy() {
    }

    public TestOrderBy(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderBy() throws Exception {
        BigdataSail sail = this.getSail();
        sail.initialize();
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        BigdataSailRepositoryConnection cxn = repo.getConnection();
        cxn.setAutoCommit(false);
        try {
            ValueFactory vf = sail.getValueFactory();
            URI s1 = vf.createURI("s:1");
            URI s2 = vf.createURI("s:2");
            URI s3 = vf.createURI("s:3");
            URI pred1 = vf.createURI("p:1");
            URI pred2 = vf.createURI("p:2");
            cxn.add((Resource)s1, pred1, (Value)vf.createLiteral(3), new Resource[0]);
            cxn.add((Resource)s1, pred2, (Value)vf.createLiteral("a"), new Resource[0]);
            cxn.add((Resource)s2, pred1, (Value)vf.createLiteral(1), new Resource[0]);
            cxn.add((Resource)s2, pred2, (Value)vf.createLiteral("b"), new Resource[0]);
            cxn.add((Resource)s3, pred1, (Value)vf.createLiteral(2), new Resource[0]);
            cxn.add((Resource)s3, pred2, (Value)vf.createLiteral("c"), new Resource[0]);
            TupleQuery tq = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT ?s ?lit WHERE {   ?s <p:1> ?val.   ?s <p:2> ?lit } ORDER BY ?val");
            try (TupleQueryResult result = tq.evaluate();){
                TestOrderBy.assertTrue((boolean)result.hasNext());
                TestOrderBy.assertEquals((Object)s2, (Object)((BindingSet)result.next()).getValue("s"));
                TestOrderBy.assertTrue((boolean)result.hasNext());
                TestOrderBy.assertEquals((Object)s3, (Object)((BindingSet)result.next()).getValue("s"));
                TestOrderBy.assertTrue((boolean)result.hasNext());
                TestOrderBy.assertEquals((Object)s1, (Object)((BindingSet)result.next()).getValue("s"));
                TestOrderBy.assertFalse((boolean)result.hasNext());
            }
        }
        finally {
            cxn.close();
            sail.__tearDownUnitTest();
        }
    }
}

