/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.ServiceProviderHook;
import com.bigdata.rdf.model.BigdataStatementImpl;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.store.BigdataStatementIterator;
import com.bigdata.rdf.store.DataLoader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;

public class TestProvenanceQuery
extends ProxyBigdataSailTestCase {
    private static final transient Logger log = Logger.getLogger(TestProvenanceQuery.class);

    public TestProvenanceQuery() {
    }

    public TestProvenanceQuery(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_query() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            boolean ok = false;
            BigdataSail.BigdataSailConnection conn = sail.getUnisolatedConnection();
            try {
                if (!conn.getTripleStore().getStatementIdentifiers()) {
                    log.warn((Object)"Statement identifiers are not enabled");
                    return;
                }
                DataLoader dataLoader = conn.getTripleStore().getDataLoader();
                dataLoader.loadData("/com/bigdata/rdf/sail/provenance01.ttlx", "", ServiceProviderHook.TURTLE_RDR);
                conn.commit();
                ok = true;
            }
            finally {
                if (!ok) {
                    conn.rollback();
                }
                conn.close();
            }
            if (log.isInfoEnabled()) {
                try (BigdataSail.BigdataSailConnection conn2 = sail.getReadOnlyConnection();){
                    String rdfXml;
                    try (BigdataStatementIterator itr = conn2.getTripleStore().getStatements(null, null, null);){
                        StringWriter w = new StringWriter();
                        RDFWriterFactory writerFactory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)RDFFormat.RDFXML);
                        TestProvenanceQuery.assertNotNull((Object)writerFactory);
                        RDFWriter rdfWriter = writerFactory.getWriter((Writer)w);
                        rdfWriter.startRDF();
                        while (itr.hasNext()) {
                            BigdataStatementImpl stmt = (BigdataStatementImpl)itr.next();
                            if (!stmt.isExplicit()) continue;
                            rdfWriter.handleStatement((Statement)stmt);
                        }
                        rdfWriter.endRDF();
                        rdfXml = ((Object)w).toString();
                    }
                    log.info((Object)rdfXml);
                }
            }
            try (BigdataSail.BigdataSailConnection conn3 = sail.getConnection();){
                URIImpl y = new URIImpl("http://www.foo.org/y");
                URIImpl B = new URIImpl("http://www.foo.org/B");
                URIImpl dcCreator = new URIImpl("http://purl.org/dc/terms/creator");
                LiteralImpl bryan = new LiteralImpl("bryan", XMLSchema.STRING);
                LiteralImpl mike = new LiteralImpl("mike", XMLSchema.STRING);
                String q = "select ?Y where { <<<" + y + "> <" + RDF.TYPE + "> <" + B + ">>> <" + dcCreator + "> ?Y . }";
                TupleQuery tq = new BigdataSailRepository(sail).getReadOnlyConnection().prepareTupleQuery(QueryLanguage.SPARQL, q);
                TupleQueryResult itr = tq.evaluate();
                if (log.isInfoEnabled()) {
                    log.info((Object)"Verifying query.");
                }
                HashSet<LiteralImpl> expected = new HashSet<LiteralImpl>();
                expected.add(bryan);
                expected.add(mike);
                int nresults = expected.size();
                try {
                    int i = 0;
                    while (itr.hasNext()) {
                        BindingSet solution = (BindingSet)itr.next();
                        if (log.isInfoEnabled()) {
                            log.info((Object)("solution[" + i + "] : " + solution));
                        }
                        Value actual = solution.getValue("Y");
                        TestProvenanceQuery.assertTrue((String)("Not expecting Y=" + actual), (boolean)expected.remove(actual));
                        ++i;
                    }
                    TestProvenanceQuery.assertEquals((String)"#results", (int)nresults, (int)i);
                }
                finally {
                    itr.close();
                }
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }
}

