/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.LinkedList;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.BindingImpl;

public class TestPruneBindingSets
extends ProxyBigdataSailTestCase {
    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public TestPruneBindingSets() {
    }

    public TestPruneBindingSets(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPruneBindingSets() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                cxn.setAutoCommit(false);
                URIImpl x = new URIImpl("_:X");
                URIImpl a = new URIImpl("_:A");
                URIImpl b = new URIImpl("_:B");
                URIImpl c = new URIImpl("_:C");
                URIImpl d = new URIImpl("_:D");
                URIImpl e = new URIImpl("_:E");
                cxn.add((Resource)a, (URI)x, (Value)b, new Resource[0]);
                cxn.add((Resource)b, (URI)x, (Value)c, new Resource[0]);
                cxn.add((Resource)c, (URI)x, (Value)d, new Resource[0]);
                cxn.add((Resource)d, (URI)x, (Value)e, new Resource[0]);
                cxn.commit();
                if (log.isInfoEnabled()) {
                    log.info((Object)cxn.getTripleStore().dumpStore());
                }
                String query = "select ?a WHERE {   ?a <" + x + "> ?b ." + "  ?b <" + x + "> ?c ." + "  ?c <" + x + "> ?d ." + "  ?d <" + x + "> <" + e + "> ." + "}";
                TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                TupleQueryResult result = tupleQuery.evaluate();
                LinkedList<BindingSet> solution = new LinkedList<BindingSet>();
                solution.add(this.createBindingSet(new Binding[]{new BindingImpl("a", (Value)a)}));
                this.compare(result, solution);
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }
}

