/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.QuadsTestCase;
import java.util.LinkedList;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.BindingImpl;

public class TestQuadsAPI
extends QuadsTestCase {
    final String FOAF = "http://xmlns.com/foaf/0.1/";
    final URI FOAF_NAME = new URIImpl("http://xmlns.com/foaf/0.1/name");
    final URI FOAF_MBOX = new URIImpl("http://xmlns.com/foaf/0.1/mbox");
    final URI FOAF_NICK = new URIImpl("http://xmlns.com/foaf/0.1/nick");
    final URI FOAF_PPD = new URIImpl("http://xmlns.com/foaf/0.1/PersonalProfileDocument");
    final URI FOAF_KNOWS = new URIImpl("http://xmlns.com/foaf/0.1/knows");
    final String DC = "http://purl.org/dc/elements/1.1/";
    final URI DC_PUBLISHER = new URIImpl("http://purl.org/dc/elements/1.1/publisher");

    public TestQuadsAPI() {
    }

    public TestQuadsAPI(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_2graphs() throws Exception {
        BigdataSail sail = this.getSail();
        sail.initialize();
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        BigdataSailRepositoryConnection cxn = repo.getConnection();
        cxn.setAutoCommit(false);
        try {
            TestQuadsAPI.assertEquals((long)0L, (long)cxn.getTripleStore().getNamedGraphCount());
            TestQuadsAPI.assertFalse((boolean)cxn.getContextIDs().hasNext());
            BNodeImpl a = new BNodeImpl("_:a");
            BNodeImpl b = new BNodeImpl("_:b");
            URIImpl graphA = new URIImpl("http://www.bigdata.com/graphA");
            URIImpl graphB = new URIImpl("http://www.bigdata.com/graphB");
            cxn.add((Resource)a, (URI)new URIImpl("http://xmlns.com/foaf/0.1/name"), (Value)new LiteralImpl("Alice"), new Resource[]{graphA});
            cxn.add((Resource)a, (URI)new URIImpl("http://xmlns.com/foaf/0.1/mbox"), (Value)new URIImpl("mailto:alice@work.example"), new Resource[]{graphA});
            cxn.add((Resource)b, (URI)new URIImpl("http://xmlns.com/foaf/0.1/name"), (Value)new LiteralImpl("Bob"), new Resource[]{graphB});
            cxn.add((Resource)b, (URI)new URIImpl("http://xmlns.com/foaf/0.1/mbox"), (Value)new URIImpl("mailto:bob@work.example"), new Resource[]{graphB});
            cxn.flush();
            TestQuadsAPI.assertEquals((long)2L, (long)cxn.getTripleStore().getNamedGraphCount());
            TestQuadsAPI.assertSameIterationAnyOrder(new Resource[]{graphA, graphB}, cxn.getContextIDs());
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + cxn.getTripleStore().dumpStore()));
            }
        }
        finally {
            cxn.close();
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSCequality() throws Exception {
        BigdataSail sail = this.getSail();
        sail.initialize();
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        BigdataSailRepositoryConnection cxn = repo.getConnection();
        cxn.setAutoCommit(false);
        try {
            TestQuadsAPI.assertEquals((long)0L, (long)cxn.getTripleStore().getNamedGraphCount());
            TestQuadsAPI.assertFalse((boolean)cxn.getContextIDs().hasNext());
            URIImpl graphA = new URIImpl("http://www.bigdata.com/rdf#graphA");
            URIImpl graphB = new URIImpl("http://www.bigdata.com/rdf#graphB");
            URIImpl s = new URIImpl("http://www.bigdata.com/rdf#s");
            URIImpl p1 = new URIImpl("http://www.bigdata.com/rdf#p1");
            URIImpl o1 = new URIImpl("http://www.bigdata.com/rdf#o1");
            URIImpl p2 = new URIImpl("http://www.bigdata.com/rdf#p2");
            URIImpl o2 = new URIImpl("http://www.bigdata.com/rdf#o2");
            cxn.add((Resource)graphA, (URI)p1, (Value)o1, new Resource[]{graphA});
            cxn.add((Resource)s, (URI)p1, (Value)o1, new Resource[]{graphA});
            cxn.add((Resource)graphA, (URI)p2, (Value)o2, new Resource[]{graphA});
            cxn.add((Resource)s, (URI)p2, (Value)o2, new Resource[]{graphB});
            cxn.commit();
            TestQuadsAPI.assertEquals((long)2L, (long)cxn.getTripleStore().getNamedGraphCount());
            TestQuadsAPI.assertSameIterationAnyOrder(new Resource[]{graphA, graphB}, cxn.getContextIDs());
            if (log.isInfoEnabled()) {
                log.info((Object)("\n" + cxn.getTripleStore().dumpStore()));
            }
            String query = "SELECT  * \nWHERE { \n  GRAPH ?g { \n    ?g <" + p1 + "> <" + o1 + "> . \n" + "    ?g <" + p2 + "> <" + o2 + "> . \n" + "  }\n" + "}";
            TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            tupleQuery.setIncludeInferred(true);
            TupleQueryResult result = tupleQuery.evaluate();
            LinkedList<BindingSet> answer = new LinkedList<BindingSet>();
            answer.add(this.createBindingSet(new Binding[]{new BindingImpl("g", (Value)graphA)}));
            this.compare(result, answer);
        }
        finally {
            cxn.close();
            sail.__tearDownUnitTest();
        }
    }
}

