/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.changesets.IChangeRecord;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.sail.RDRHistory;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryResult;

public class TestRDRHistory
extends ProxyBigdataSailTestCase {
    private static final Logger log = Logger.getLogger(TestRDRHistory.class);

    @Override
    public Properties getProperties() {
        return this.getProperties(RDRHistory.class);
    }

    public Properties getProperties(Class<? extends RDRHistory> cls) {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        props.setProperty(AbstractTripleStore.Options.RDR_HISTORY_CLASS, cls.getName());
        return props;
    }

    public TestRDRHistory() {
    }

    public TestRDRHistory(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddAndRemove() throws Exception {
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getProperties());
        try {
            Literal l;
            BigdataStatement tmp;
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            BigdataValueFactory vf = (BigdataValueFactory)sail.getValueFactory();
            BigdataURI s = vf.createURI(":s");
            BigdataURI p = vf.createURI(":p");
            BigdataURI o = vf.createURI(":o");
            BigdataStatement stmt = vf.createStatement((Resource)s, (URI)p, (Value)o);
            cxn.add((Statement)stmt, new Resource[0]);
            cxn.commit();
            if (log.isInfoEnabled()) {
                log.info((Object)cxn.getTripleStore().dumpStore().insert(0, '\n'));
            }
            TestRDRHistory.assertEquals((long)2L, (long)cxn.size(new Resource[0]));
            try (RepositoryResult stmts = cxn.getStatements((Resource)s, (URI)p, (Value)o, true, new Resource[0]);){
                TestRDRHistory.assertTrue((boolean)stmts.hasNext());
                BigdataStatement tmp2 = (BigdataStatement)stmts.next();
                TestRDRHistory.assertEquals((Object)StatementEnum.Explicit, (Object)tmp2.getStatementType());
                TestRDRHistory.assertFalse((boolean)stmts.hasNext());
            }
            BigdataBNode sid = vf.createBNode(stmt);
            try (RepositoryResult stmts = cxn.getStatements((Resource)sid, RDRHistory.Vocab.ADDED, null, true, new Resource[0]);){
                TestRDRHistory.assertTrue((boolean)stmts.hasNext());
                tmp = (BigdataStatement)stmts.next();
                l = (Literal)tmp.getObject();
                TestRDRHistory.assertEquals((Object)XSD.DATETIME, (Object)l.getDatatype());
                TestRDRHistory.assertFalse((boolean)stmts.hasNext());
            }
            cxn.remove((Statement)stmt, new Resource[0]);
            cxn.commit();
            if (log.isInfoEnabled()) {
                log.info((Object)cxn.getTripleStore().dumpStore().insert(0, '\n'));
            }
            TestRDRHistory.assertEquals((long)3L, (long)cxn.size(new Resource[0]));
            stmts = cxn.getStatements((Resource)s, (URI)p, (Value)o, true, new Resource[0]);
            try {
                TestRDRHistory.assertFalse((boolean)stmts.hasNext());
            }
            finally {
                stmts.close();
            }
            sid = vf.createBNode(stmt);
            stmts = cxn.getStatements((Resource)sid, RDRHistory.Vocab.REMOVED, null, true, new Resource[0]);
            try {
                TestRDRHistory.assertTrue((boolean)stmts.hasNext());
                tmp = (BigdataStatement)stmts.next();
                l = (Literal)tmp.getObject();
                TestRDRHistory.assertEquals((Object)XSD.DATETIME, (Object)l.getDatatype());
            }
            finally {
                stmts.close();
            }
            cxn.add((Statement)stmt, new Resource[0]);
            cxn.commit();
            if (log.isInfoEnabled()) {
                log.info((Object)cxn.getTripleStore().dumpStore().insert(0, '\n'));
            }
            TestRDRHistory.assertEquals((long)4L, (long)cxn.size(new Resource[0]));
            stmts = cxn.getStatements((Resource)s, (URI)p, (Value)o, true, new Resource[0]);
            try {
                TestRDRHistory.assertTrue((boolean)stmts.hasNext());
            }
            finally {
                stmts.close();
            }
            sid = vf.createBNode(stmt);
            stmts = cxn.getStatements((Resource)sid, null, null, true, new Resource[0]);
            try {
                int adds = 0;
                int removes = 0;
                while (stmts.hasNext()) {
                    Statement result = (Statement)stmts.next();
                    Literal l2 = (Literal)result.getObject();
                    TestRDRHistory.assertTrue((boolean)l2.getDatatype().equals((Object)XSD.DATETIME));
                    URI action = result.getPredicate();
                    if (action.equals((Object)RDRHistory.Vocab.ADDED)) {
                        ++adds;
                        continue;
                    }
                    if (action.equals((Object)RDRHistory.Vocab.REMOVED)) {
                        ++removes;
                        continue;
                    }
                    TestRDRHistory.fail();
                }
                TestRDRHistory.assertEquals((int)2, (int)adds);
                TestRDRHistory.assertEquals((int)1, (int)removes);
            }
            finally {
                stmts.close();
            }
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCustomHistory() throws Exception {
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getProperties(CustomRDRHistory.class));
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            BigdataValueFactory vf = (BigdataValueFactory)sail.getValueFactory();
            BigdataURI s = vf.createURI(":s");
            BigdataURI p = vf.createURI(":p");
            BigdataURI o = vf.createURI(":o");
            BigdataLiteral l = vf.createLiteral("o");
            BigdataStatement stmt1 = vf.createStatement((Resource)s, (URI)p, (Value)o);
            BigdataStatement stmt2 = vf.createStatement((Resource)s, (URI)p, (Value)l);
            cxn.add((Statement)stmt1, new Resource[0]);
            cxn.add((Statement)stmt2, new Resource[0]);
            cxn.commit();
            if (log.isInfoEnabled()) {
                log.info((Object)cxn.getTripleStore().dumpStore().insert(0, '\n'));
            }
            TestRDRHistory.assertEquals((long)3L, (long)cxn.size(new Resource[0]));
            try (RepositoryResult stmts = cxn.getStatements((Resource)s, (URI)p, (Value)o, true, new Resource[0]);){
                TestRDRHistory.assertTrue((boolean)stmts.hasNext());
            }
            stmts = cxn.getStatements((Resource)s, (URI)p, (Value)l, true, new Resource[0]);
            try {
                TestRDRHistory.assertTrue((boolean)stmts.hasNext());
            }
            finally {
                stmts.close();
            }
            BigdataBNode sid = vf.createBNode(stmt1);
            try (RepositoryResult stmts = cxn.getStatements((Resource)sid, RDRHistory.Vocab.ADDED, null, true, new Resource[0]);){
                TestRDRHistory.assertFalse((boolean)stmts.hasNext());
            }
            sid = vf.createBNode(stmt2);
            stmts = cxn.getStatements((Resource)sid, RDRHistory.Vocab.ADDED, null, true, new Resource[0]);
            try {
                TestRDRHistory.assertTrue((boolean)stmts.hasNext());
                Literal l2 = (Literal)((Statement)stmts.next()).getObject();
                TestRDRHistory.assertTrue((boolean)l2.getDatatype().equals((Object)XSD.DATETIME));
            }
            finally {
                stmts.close();
            }
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSparqlIntegration() throws Exception {
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getProperties());
        try {
            BindingSet bs;
            int i;
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection read = repo.getReadOnlyConnection();){
                read.prepareTupleQuery(QueryLanguage.SPARQL, "select * { ?s ?p ?o }").evaluate();
            }
            cxn = repo.getConnection();
            String sparql = "insert {   ?s <:p> \"foo\" . } where {   values (?s) {     (<:s1>)     (<:s2>)   } }";
            cxn.prepareUpdate(QueryLanguage.SPARQL, "insert {   ?s <:p> \"foo\" . } where {   values (?s) {     (<:s1>)     (<:s2>)   } }").execute();
            cxn.commit();
            sparql = "delete {   ?s <:p> ?o . } insert {   ?s <:p> \"bar\" . } where {   ?s <:p> ?o . }";
            cxn.prepareUpdate(QueryLanguage.SPARQL, "delete {   ?s <:p> ?o . } insert {   ?s <:p> \"bar\" . } where {   ?s <:p> ?o . }").execute();
            cxn.commit();
            if (log.isInfoEnabled()) {
                log.info((Object)cxn.getTripleStore().dumpStore().insert(0, '\n'));
            }
            TestRDRHistory.assertEquals((long)10L, (long)cxn.size(new Resource[0]));
            sparql = "select ?s ?p ?o ?action ?time \nwhere { \n  bind(<< ?s ?p ?o >> as ?sid) . \n  hint:Prior hint:history true . \n  ?sid ?action ?time . \n  values (?s) { \n    (<:s1>) \n  } \n}";
            try (TupleQueryResult result = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "select ?s ?p ?o ?action ?time \nwhere { \n  bind(<< ?s ?p ?o >> as ?sid) . \n  hint:Prior hint:history true . \n  ?sid ?action ?time . \n  values (?s) { \n    (<:s1>) \n  } \n}").evaluate();){
                i = 0;
                while (result.hasNext()) {
                    bs = (BindingSet)result.next();
                    ++i;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)bs);
                }
                TestRDRHistory.assertEquals((int)3, (int)i);
            }
            sparql = "select ?s ?p ?o ?action ?time \nwhere { \n  bind(<< ?s ?p ?o >> as ?sid) . \n  hint:Prior hint:history true . \n  ?sid ?action ?time . \n}";
            result = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "select ?s ?p ?o ?action ?time \nwhere { \n  bind(<< ?s ?p ?o >> as ?sid) . \n  hint:Prior hint:history true . \n  ?sid ?action ?time . \n}").evaluate();
            try {
                i = 0;
                while (result.hasNext()) {
                    bs = (BindingSet)result.next();
                    ++i;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)bs);
                }
                TestRDRHistory.assertEquals((int)6, (int)i);
            }
            finally {
                result.close();
            }
            sparql = "select ?s ?p ?o ?action ?time \nwhere { \n  bind(<< ?s <:p> ?o >> as ?sid) . \n  hint:Prior hint:history true . \n  ?sid <blaze:history:removed> ?time . \n}";
            result = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "select ?s ?p ?o ?action ?time \nwhere { \n  bind(<< ?s <:p> ?o >> as ?sid) . \n  hint:Prior hint:history true . \n  ?sid <blaze:history:removed> ?time . \n}").evaluate();
            try {
                i = 0;
                while (result.hasNext()) {
                    bs = (BindingSet)result.next();
                    ++i;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)bs);
                }
                TestRDRHistory.assertEquals((int)2, (int)i);
            }
            finally {
                result.close();
            }
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFullyRedundantEvents() throws Exception {
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getProperties());
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            BigdataValueFactory vf = (BigdataValueFactory)sail.getValueFactory();
            BigdataURI s = vf.createURI(":s");
            BigdataURI p = vf.createURI(":p");
            BigdataLiteral o = vf.createLiteral("foo");
            BigdataStatement stmt = vf.createStatement((Resource)s, (URI)p, (Value)o);
            BigdataBNode sid = vf.createBNode(stmt);
            cxn.add((Statement)stmt, new Resource[0]);
            cxn.commit();
            TestRDRHistory.assertEquals((long)1L, (long)cxn.getTripleStore().getAccessPath((Resource)sid, null, null).rangeCount(false));
            cxn.remove((Statement)stmt, new Resource[0]);
            cxn.add((Statement)stmt, new Resource[0]);
            cxn.commit();
            TestRDRHistory.assertEquals((long)1L, (long)cxn.getTripleStore().getAccessPath((Resource)sid, null, null).rangeCount(false));
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPartiallyRedundantEvents() throws Exception {
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getProperties());
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            BigdataValueFactory vf = (BigdataValueFactory)sail.getValueFactory();
            BigdataURI s = vf.createURI(":s");
            BigdataURI p = vf.createURI(":p");
            BigdataLiteral o = vf.createLiteral("foo");
            BigdataLiteral bar = vf.createLiteral("bar");
            BigdataStatement stmt = vf.createStatement((Resource)s, (URI)p, (Value)o);
            BigdataStatement stmt2 = vf.createStatement((Resource)s, (URI)p, (Value)bar);
            BigdataBNode sid = vf.createBNode(stmt);
            BigdataBNode sid2 = vf.createBNode(stmt2);
            cxn.add((Statement)stmt, new Resource[0]);
            cxn.commit();
            TestRDRHistory.assertEquals((long)1L, (long)cxn.getTripleStore().getAccessPath((Resource)sid, null, null).rangeCount(false));
            cxn.remove((Statement)stmt, new Resource[0]);
            cxn.add((Statement)stmt, new Resource[0]);
            cxn.add((Statement)stmt2, new Resource[0]);
            cxn.commit();
            TestRDRHistory.assertEquals((long)1L, (long)cxn.getTripleStore().getAccessPath((Resource)sid, null, null).rangeCount(false));
            TestRDRHistory.assertEquals((long)1L, (long)cxn.getTripleStore().getAccessPath((Resource)sid2, null, null).rangeCount(false));
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }

    public static class CustomRDRHistory
    extends RDRHistory {
        public CustomRDRHistory(AbstractTripleStore database) {
            super(database);
        }

        protected boolean accept(IChangeRecord record) {
            return record.getStatement().o().isLiteral();
        }
    }
}

