/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.Properties;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.repository.RepositoryResult;

public class TestReadWriteTransactions
extends ProxyBigdataSailTestCase {
    public TestReadWriteTransactions() {
    }

    public TestReadWriteTransactions(String arg0) {
        super(arg0);
    }

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "true");
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    private URI uri(String s) {
        return new URIImpl("http://www.bigdata.com/rdf#" + s);
    }

    private BNode bnode(String id) {
        return new BNodeImpl(id);
    }

    private Statement stmt(Resource s, URI p, Value o) {
        return new StatementImpl(s, p, o);
    }

    private Statement stmt(Resource s, URI p, Value o, Resource c) {
        return new ContextStatementImpl(s, p, o, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_commit() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            BigdataSailRepositoryConnection isolated = repo.getReadWriteConnection();
            isolated.setAutoCommit(false);
            BigdataSailRepositoryConnection readView = repo.getReadOnlyConnection();
            try {
                URI s = this.uri("a");
                URI p = this.uri("b");
                URI o = this.uri("c");
                isolated.add(this.stmt((Resource)s, p, (Value)o), new Resource[0]);
                boolean stmtInIsolated = isolated.hasStatement((Resource)s, p, (Value)o, true, new Resource[0]);
                if (log.isInfoEnabled()) {
                    log.info((Object)("stmtInIsolated: " + stmtInIsolated));
                }
                boolean stmtInView = readView.hasStatement((Resource)s, p, (Value)o, true, new Resource[0]);
                if (log.isInfoEnabled()) {
                    log.info((Object)("stmtInView: " + stmtInView));
                }
                TestReadWriteTransactions.assertFalse((boolean)stmtInView);
                TestReadWriteTransactions.assertTrue((boolean)stmtInIsolated);
                isolated.commit();
                readView = repo.getReadOnlyConnection();
                TestReadWriteTransactions.assertTrue((boolean)readView.hasStatement((Resource)s, p, (Value)o, true, new Resource[0]));
            }
            finally {
                readView.close();
                isolated.close();
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_abort() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            BigdataSailRepositoryConnection store = repo.getReadWriteConnection();
            store.setAutoCommit(false);
            store.rollback();
            URI s = this.uri("a");
            URI p = this.uri("b");
            URI o = this.uri("c");
            try {
                store.add(this.stmt((Resource)s, p, (Value)o), new Resource[0]);
                TestReadWriteTransactions.assertTrue((boolean)store.hasStatement((Resource)s, p, (Value)o, true, new Resource[0]));
                store.rollback();
                TestReadWriteTransactions.assertFalse((boolean)store.hasStatement((Resource)s, p, (Value)o, true, new Resource[0]));
            }
            finally {
                store.close();
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_multiple_transaction() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            BigdataSailRepositoryConnection tx1 = repo.getReadWriteConnection();
            tx1.setAutoCommit(false);
            BigdataSailRepositoryConnection tx2 = repo.getReadWriteConnection();
            tx2.setAutoCommit(false);
            try {
                URI s = this.uri("a");
                URI p = this.uri("b");
                URI o = this.uri("c");
                BNode sid1 = this.bnode("1");
                BNode sid2 = this.bnode("2");
                URI author = this.uri("author");
                URI mike = this.uri("mike");
                URI bryan = this.uri("bryan");
                tx1.add(this.stmt((Resource)s, p, (Value)o, (Resource)sid1), new Resource[0]);
                tx1.add(this.stmt((Resource)sid1, author, (Value)mike), new Resource[0]);
                tx1.commit();
                TestReadWriteTransactions.assertTrue((boolean)tx1.hasStatement((Resource)s, p, (Value)o, true, new Resource[0]));
                TestReadWriteTransactions.assertFalse((boolean)tx2.hasStatement((Resource)s, p, (Value)o, true, new Resource[0]));
                tx2.add(this.stmt((Resource)s, p, (Value)o, (Resource)sid2), new Resource[0]);
                tx2.add(this.stmt((Resource)sid2, author, (Value)bryan), new Resource[0]);
                tx2.commit();
                TestReadWriteTransactions.assertTrue((boolean)tx2.hasStatement((Resource)s, p, (Value)o, true, new Resource[0]));
                BigdataSailRepositoryConnection view = repo.getReadOnlyConnection();
                TestReadWriteTransactions.assertTrue((boolean)view.hasStatement((Resource)s, p, (Value)o, true, new Resource[0]));
                RepositoryResult it = view.getStatements((Resource)s, p, (Value)o, false, new Resource[0]);
                BigdataStatement stmt = (BigdataStatement)it.next();
                BigdataResource sid = stmt.getContext();
                TestReadWriteTransactions.assertTrue((boolean)view.hasStatement((Resource)sid, author, (Value)mike, true, new Resource[0]));
                TestReadWriteTransactions.assertTrue((boolean)view.hasStatement((Resource)sid, author, (Value)bryan, true, new Resource[0]));
                view.close();
            }
            finally {
                tx1.close();
                tx2.close();
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }
}

