/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.QuadsTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.SailRepositoryConnection;

public class TestRollbacks
extends QuadsTestCase {
    private static final Logger log = Logger.getLogger(TestRollbacks.class);
    private AtomicReference<Throwable> firstCause;
    private ExecutorService executorService = null;
    private static final AtomicInteger runCount = new AtomicInteger();

    public TestRollbacks() {
    }

    public TestRollbacks(String arg0) {
        super(arg0);
    }

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "false");
        return props;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.firstCause = new AtomicReference<Object>(null);
        this.executorService = Executors.newFixedThreadPool(3);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        this.executorService = null;
        this.firstCause = null;
        super.tearDown();
    }

    public void testManyShortRuns() throws Exception {
        for (int i = 0; i < 20; ++i) {
            this.doTest(10);
        }
    }

    public void testModerateDuration() throws Exception {
        this.doTest(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(int maxCounter) throws InterruptedException, Exception {
        Properties properties = new Properties(this.getProperties());
        properties.setProperty(BigdataSail.Options.NAMESPACE, "kb" + runCount.incrementAndGet());
        BigdataSail sail = this.getSail(properties);
        try {
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            repo.initialize();
            this.runConcurrentStuff((SailRepository)repo, maxCounter);
        }
        finally {
            IIndexManager db = sail.getIndexManager();
            try {
                if (sail.isOpen()) {
                    try {
                        sail.shutDown();
                    }
                    catch (Throwable t) {
                        log.error((Object)t, t);
                    }
                }
            }
            finally {
                db.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runConcurrentStuff(SailRepository repo, int maxCounter) throws Exception, InterruptedException {
        try {
            LinkedList<DoStuff> tasks = new LinkedList<DoStuff>();
            tasks.add(new DoStuff(repo, true, maxCounter));
            tasks.add(new DoStuff(repo, false, maxCounter));
            tasks.add(new DoStuff(repo, false, maxCounter));
            List futures = this.executorService.invokeAll(tasks);
            Throwable t = this.firstCause.get();
            if (t != null) {
                throw new RuntimeException(t);
            }
            for (Future f : futures) {
                f.get();
            }
        }
        finally {
            repo.shutDown();
        }
    }

    private class DoStuff
    implements Callable<Void> {
        private SailRepository repo;
        private boolean writer;
        private final int maxCounter;
        int counter = 0;

        private DoStuff(SailRepository repo, boolean writer, int maxCounter) throws OpenRDFException {
            this.repo = repo;
            this.writer = writer;
            this.maxCounter = maxCounter;
        }

        @Override
        public Void call() throws Exception {
            try (SailRepositoryConnection conn = null;){
                int counter2 = 0;
                conn = this.repo.getConnection();
                conn.setAutoCommit(false);
                while (TestRollbacks.this.firstCause.get() == null && this.counter < this.maxCounter) {
                    if (this.writer) {
                        this.writer((RepositoryConnection)conn);
                    } else {
                        this.reader((RepositoryConnection)conn);
                    }
                    if (++counter2 % 4 != 0) continue;
                    conn.close();
                    conn = this.repo.getConnection();
                    conn.setAutoCommit(false);
                }
                Void void_ = null;
                return void_;
            }
        }

        private void reader(RepositoryConnection conn) throws RepositoryException, MalformedQueryException, QueryEvaluationException, InterruptedException {
            this.query(conn);
            this.query(conn);
            ++this.counter;
            if (this.counter % 3 == 0) {
                conn.commit();
            } else {
                conn.rollback();
            }
        }

        private void writer(RepositoryConnection conn) throws RepositoryException, MalformedQueryException, QueryEvaluationException, InterruptedException {
            URI subj = conn.getValueFactory().createURI("u:s" + this.counter++);
            Literal value = conn.getValueFactory().createLiteral("literal" + this.counter);
            this.query(conn);
            conn.add((Resource)subj, conn.getValueFactory().createURI("u:p"), (Value)subj, new Resource[0]);
            conn.add((Resource)subj, conn.getValueFactory().createURI("u:p"), (Value)value, new Resource[0]);
            conn.commit();
            if (log.isInfoEnabled()) {
                log.info((Object)("Added statements: size=" + conn.size(new Resource[0])));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void query(RepositoryConnection conn) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
            long begin = System.currentTimeMillis();
            boolean useJoin = this.counter % 2 == 0;
            String query = !useJoin ? "SELECT ?b { ?a ?b ?c } LIMIT 20" : "SELECT ?b { ?a ?b ?c . ?d ?b ?e} LIMIT 20";
            TupleQuery q = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            q.setBinding("b", (Value)conn.getValueFactory().createURI("u:p"));
            if (useJoin) {
                q.setBinding("d", (Value)conn.getValueFactory().createLiteral("literal1"));
            }
            int n = 0;
            try (TupleQueryResult tqr = q.evaluate();){
                while (tqr.hasNext()) {
                    tqr.next();
                    ++n;
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Query: writer=" + this.writer + ", counter=" + this.counter + ", nresults=" + n + ", elapsed=" + (System.currentTimeMillis() - begin)));
            }
        }
    }
}

