/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.journal.BufferMode;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.lexicon.ITextIndexer;
import com.bigdata.rdf.lexicon.IValueCentricTextIndexer;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.store.BDS;
import com.bigdata.search.Hiterator;
import com.bigdata.search.IHit;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.BindingImpl;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.helpers.StatementCollector;

public class TestSearchQuery
extends ProxyBigdataSailTestCase {
    private static final Logger log = Logger.getLogger(TestSearchQuery.class);

    public TestSearchQuery() {
    }

    public TestSearchQuery(String name) {
        super(name);
    }

    @Override
    public Properties getProperties() {
        Properties properties = super.getProperties();
        properties.setProperty(BigdataSail.Options.SUBJECT_CENTRIC_TEXT_INDEX, "false");
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_restart() throws Exception {
        File file;
        boolean doYouWantMeToBreak = true;
        URIImpl SYSTAP = new URIImpl("http://bigdata.com/elm#a479c37c-407e-4f4a-be30-5a643a54561f");
        URIImpl ORGANIZATION = new URIImpl("http://bigdata.com/domain#Organization");
        URIImpl ENTITY = new URIImpl("http://bigdata.com/system#Entity");
        String query = "construct {?s <" + RDF.TYPE + "> <" + ENTITY + "> ." + " } " + "where { " + " ?s <" + RDF.TYPE + "> <" + ENTITY + "> ." + " ?s ?p ?lit ." + " ?lit <" + BDS.SEARCH + "> \"systap\" ." + " ?lit <" + BDS.MIN_RELEVANCE + "> \"0.0\"^^<http://www.w3.org/2001/XMLSchema#double> ." + " }";
        LinkedHashModel test_restart_1 = new LinkedHashModel();
        test_restart_1.add((Object)new StatementImpl((Resource)ORGANIZATION, RDFS.SUBCLASSOF, (Value)ENTITY));
        LinkedHashModel test_restart_2 = new LinkedHashModel();
        test_restart_2.add((Object)new StatementImpl((Resource)SYSTAP, RDF.TYPE, (Value)ENTITY));
        test_restart_2.add((Object)new StatementImpl((Resource)SYSTAP, RDFS.LABEL, (Value)new LiteralImpl("SYSTAP")));
        try {
            file = File.createTempFile(this.getName(), ".tmp");
            if (log.isInfoEnabled()) {
                log.info((Object)("file=" + file));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        Properties properties = super.getProperties();
        properties.setProperty(BigdataSail.Options.BUFFER_MODE, BufferMode.Disk.toString());
        properties.setProperty(BigdataSail.Options.CREATE_TEMP_FILE, "false");
        properties.setProperty(BigdataSail.Options.FILE, file.toString());
        BigdataSail sail = this.getSail(properties);
        try {
            GraphQuery graphQuery;
            LinkedHashSet results;
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            repo.initialize();
            boolean ok = false;
            BigdataSailRepositoryConnection cxn = repo.getConnection();
            try {
                cxn.setAutoCommit(false);
                log.info((Object)"loading ontology");
                cxn.add((Iterable)test_restart_1, new Resource[0]);
                cxn.commit();
                ok = true;
            }
            finally {
                if (!ok) {
                    cxn.rollback();
                }
                cxn.close();
            }
            ok = false;
            cxn = repo.getConnection();
            try {
                cxn.setAutoCommit(false);
                log.info((Object)"loading entity data");
                cxn.add((Iterable)test_restart_2, new Resource[0]);
                cxn.commit();
                ok = true;
            }
            finally {
                if (!ok) {
                    cxn.rollback();
                }
                cxn.close();
            }
            try (BigdataSailRepositoryConnection cxn2 = repo.getConnection();){
                results = new LinkedHashSet();
                graphQuery = cxn2.prepareGraphQuery(QueryLanguage.SPARQL, query);
                graphQuery.evaluate((RDFHandler)new StatementCollector(results));
                for (Statement stmt : results) {
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)stmt);
                }
                TestSearchQuery.assertTrue((boolean)results.contains(new StatementImpl((Resource)SYSTAP, RDF.TYPE, (Value)ENTITY)));
            }
            repo.shutDown();
            sail = this.reopenSail(sail);
            repo = new BigdataSailRepository(sail);
            repo.initialize();
            cxn2 = repo.getConnection();
            try {
                results = new LinkedHashSet();
                graphQuery = cxn2.prepareGraphQuery(QueryLanguage.SPARQL, query);
                graphQuery.evaluate((RDFHandler)new StatementCollector(results));
                for (Statement stmt : results) {
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)stmt);
                }
                TestSearchQuery.assertTrue((String)"Lost commit?", (boolean)results.contains(new StatementImpl((Resource)SYSTAP, RDF.TYPE, (Value)ENTITY)));
            }
            finally {
                cxn2.close();
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithMetadata() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                BindingSet bs;
                Literal o;
                URI s;
                Literal score;
                IV id;
                IHit hit;
                BindingSet tmp;
                cxn.setAutoCommit(false);
                ValueFactory vf = sail.getValueFactory();
                URI s1 = vf.createURI("http://www.bigdata.com/rdf/search#s1");
                URI s2 = vf.createURI("http://www.bigdata.com/rdf/search#s2");
                URI s3 = vf.createURI("http://www.bigdata.com/rdf/search#s3");
                URI s4 = vf.createURI("http://www.bigdata.com/rdf/search#s4");
                URI s5 = vf.createURI("http://www.bigdata.com/rdf/search#s5");
                URI s6 = vf.createURI("http://www.bigdata.com/rdf/search#s6");
                URI s7 = vf.createURI("http://www.bigdata.com/rdf/search#s7");
                URI s8 = vf.createURI("http://www.bigdata.com/rdf/search#s8");
                Literal l1 = vf.createLiteral("how");
                Literal l2 = vf.createLiteral("now");
                Literal l3 = vf.createLiteral("brown");
                Literal l4 = vf.createLiteral("cow");
                Literal l5 = vf.createLiteral("how now");
                Literal l6 = vf.createLiteral("brown cow");
                Literal l7 = vf.createLiteral("how now brown cow");
                Literal l8 = vf.createLiteral("toilet");
                cxn.add((Resource)s1, RDFS.LABEL, (Value)l1, new Resource[0]);
                cxn.add((Resource)s2, RDFS.LABEL, (Value)l2, new Resource[0]);
                cxn.add((Resource)s3, RDFS.LABEL, (Value)l3, new Resource[0]);
                cxn.add((Resource)s4, RDFS.LABEL, (Value)l4, new Resource[0]);
                cxn.add((Resource)s5, RDFS.LABEL, (Value)l5, new Resource[0]);
                cxn.add((Resource)s6, RDFS.LABEL, (Value)l6, new Resource[0]);
                cxn.add((Resource)s7, RDFS.LABEL, (Value)l7, new Resource[0]);
                cxn.add((Resource)s8, RDFS.LABEL, (Value)l8, new Resource[0]);
                cxn.commit();
                LinkedHashMap<IV, Literal> literals = new LinkedHashMap<IV, Literal>();
                literals.put(((BigdataValue)l1).getIV(), l1);
                literals.put(((BigdataValue)l2).getIV(), l2);
                literals.put(((BigdataValue)l3).getIV(), l3);
                literals.put(((BigdataValue)l4).getIV(), l4);
                literals.put(((BigdataValue)l5).getIV(), l5);
                literals.put(((BigdataValue)l6).getIV(), l6);
                literals.put(((BigdataValue)l7).getIV(), l7);
                literals.put(((BigdataValue)l8).getIV(), l8);
                LinkedHashMap<IV, URI> uris = new LinkedHashMap<IV, URI>();
                uris.put(((BigdataValue)l1).getIV(), s1);
                uris.put(((BigdataValue)l2).getIV(), s2);
                uris.put(((BigdataValue)l3).getIV(), s3);
                uris.put(((BigdataValue)l4).getIV(), s4);
                uris.put(((BigdataValue)l5).getIV(), s5);
                uris.put(((BigdataValue)l6).getIV(), s6);
                uris.put(((BigdataValue)l7).getIV(), s7);
                uris.put(((BigdataValue)l8).getIV(), s8);
                if (log.isInfoEnabled()) {
                    log.info((Object)cxn.getTripleStore().dumpStore());
                }
                String searchQuery = "how now brown cow";
                String query = "select ?s ?o ?score where {     ?s <" + RDFS.LABEL + "> ?o . " + "    ?o <" + BDS.SEARCH + "> \"" + "how now brown cow" + "\" . " + "    ?o <" + BDS.RELEVANCE + "> ?score . " + "} " + "order by desc(?score)";
                TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                tupleQuery.setIncludeInferred(true);
                try (TupleQueryResult result = tupleQuery.evaluate();){
                    int i = 0;
                    while (result.hasNext()) {
                        BindingSet tmp2 = (BindingSet)result.next();
                        if (log.isInfoEnabled()) {
                            log.info((Object)(i + ": " + tmp2.toString()));
                        }
                        ++i;
                    }
                    TestSearchQuery.assertEquals((String)"wrong # of results", (int)7, (int)i);
                }
                result = tupleQuery.evaluate();
                LinkedList<BindingSet> answer = new LinkedList<BindingSet>();
                IValueCentricTextIndexer search = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
                Hiterator hits = search.search(new ITextIndexer.FullTextQuery("how now brown cow", null, false, null, false, false));
                while (hits.hasNext()) {
                    IHit hit2 = hits.next();
                    IV id2 = (IV)hit2.getDocId();
                    Literal score2 = vf.createLiteral(hit2.getCosine());
                    URI s9 = (URI)uris.get(id2);
                    Literal o2 = (Literal)literals.get(id2);
                    BindingSet bs2 = this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)s9), new BindingImpl("o", (Value)o2), new BindingImpl("score", (Value)score2)});
                    if (log.isInfoEnabled()) {
                        log.info((Object)bs2);
                    }
                    answer.add(bs2);
                }
                this.compare(result, answer);
                searchQuery = "how now brown cow";
                int maxHits = 5;
                String query2 = "select ?s ?o ?score where {     ?s <" + RDFS.LABEL + "> ?o . " + "    ?o <" + BDS.SEARCH + "> \"" + "how now brown cow" + "\" . " + "    ?o <" + BDS.RELEVANCE + "> ?score . " + "    ?o <" + BDS.MAX_RANK + "> \"" + 5 + "\" . " + "} " + "order by desc(?score)";
                TupleQuery tupleQuery2 = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query2);
                tupleQuery2.setIncludeInferred(true);
                try (TupleQueryResult result = tupleQuery2.evaluate();){
                    int i = 0;
                    while (result.hasNext()) {
                        BindingSet tmp3 = (BindingSet)result.next();
                        if (log.isInfoEnabled()) {
                            log.info((Object)(i + ": " + tmp3.toString()));
                        }
                        ++i;
                    }
                    TestSearchQuery.assertEquals((String)"wrong # of results", (int)5, (int)i);
                }
                result = tupleQuery2.evaluate();
                LinkedList<BindingSet> answer2 = new LinkedList<BindingSet>();
                IValueCentricTextIndexer search2 = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
                Hiterator hits2 = search2.search(new ITextIndexer.FullTextQuery("how now brown cow", null, false, null, false, false, 0.0, 1.0, 1, 5, Long.MAX_VALUE, TimeUnit.MILLISECONDS));
                while (hits2.hasNext()) {
                    IHit hit3 = hits2.next();
                    IV id3 = (IV)hit3.getDocId();
                    Literal score3 = vf.createLiteral(hit3.getCosine());
                    URI s10 = (URI)uris.get(id3);
                    Literal o3 = (Literal)literals.get(id3);
                    BindingSet bs3 = this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)s10), new BindingImpl("o", (Value)o3), new BindingImpl("score", (Value)score3)});
                    if (log.isInfoEnabled()) {
                        log.info((Object)bs3);
                    }
                    answer2.add(bs3);
                }
                this.compare(result, answer2);
                searchQuery = "how now brown cow";
                double minRelevance = 0.6;
                double maxRelevance = 0.9;
                String query3 = "select ?s ?o ?score where {     ?s <" + RDFS.LABEL + "> ?o . " + "    ?o <" + BDS.SEARCH + "> \"" + "how now brown cow" + "\" . " + "    ?o <" + BDS.RELEVANCE + "> ?score . " + "    ?o <" + BDS.MIN_RELEVANCE + "> \"" + 0.6 + "\" . " + "    ?o <" + BDS.MAX_RELEVANCE + "> \"" + 0.9 + "\" . " + "} " + "order by desc(?score)";
                TupleQuery tupleQuery3 = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query3);
                tupleQuery3.setIncludeInferred(true);
                try (TupleQueryResult result = tupleQuery3.evaluate();){
                    int i = 0;
                    while (result.hasNext()) {
                        tmp = (BindingSet)result.next();
                        if (log.isInfoEnabled()) {
                            log.info((Object)(i + ": " + tmp.toString()));
                        }
                        ++i;
                    }
                    TestSearchQuery.assertEquals((String)"wrong # of results", (int)2, (int)i);
                }
                result = tupleQuery3.evaluate();
                LinkedList<BindingSet> answer3 = new LinkedList<BindingSet>();
                IValueCentricTextIndexer search3 = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
                Hiterator hits3 = search3.search(new ITextIndexer.FullTextQuery("how now brown cow", null, false, null, false, false, 0.6, 0.9, 1, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.MILLISECONDS));
                while (hits3.hasNext()) {
                    hit = hits3.next();
                    id = (IV)hit.getDocId();
                    score = vf.createLiteral(hit.getCosine());
                    s = (URI)uris.get(id);
                    o = (Literal)literals.get(id);
                    bs = this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)s), new BindingImpl("o", (Value)o), new BindingImpl("score", (Value)score)});
                    if (log.isInfoEnabled()) {
                        log.info((Object)bs);
                    }
                    answer3.add(bs);
                }
                this.compare(result, answer3);
                searchQuery = "brown cow";
                minRelevance = 0.0;
                maxRelevance = 1.0;
                query3 = "select ?s ?o ?score where {     ?s <" + RDFS.LABEL + "> ?o . " + "    ?o <" + BDS.SEARCH + "> \"" + "brown cow" + "\" . " + "    ?o <" + BDS.RELEVANCE + "> ?score . " + "    filter regex(?o, \"" + "brown cow" + "\") " + "} " + "order by desc(?score)";
                if (log.isInfoEnabled()) {
                    log.info((Object)("\n" + query3));
                }
                tupleQuery3 = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query3);
                tupleQuery3.setIncludeInferred(true);
                result = tupleQuery3.evaluate();
                try {
                    int i = 0;
                    while (result.hasNext()) {
                        tmp = (BindingSet)result.next();
                        if (log.isInfoEnabled()) {
                            log.info((Object)(i + ": " + tmp.toString()));
                        }
                        ++i;
                    }
                    TestSearchQuery.assertEquals((String)("wrong # of results: " + i), (int)2, (int)i);
                }
                finally {
                    result.close();
                }
                result = tupleQuery3.evaluate();
                answer = new LinkedList<BindingSet>();
                search3 = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
                hits3 = search3.search(new ITextIndexer.FullTextQuery("brown cow", null, false, null, false, false, 0.0, 1.0, 1, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.MILLISECONDS));
                while (hits3.hasNext()) {
                    hit = hits3.next();
                    id = (IV)hit.getDocId();
                    score = vf.createLiteral(hit.getCosine());
                    s = (URI)uris.get(id);
                    o = (Literal)literals.get(id);
                    if (!o.getLabel().contains("brown cow")) continue;
                    bs = this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)s), new BindingImpl("o", (Value)o), new BindingImpl("score", (Value)score)});
                    if (log.isInfoEnabled()) {
                        log.info((Object)bs);
                    }
                    answer.add(bs);
                }
                this.compare(result, answer);
                searchQuery = "bro*";
                minRelevance = 0.0;
                maxRelevance = 1.0;
                query3 = "select ?s ?o ?score where {     ?s <" + RDFS.LABEL + "> ?o . " + "    ?o <" + BDS.SEARCH + "> \"" + "bro*" + "\" . " + "    ?o <" + BDS.RELEVANCE + "> ?score . " + "} " + "order by desc(?score)";
                if (log.isInfoEnabled()) {
                    log.info((Object)("\n" + query3));
                }
                tupleQuery3 = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query3);
                tupleQuery3.setIncludeInferred(true);
                result = tupleQuery3.evaluate();
                try {
                    int i = 0;
                    while (result.hasNext()) {
                        tmp = (BindingSet)result.next();
                        if (log.isInfoEnabled()) {
                            log.info((Object)(i + ": " + tmp.toString()));
                        }
                        ++i;
                    }
                    TestSearchQuery.assertEquals((String)("wrong # of results: " + i), (int)3, (int)i);
                }
                finally {
                    result.close();
                }
                result = tupleQuery3.evaluate();
                answer = new LinkedList<BindingSet>();
                search3 = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
                hits3 = search3.search(new ITextIndexer.FullTextQuery("bro*", null, true, null, false, false, 0.0, 1.0, 1, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.MILLISECONDS));
                while (hits3.hasNext()) {
                    hit = hits3.next();
                    id = (IV)hit.getDocId();
                    score = vf.createLiteral(hit.getCosine());
                    s = (URI)uris.get(id);
                    o = (Literal)literals.get(id);
                    bs = this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)s), new BindingImpl("o", (Value)o), new BindingImpl("score", (Value)score)});
                    if (log.isInfoEnabled()) {
                        log.info((Object)bs);
                    }
                    answer.add(bs);
                }
                this.compare(result, answer);
                searchQuery = "to*";
                minRelevance = 0.0;
                maxRelevance = 1.0;
                query3 = "select ?s ?o ?score where {     ?s <" + RDFS.LABEL + "> ?o . " + "    ?o <" + BDS.SEARCH + "> \"" + "to*" + "\" . " + "    ?o <" + BDS.RELEVANCE + "> ?score . " + "    ?o <" + BDS.MIN_RELEVANCE + "> \"" + 0.0 + "\" . " + "} " + "order by desc(?score)";
                if (log.isInfoEnabled()) {
                    log.info((Object)("\n" + query3));
                }
                tupleQuery3 = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query3);
                tupleQuery3.setIncludeInferred(true);
                result = tupleQuery3.evaluate();
                try {
                    int i = 0;
                    while (result.hasNext()) {
                        tmp = (BindingSet)result.next();
                        if (log.isInfoEnabled()) {
                            log.info((Object)(i + ": " + tmp.toString()));
                        }
                        ++i;
                    }
                    TestSearchQuery.assertEquals((String)("wrong # of results: " + i), (int)1, (int)i);
                }
                finally {
                    result.close();
                }
                result = tupleQuery3.evaluate();
                answer = new LinkedList<BindingSet>();
                search3 = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
                hits3 = search3.search(new ITextIndexer.FullTextQuery("to*", null, true, null, false, false, 0.0, 1.0, 1, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.MILLISECONDS));
                while (hits3.hasNext()) {
                    hit = hits3.next();
                    id = (IV)hit.getDocId();
                    score = vf.createLiteral(hit.getCosine());
                    s = (URI)uris.get(id);
                    o = (Literal)literals.get(id);
                    bs = this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)s), new BindingImpl("o", (Value)o), new BindingImpl("score", (Value)score)});
                    if (log.isInfoEnabled()) {
                        log.info((Object)bs);
                    }
                    answer.add(bs);
                }
                this.compare(result, answer);
                searchQuery = "how now brown cow";
                minRelevance = 0.0;
                maxRelevance = 1.0;
                query3 = "select ?s ?o where {     ?s <" + RDFS.LABEL + "> ?o . " + "    ?o <" + BDS.SEARCH + "> \"" + "how now brown cow" + "\" . " + "    ?o <" + BDS.MATCH_ALL_TERMS + "> \"true\" . " + "}";
                if (log.isInfoEnabled()) {
                    log.info((Object)("\n" + query3));
                }
                tupleQuery3 = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query3);
                tupleQuery3.setIncludeInferred(true);
                result = tupleQuery3.evaluate();
                try {
                    int i = 0;
                    while (result.hasNext()) {
                        tmp = (BindingSet)result.next();
                        if (log.isInfoEnabled()) {
                            log.info((Object)(i + ": " + tmp.toString()));
                        }
                        ++i;
                    }
                }
                finally {
                    result.close();
                }
                result = tupleQuery3.evaluate();
                answer = new LinkedList<BindingSet>();
                search3 = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
                hits3 = search3.search(new ITextIndexer.FullTextQuery("how now brown cow", null, true, null, true, false, 0.0, 1.0, 1, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.MILLISECONDS));
                while (hits3.hasNext()) {
                    hit = hits3.next();
                    id = (IV)hit.getDocId();
                    URI s11 = (URI)uris.get(id);
                    Literal o4 = (Literal)literals.get(id);
                    BindingSet bs4 = this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)s11), new BindingImpl("o", (Value)o4)});
                    if (log.isInfoEnabled()) {
                        log.info((Object)bs4);
                    }
                    answer.add(bs4);
                }
                this.compare(result, answer);
                searchQuery = "how now brown cow";
                int minRank = 2;
                int maxRank = 5;
                String query4 = "select ?s ?o ?score where {     ?s <" + RDFS.LABEL + "> ?o . " + "    ?o <" + BDS.SEARCH + "> \"" + "how now brown cow" + "\" . " + "    ?o <" + BDS.RELEVANCE + "> ?score . " + "    ?o <" + BDS.MIN_RANK + "> \"" + 2 + "\" . " + "    ?o <" + BDS.MAX_RANK + "> \"" + 5 + "\" . " + "}";
                if (log.isInfoEnabled()) {
                    log.info((Object)("\n" + query4));
                }
                TupleQuery tupleQuery4 = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query4);
                tupleQuery4.setIncludeInferred(true);
                try (TupleQueryResult result = tupleQuery4.evaluate();){
                    int i = 0;
                    while (result.hasNext()) {
                        BindingSet tmp4 = (BindingSet)result.next();
                        if (log.isInfoEnabled()) {
                            log.info((Object)(i + ": " + tmp4.toString()));
                        }
                        ++i;
                    }
                    TestSearchQuery.assertTrue((String)("wrong # of results: " + i), (i == 4 ? 1 : 0) != 0);
                }
                result = tupleQuery4.evaluate();
                LinkedList<BindingSet> answer4 = new LinkedList<BindingSet>();
                IValueCentricTextIndexer search4 = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
                Hiterator hits4 = search4.search(new ITextIndexer.FullTextQuery("how now brown cow", null, true, null, false, false, 0.0, 1.0, 2, 5, Long.MAX_VALUE, TimeUnit.MILLISECONDS));
                while (hits4.hasNext()) {
                    IHit hit4 = hits4.next();
                    IV id4 = (IV)hit4.getDocId();
                    Literal score4 = vf.createLiteral(hit4.getCosine());
                    URI s12 = (URI)uris.get(id4);
                    Literal o5 = (Literal)literals.get(id4);
                    BindingSet bs5 = this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)s12), new BindingImpl("o", (Value)o5), new BindingImpl("score", (Value)score4)});
                    if (log.isInfoEnabled()) {
                        log.info((Object)bs5);
                    }
                    answer4.add(bs5);
                }
                this.compare(result, answer4);
                searchQuery = "how now brown cow";
                IValueCentricTextIndexer search5 = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
                int i = search5.count(new ITextIndexer.FullTextQuery("how now brown cow", null, true));
                if (log.isInfoEnabled()) {
                    log.info((Object)(i + " search results."));
                }
                TestSearchQuery.assertTrue((String)("wrong # of results: " + i), (i == 7 ? 1 : 0) != 0);
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValidationWithIncomingBindings() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                cxn.setAutoCommit(false);
                ValueFactory vf = sail.getValueFactory();
                URI s1 = vf.createURI("http://www.bigdata.com/rdf/search#s1");
                URI s2 = vf.createURI("http://www.bigdata.com/rdf/search#s2");
                URI s3 = vf.createURI("http://www.bigdata.com/rdf/search#s3");
                URI s4 = vf.createURI("http://www.bigdata.com/rdf/search#s4");
                URI s5 = vf.createURI("http://www.bigdata.com/rdf/search#s5");
                URI s6 = vf.createURI("http://www.bigdata.com/rdf/search#s6");
                URI s7 = vf.createURI("http://www.bigdata.com/rdf/search#s7");
                URI s8 = vf.createURI("http://www.bigdata.com/rdf/search#s8");
                Literal l1 = vf.createLiteral("how");
                Literal l2 = vf.createLiteral("now");
                Literal l3 = vf.createLiteral("brown");
                Literal l4 = vf.createLiteral("cow");
                Literal l5 = vf.createLiteral("how now");
                Literal l6 = vf.createLiteral("brown cow");
                Literal l7 = vf.createLiteral("how now brown cow");
                Literal l8 = vf.createLiteral("toilet");
                cxn.add((Resource)s1, RDFS.LABEL, (Value)l1, new Resource[0]);
                cxn.add((Resource)s2, RDFS.LABEL, (Value)l2, new Resource[0]);
                cxn.add((Resource)s3, RDFS.LABEL, (Value)l3, new Resource[0]);
                cxn.add((Resource)s4, RDFS.LABEL, (Value)l4, new Resource[0]);
                cxn.add((Resource)s5, RDFS.LABEL, (Value)l5, new Resource[0]);
                cxn.add((Resource)s6, RDFS.LABEL, (Value)l6, new Resource[0]);
                cxn.add((Resource)s7, RDFS.LABEL, (Value)l7, new Resource[0]);
                cxn.add((Resource)s8, RDFS.LABEL, (Value)l8, new Resource[0]);
                cxn.commit();
                LinkedHashMap<IV, Literal> literals = new LinkedHashMap<IV, Literal>();
                literals.put(((BigdataValue)l1).getIV(), l1);
                literals.put(((BigdataValue)l2).getIV(), l2);
                literals.put(((BigdataValue)l3).getIV(), l3);
                literals.put(((BigdataValue)l4).getIV(), l4);
                literals.put(((BigdataValue)l5).getIV(), l5);
                literals.put(((BigdataValue)l6).getIV(), l6);
                literals.put(((BigdataValue)l7).getIV(), l7);
                literals.put(((BigdataValue)l8).getIV(), l8);
                LinkedHashMap<IV, URI> uris = new LinkedHashMap<IV, URI>();
                uris.put(((BigdataValue)l1).getIV(), s1);
                uris.put(((BigdataValue)l2).getIV(), s2);
                uris.put(((BigdataValue)l3).getIV(), s3);
                uris.put(((BigdataValue)l4).getIV(), s4);
                uris.put(((BigdataValue)l5).getIV(), s5);
                uris.put(((BigdataValue)l6).getIV(), s6);
                uris.put(((BigdataValue)l7).getIV(), s7);
                uris.put(((BigdataValue)l8).getIV(), s8);
                if (log.isInfoEnabled()) {
                    log.info((Object)cxn.getTripleStore().dumpStore());
                }
                String searchQuery = "how now brown cow";
                String query = "select ?s ?o ?score where {     ?s <" + RDFS.LABEL + "> ?o . " + "    ?o <" + BDS.SEARCH + "> ?searchQuery . " + "    ?o <" + BDS.RELEVANCE + "> ?score . " + "} " + "order by desc(?score)";
                TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                tupleQuery.setIncludeInferred(true);
                tupleQuery.setBinding("searchQuery", (Value)new LiteralImpl("how now brown cow"));
                try (TupleQueryResult result = tupleQuery.evaluate();){
                    int i = 0;
                    while (result.hasNext()) {
                        BindingSet tmp = (BindingSet)result.next();
                        if (log.isInfoEnabled()) {
                            log.info((Object)(i + ": " + tmp.toString()));
                        }
                        ++i;
                    }
                    TestSearchQuery.assertEquals((String)"wrong # of results", (int)7, (int)i);
                }
                result = tupleQuery.evaluate();
                LinkedList<BindingSet> answer = new LinkedList<BindingSet>();
                IValueCentricTextIndexer search = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
                Hiterator hits = search.search(new ITextIndexer.FullTextQuery("how now brown cow", null, false, null, false, false, 0.0, 1.0, 1, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.MILLISECONDS));
                while (hits.hasNext()) {
                    IHit hit = hits.next();
                    IV id = (IV)hit.getDocId();
                    Literal score = vf.createLiteral(hit.getCosine());
                    URI s = (URI)uris.get(id);
                    Literal o = (Literal)literals.get(id);
                    BindingSet bs = this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)s), new BindingImpl("o", (Value)o), new BindingImpl("score", (Value)score)});
                    if (log.isInfoEnabled()) {
                        log.info((Object)bs);
                    }
                    answer.add(bs);
                }
                this.compare(result, answer);
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExactMatch() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                cxn.setAutoCommit(false);
                ValueFactory vf = sail.getValueFactory();
                URI s1 = vf.createURI("http://www.bigdata.com/rdf/search#s1");
                URI s2 = vf.createURI("http://www.bigdata.com/rdf/search#s2");
                URI s3 = vf.createURI("http://www.bigdata.com/rdf/search#s3");
                URI s4 = vf.createURI("http://www.bigdata.com/rdf/search#s4");
                URI s5 = vf.createURI("http://www.bigdata.com/rdf/search#s5");
                URI s6 = vf.createURI("http://www.bigdata.com/rdf/search#s6");
                URI s7 = vf.createURI("http://www.bigdata.com/rdf/search#s7");
                URI s8 = vf.createURI("http://www.bigdata.com/rdf/search#s8");
                Literal l1 = vf.createLiteral("0");
                Literal l2 = vf.createLiteral("0 0");
                Literal l3 = vf.createLiteral("0 1 0");
                Literal l4 = vf.createLiteral("0,0");
                Literal l5 = vf.createLiteral("1 2 0 0 3");
                Literal l6 = vf.createLiteral("brown cow");
                Literal l7 = vf.createLiteral("how now brown cow");
                Literal l8 = vf.createLiteral("toilet");
                cxn.add((Resource)s1, RDFS.LABEL, (Value)l1, new Resource[0]);
                cxn.add((Resource)s2, RDFS.LABEL, (Value)l2, new Resource[0]);
                cxn.add((Resource)s3, RDFS.LABEL, (Value)l3, new Resource[0]);
                cxn.add((Resource)s4, RDFS.LABEL, (Value)l4, new Resource[0]);
                cxn.add((Resource)s5, RDFS.LABEL, (Value)l5, new Resource[0]);
                cxn.add((Resource)s6, RDFS.LABEL, (Value)l6, new Resource[0]);
                cxn.add((Resource)s7, RDFS.LABEL, (Value)l7, new Resource[0]);
                cxn.add((Resource)s8, RDFS.LABEL, (Value)l8, new Resource[0]);
                cxn.commit();
                LinkedHashMap<IV, Literal> literals = new LinkedHashMap<IV, Literal>();
                literals.put(((BigdataValue)l1).getIV(), l1);
                literals.put(((BigdataValue)l2).getIV(), l2);
                literals.put(((BigdataValue)l3).getIV(), l3);
                literals.put(((BigdataValue)l4).getIV(), l4);
                literals.put(((BigdataValue)l5).getIV(), l5);
                literals.put(((BigdataValue)l6).getIV(), l6);
                literals.put(((BigdataValue)l7).getIV(), l7);
                literals.put(((BigdataValue)l8).getIV(), l8);
                LinkedHashMap<IV, URI> uris = new LinkedHashMap<IV, URI>();
                uris.put(((BigdataValue)l1).getIV(), s1);
                uris.put(((BigdataValue)l2).getIV(), s2);
                uris.put(((BigdataValue)l3).getIV(), s3);
                uris.put(((BigdataValue)l4).getIV(), s4);
                uris.put(((BigdataValue)l5).getIV(), s5);
                uris.put(((BigdataValue)l6).getIV(), s6);
                uris.put(((BigdataValue)l7).getIV(), s7);
                uris.put(((BigdataValue)l8).getIV(), s8);
                if (log.isInfoEnabled()) {
                    log.info((Object)cxn.getTripleStore().dumpStore());
                }
                String searchQuery = "0 0";
                String query = "select ?s ?o ?score where {     ?s <" + RDFS.LABEL + "> ?o . " + "    ?o <" + BDS.SEARCH + "> \"" + "0 0" + "\" . " + "    ?o <" + BDS.MATCH_EXACT + "> \"true\" . " + "    ?o <" + BDS.RELEVANCE + "> ?score . " + "} " + "order by desc(?score)";
                TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                tupleQuery.setIncludeInferred(true);
                try (TupleQueryResult result = tupleQuery.evaluate();){
                    int i = 0;
                    while (result.hasNext()) {
                        BindingSet tmp = (BindingSet)result.next();
                        if (log.isInfoEnabled()) {
                            log.info((Object)(i + ": " + tmp.toString()));
                        }
                        ++i;
                    }
                    TestSearchQuery.assertEquals((String)"wrong # of results", (int)2, (int)i);
                }
                LinkedList<BindingSet> answer = new LinkedList<BindingSet>();
                IValueCentricTextIndexer search = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
                Hiterator hits = search.search(new ITextIndexer.FullTextQuery("0 0", null, false, null, false, true, 0.0, 1.0, 1, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.MILLISECONDS));
                while (hits.hasNext()) {
                    IHit hit = hits.next();
                    IV id = (IV)hit.getDocId();
                    Literal score = vf.createLiteral(hit.getCosine());
                    URI s = (URI)uris.get(id);
                    Literal o = (Literal)literals.get(id);
                    BindingSet bs = this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)s), new BindingImpl("o", (Value)o), new BindingImpl("score", (Value)score)});
                    if (log.isInfoEnabled()) {
                        log.info((Object)bs);
                    }
                    answer.add(bs);
                }
                result = tupleQuery.evaluate();
                this.compare(result, answer);
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }
}

