/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.BindingImpl;
import org.openrdf.repository.sail.SailTupleQuery;

public class TestSesameFilters
extends ProxyBigdataSailTestCase {
    protected static final Logger log = Logger.getLogger(TestSesameFilters.class);
    protected static final boolean INFO = log.isInfoEnabled();

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public TestSesameFilters() {
    }

    public TestSesameFilters(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegex() throws Exception {
        BigdataSail sail = this.getSail();
        sail.initialize();
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        BigdataSailRepositoryConnection cxn = repo.getConnection();
        cxn.setAutoCommit(false);
        try {
            ValueFactory vf = sail.getValueFactory();
            URI mike = vf.createURI("http://www.bigdata.com/rdf#mike");
            URI bryan = vf.createURI("http://www.bigdata.com/rdf#bryan");
            URI person = vf.createURI("http://www.bigdata.com/rdf#Person");
            Literal l1 = vf.createLiteral("mike personick");
            Literal l2 = vf.createLiteral("bryan thompson");
            cxn.add((Resource)mike, RDF.TYPE, (Value)person, new Resource[0]);
            cxn.add((Resource)mike, RDFS.LABEL, (Value)l1, new Resource[0]);
            cxn.add((Resource)bryan, RDF.TYPE, (Value)person, new Resource[0]);
            cxn.add((Resource)bryan, RDFS.LABEL, (Value)l2, new Resource[0]);
            cxn.commit();
            String query = "prefix bd: <http://www.bigdata.com/rdf#> prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> select * where {   ?s rdf:type bd:Person .   ?s rdfs:label ?label .   FILTER regex(?label, \"mike\") . }";
            SailTupleQuery tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            tupleQuery.setIncludeInferred(false);
            LinkedList<BindingSet> answer = new LinkedList<BindingSet>();
            answer.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)mike), new BindingImpl("label", (Value)l1)}));
            TupleQueryResult result = tupleQuery.evaluate();
            this.compare(result, answer);
        }
        finally {
            cxn.close();
            sail.shutDown();
        }
    }
}

