/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class TestSesameMultiGraphs {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        MemoryStore sail = new MemoryStore();
        SailRepository repo = new SailRepository((Sail)sail);
        repo.initialize();
        SailRepositoryConnection cxn = repo.getConnection();
        cxn.setAutoCommit(false);
        try {
            ValueFactory vf = sail.getValueFactory();
            String ns = "http://namespace/";
            URI a = vf.createURI("http://namespace/a");
            URI b = vf.createURI("http://namespace/b");
            URI c = vf.createURI("http://namespace/c");
            URI g1 = vf.createURI("http://namespace/graph1");
            URI g2 = vf.createURI("http://namespace/graph2");
            cxn.setNamespace("ns", "http://namespace/");
            cxn.add((Resource)a, b, (Value)c, new Resource[]{g1, g2});
            cxn.commit();
            String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX ns: <http://namespace/> select ?p ?o WHERE {   ns:a ?p ?o . }";
            TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            TupleQueryResult result = tupleQuery.evaluate();
            System.err.println("no dataset specified, RDF-MERGE, should produce one solution:");
            while (result.hasNext()) {
                System.err.println(result.next());
            }
            query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX ns: <http://namespace/> select ?p ?o from <" + g1 + ">" + "from <" + g2 + ">" + "WHERE { " + "  ns:a ?p ?o . " + "}";
            tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            result = tupleQuery.evaluate();
            System.err.println("default graph query, RDF-MERGE, should produce one solution:");
            while (result.hasNext()) {
                System.err.println(result.next());
            }
            query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX ns: <http://namespace/> select ?p ?o from named <" + g1 + ">" + "from named <" + g2 + ">" + "WHERE { " + "  graph ?g { ns:a ?p ?o . } " + "}";
            tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            result = tupleQuery.evaluate();
            System.err.println("named graph query, no RDF-MERGE, should produce two solutions:");
            while (result.hasNext()) {
                System.err.println(result.next());
            }
        }
        finally {
            cxn.close();
            sail.shutDown();
        }
    }
}

