/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.BindingImpl;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;

public class TestSetBinding
extends ProxyBigdataSailTestCase {
    private static final Logger log = Logger.getLogger(TestSetBinding.class);

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public TestSetBinding() {
    }

    public TestSetBinding(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetBinding() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                cxn.setAutoCommit(false);
                BigdataValueFactory vf = cxn.getValueFactory();
                String data = "@prefix ns:<http://localhost/pets#>. @prefix rdfs:<http://www.w3.org/2000/01/rdf-schema#>.     ns:snowball rdfs:label \"Snowball\";                 ns:weight \"10\".     ns:buffy rdfs:label \"Buffy\";                 ns:weight \"8\".";
                if (log.isInfoEnabled()) {
                    log.info((Object)"Loading data");
                }
                cxn.add((Reader)new StringReader("@prefix ns:<http://localhost/pets#>. @prefix rdfs:<http://www.w3.org/2000/01/rdf-schema#>.     ns:snowball rdfs:label \"Snowball\";                 ns:weight \"10\".     ns:buffy rdfs:label \"Buffy\";                 ns:weight \"8\"."), "", RDFFormat.TURTLE, new Resource[0]);
                cxn.commit();
                if (log.isInfoEnabled()) {
                    RepositoryResult stmts = cxn.getStatements(null, null, null, false, new Resource[0]);
                    while (stmts.hasNext()) {
                        Statement tmp = (Statement)stmts.next();
                        log.info((Object)tmp);
                    }
                }
                BigdataLiteral buffy = vf.createLiteral("Buffy");
                BigdataLiteral snowball = vf.createLiteral("Snowball");
                BigdataLiteral w1 = vf.createLiteral("8");
                BigdataLiteral w2 = vf.createLiteral("10");
                cxn.getTripleStore().addTerms(new BigdataValue[]{buffy, snowball, w1, w2});
                TestSetBinding.assertNotNull((Object)buffy.getIV());
                TestSetBinding.assertNotNull((Object)snowball.getIV());
                TestSetBinding.assertNotNull((Object)w1.getIV());
                TestSetBinding.assertNotNull((Object)w2.getIV());
                String query = "PREFIX ns:<http://localhost/pets#> \nPREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>\nSELECT ?name ?weight WHERE {\n?uri rdfs:label ?name.\n?uri ns:weight ?weight.\n}";
                if (log.isInfoEnabled()) {
                    log.info((Object)"Executing query: PREFIX ns:<http://localhost/pets#> \nPREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>\nSELECT ?name ?weight WHERE {\n?uri rdfs:label ?name.\n?uri ns:weight ?weight.\n}");
                }
                TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "PREFIX ns:<http://localhost/pets#> \nPREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>\nSELECT ?name ?weight WHERE {\n?uri rdfs:label ?name.\n?uri ns:weight ?weight.\n}");
                LinkedList<Object> answer = new LinkedList<BindingSet>();
                answer.add(this.createBindingSet(new Binding[]{new BindingImpl("name", (Value)buffy), new BindingImpl("weight", (Value)w1)}));
                answer.add(this.createBindingSet(new Binding[]{new BindingImpl("name", (Value)snowball), new BindingImpl("weight", (Value)w2)}));
                TupleQueryResult result = tupleQuery.evaluate();
                this.compare(result, answer);
                tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "PREFIX ns:<http://localhost/pets#> \nPREFIX rdfs:<http://www.w3.org/2000/01/rdf-schema#>\nSELECT ?name ?weight WHERE {\n?uri rdfs:label ?name.\n?uri ns:weight ?weight.\n}");
                answer = new LinkedList();
                answer.add(this.createBindingSet(new Binding[]{new BindingImpl("name", (Value)snowball), new BindingImpl("weight", (Value)w2)}));
                tupleQuery.setBinding("name", (Value)snowball);
                result = tupleQuery.evaluate();
                this.compare(result, answer);
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }
}

