/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.ServiceProviderHook;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.BindingImpl;

public class TestSids
extends ProxyBigdataSailTestCase {
    private static final transient Logger log = Logger.getLogger(TestSids.class);

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public TestSids() {
    }

    public TestSids(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSids() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                cxn.setAutoCommit(false);
                cxn.add(((Object)((Object)this)).getClass().getResourceAsStream("sids.ttl"), "", ServiceProviderHook.TURTLE_RDR, new Resource[0]);
                cxn.flush();
                if (log.isInfoEnabled()) {
                    log.info((Object)cxn.getTripleStore().dumpStore());
                }
                Value s = null;
                String query = "PREFIX myns: <http://mynamespace.com#> SELECT distinct ?s ?p ?o  {  <<" + (s == null ? "?s" : "<" + s + ">") + " ?p ?o>> myns:creator <http://1.com> . " + " }";
                TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                TupleQueryResult result = tupleQuery.evaluate();
                if (!result.hasNext()) {
                    log.info((Object)"no bindings");
                } else {
                    while (result.hasNext()) {
                        BindingSet bs = (BindingSet)result.next();
                        log.info((Object)((s == null ? bs.getBinding("s").getValue() : s) + " " + bs.getBinding("p").getValue() + " " + bs.getBinding("o").getValue() + " ."));
                    }
                }
                result = tupleQuery.evaluate();
                LinkedList<BindingSet> solution = new LinkedList<BindingSet>();
                solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)new URIImpl("http://localhost/host1")), new BindingImpl("p", (Value)new URIImpl("http://mynamespace.com#connectedTo")), new BindingImpl("o", (Value)new URIImpl("http://localhost/switch1"))}));
                solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)new URIImpl("http://localhost/host1")), new BindingImpl("p", (Value)RDF.TYPE), new BindingImpl("o", (Value)new URIImpl("http://domainnamespace.com/host#Host"))}));
                solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)new URIImpl("http://localhost/switch1")), new BindingImpl("p", (Value)RDF.TYPE), new BindingImpl("o", (Value)new URIImpl("http://domainnamespace.com/san#Switch"))}));
                this.compare(result, solution);
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSids2() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                cxn.setAutoCommit(false);
                BigdataValueFactory vf = (BigdataValueFactory)sail.getValueFactory();
                BigdataURI host1 = vf.createURI("http://localhost/host1");
                BigdataURI host = vf.createURI("http://domainnamespace.com/host#Host");
                BigdataURI swtch1 = vf.createURI("http://localhost/switch1");
                BigdataURI swtch2 = vf.createURI("http://localhost/switch2");
                BigdataURI swtch = vf.createURI("http://domainnamespace.com/san#Switch");
                BigdataURI connectedTo = vf.createURI("http://mynamespace.com#connectedTo");
                BigdataURI creator = vf.createURI("http://mynamespace.com#creator");
                BigdataURI src1 = vf.createURI("http://1.com");
                BigdataURI src2 = vf.createURI("http://2.com");
                BigdataStatement s1 = vf.createStatement((Resource)host1, RDF.TYPE, (Value)host, (Resource)vf.createBNode());
                BigdataStatement s2 = vf.createStatement((Resource)host1, (URI)connectedTo, (Value)swtch1, (Resource)vf.createBNode());
                BigdataStatement s3 = vf.createStatement((Resource)host1, (URI)connectedTo, (Value)swtch2, (Resource)vf.createBNode());
                BigdataStatement s4 = vf.createStatement((Resource)swtch1, RDF.TYPE, (Value)swtch, (Resource)vf.createBNode());
                BigdataStatement s5 = vf.createStatement((Resource)swtch2, RDF.TYPE, (Value)swtch, (Resource)vf.createBNode());
                BigdataBNode sid1 = vf.createBNode(s1);
                BigdataBNode sid2 = vf.createBNode(s2);
                BigdataBNode sid3 = vf.createBNode(s3);
                BigdataBNode sid4 = vf.createBNode(s4);
                BigdataBNode sid5 = vf.createBNode(s5);
                cxn.add((Statement)s1, new Resource[0]);
                cxn.add((Resource)sid1, (URI)creator, (Value)src1, new Resource[0]);
                cxn.add((Resource)sid1, (URI)creator, (Value)src2, new Resource[0]);
                cxn.add((Statement)s2, new Resource[0]);
                cxn.add((Resource)sid2, (URI)creator, (Value)src1, new Resource[0]);
                cxn.add((Statement)s3, new Resource[0]);
                cxn.add((Resource)sid3, (URI)creator, (Value)src2, new Resource[0]);
                cxn.add((Statement)s4, new Resource[0]);
                cxn.add((Resource)sid4, (URI)creator, (Value)src1, new Resource[0]);
                cxn.add((Statement)s5, new Resource[0]);
                cxn.add((Resource)sid5, (URI)creator, (Value)src2, new Resource[0]);
                cxn.flush();
                if (log.isInfoEnabled()) {
                    log.info((Object)cxn.getTripleStore().dumpStore());
                }
                Value s = null;
                String query = "PREFIX myns: <http://mynamespace.com#> SELECT distinct ?s ?p ?o  {  <<" + (s == null ? "?s" : "<" + s + ">") + " ?p ?o>> myns:creator <http://1.com> . " + " }";
                TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                TupleQueryResult result = tupleQuery.evaluate();
                if (!result.hasNext()) {
                    log.info((Object)"no bindings");
                } else {
                    while (result.hasNext()) {
                        BindingSet bs = (BindingSet)result.next();
                        log.info((Object)((s == null ? bs.getBinding("s").getValue() : s) + " " + bs.getBinding("p").getValue() + " " + bs.getBinding("o").getValue() + " ."));
                    }
                }
                result = tupleQuery.evaluate();
                LinkedList<BindingSet> solution = new LinkedList<BindingSet>();
                solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)new URIImpl("http://localhost/host1")), new BindingImpl("p", (Value)new URIImpl("http://mynamespace.com#connectedTo")), new BindingImpl("o", (Value)new URIImpl("http://localhost/switch1"))}));
                solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)new URIImpl("http://localhost/host1")), new BindingImpl("p", (Value)RDF.TYPE), new BindingImpl("o", (Value)new URIImpl("http://domainnamespace.com/host#Host"))}));
                solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)new URIImpl("http://localhost/switch1")), new BindingImpl("p", (Value)RDF.TYPE), new BindingImpl("o", (Value)new URIImpl("http://domainnamespace.com/san#Switch"))}));
                this.compare(result, solution);
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }
}

