/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import info.aduna.iteration.CloseableIteration;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.BindingImpl;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.query.parser.ParsedTupleQuery;
import org.openrdf.query.parser.QueryParserUtil;
import org.openrdf.sail.SailConnection;

public class TestSingleTailRule
extends ProxyBigdataSailTestCase {
    protected static final Logger log = Logger.getLogger(TestSingleTailRule.class);

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "true");
        return props;
    }

    public TestSingleTailRule() {
    }

    public TestSingleTailRule(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSingleTail() throws Exception {
        BigdataSail sail = this.getSail();
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        repo.initialize();
        BigdataSailRepositoryConnection cxn = repo.getConnection();
        cxn.setAutoCommit(false);
        try {
            ValueFactory vf = sail.getValueFactory();
            String ns = "http://www.bigdata.com/rdf#";
            URI mike = vf.createURI("http://www.bigdata.com/rdf#Mike");
            URI likes = vf.createURI("http://www.bigdata.com/rdf#likes");
            URI rdf = vf.createURI("http://www.bigdata.com/rdf#RDF");
            cxn.setNamespace("ns", "http://www.bigdata.com/rdf#");
            this.testValueRoundTrip((SailConnection)cxn.getSailConnection(), (Resource)mike, likes, (Value)rdf);
            if (log.isInfoEnabled()) {
                log.info((Object)cxn.getTripleStore().dumpStore());
            }
        }
        finally {
            cxn.close();
            if (sail instanceof BigdataSail) {
                sail.__tearDownUnitTest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSingleTailSearch() throws Exception {
        BigdataSail sail = this.getSail();
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        repo.initialize();
        BigdataSailRepositoryConnection cxn = repo.getConnection();
        cxn.setAutoCommit(false);
        try {
            ValueFactory vf = sail.getValueFactory();
            String ns = "http://www.bigdata.com/rdf#";
            URI mike = vf.createURI("http://www.bigdata.com/rdf#Mike");
            Literal l1 = vf.createLiteral("Mike");
            cxn.setNamespace("ns", "http://www.bigdata.com/rdf#");
            cxn.add((Resource)mike, RDFS.LABEL, (Value)l1, new Resource[0]);
            cxn.commit();
            if (log.isInfoEnabled()) {
                log.info((Object)cxn.getTripleStore().dumpStore());
            }
            String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX ns: <http://www.bigdata.com/rdf#> select ?s ?p ?o WHERE {   ?s ?p ?o .   filter(?p = <" + RDFS.LABEL + ">) " + "}";
            TupleQuery tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            TupleQueryResult result = tupleQuery.evaluate();
            LinkedList<Object> solution = new LinkedList<BindingSet>();
            solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)mike), new BindingImpl("p", (Value)RDFS.LABEL), new BindingImpl("o", (Value)l1)}));
            this.compare(result, solution);
            query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX ns: <http://www.bigdata.com/rdf#> select ?s WHERE {   ?s ns:search \"Mike\" . }";
            tupleQuery = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX ns: <http://www.bigdata.com/rdf#> select ?s WHERE {   ?s ns:search \"Mike\" . }");
            result = tupleQuery.evaluate();
            solution = new LinkedList();
            solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)l1)}));
            this.compare(result, solution);
        }
        finally {
            cxn.close();
            if (sail instanceof BigdataSail) {
                sail.__tearDownUnitTest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testValueRoundTrip(SailConnection con, Resource subj, URI pred, Value obj) throws Exception {
        con.addStatement(subj, pred, obj, new Resource[0]);
        con.commit();
        try (CloseableIteration stIter = con.getStatements(null, null, null, false, new Resource[0]);){
            TestSingleTailRule.assertTrue((boolean)stIter.hasNext());
            Statement st = (Statement)stIter.next();
            TestSingleTailRule.assertEquals((Object)subj, (Object)st.getSubject());
            TestSingleTailRule.assertEquals((Object)pred, (Object)st.getPredicate());
            TestSingleTailRule.assertEquals((Object)obj, (Object)st.getObject());
            TestSingleTailRule.assertTrue((!stIter.hasNext() ? 1 : 0) != 0);
        }
        ParsedTupleQuery tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SPARQL, (String)("SELECT ?S ?P ?O WHERE {   ?S ?P ?O .   FILTER( ?P = <" + pred.stringValue() + "> ) " + "}"), null);
        try (CloseableIteration iter = con.evaluate(tupleQuery.getTupleExpr(), null, EmptyBindingSet.getInstance(), false);){
            TestSingleTailRule.assertTrue((boolean)iter.hasNext());
            BindingSet bindings = (BindingSet)iter.next();
            TestSingleTailRule.assertEquals((Object)subj, (Object)bindings.getValue("S"));
            TestSingleTailRule.assertEquals((Object)pred, (Object)bindings.getValue("P"));
            TestSingleTailRule.assertEquals((Object)obj, (Object)bindings.getValue("O"));
            TestSingleTailRule.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptionalFilter() throws Exception {
        BigdataSail sail = this.getSail();
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        repo.initialize();
        BigdataSailRepositoryConnection cxn = repo.getConnection();
        cxn.setAutoCommit(false);
        try {
            ValueFactory vf = sail.getValueFactory();
            URI s = vf.createURI("urn:test:s");
            URI p1 = vf.createURI("urn:test:p1");
            URI p2 = vf.createURI("urn:test:p2");
            Literal v1 = vf.createLiteral(1);
            Literal v2 = vf.createLiteral(2);
            Literal v3 = vf.createLiteral(3);
            cxn.add((Resource)s, p1, (Value)v1, new Resource[0]);
            cxn.add((Resource)s, p2, (Value)v2, new Resource[0]);
            cxn.add((Resource)s, p1, (Value)v3, new Resource[0]);
            cxn.commit();
            String qry = "PREFIX :<urn:test:> SELECT ?s ?v1 ?v2 WHERE {   ?s :p1 ?v1 .   OPTIONAL {?s :p2 ?v2 FILTER(?v1 < 3) } }";
            TupleQuery query = cxn.prepareTupleQuery(QueryLanguage.SPARQL, qry);
            TupleQueryResult result = query.evaluate();
            LinkedList<BindingSet> solution = new LinkedList<BindingSet>();
            solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)s), new BindingImpl("v1", (Value)v1), new BindingImpl("v2", (Value)v2)}));
            solution.add(this.createBindingSet(new Binding[]{new BindingImpl("s", (Value)s), new BindingImpl("v1", (Value)v3)}));
            this.compare(result, solution);
        }
        finally {
            cxn.close();
            if (sail instanceof BigdataSail) {
                sail.__tearDownUnitTest();
            }
        }
    }
}

