/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.sail.RDRHistory;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.Update;
import org.openrdf.repository.RepositoryResult;

public class TestSparqlStar
extends ProxyBigdataSailTestCase {
    @Override
    public Properties getProperties() {
        return this.getProperties(RDRHistory.class);
    }

    public Properties getProperties(Class<? extends RDRHistory> cls) {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public TestSparqlStar() {
    }

    public TestSparqlStar(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubject() throws Exception {
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getProperties());
        try {
            BindingSet bs;
            int cnt;
            BigdataLiteral o2;
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            TestSparqlStar.assertEquals((long)0L, (long)cxn.getTripleStore().getStatementCount(true));
            BigdataValueFactory vf = (BigdataValueFactory)sail.getValueFactory();
            String updateStr = "insert data {   <x:s> <x:p> \"d\" .   << <x:s> <x:p> \"d\" >> <x:order> \"5\"^^xsd:int . }";
            Update update = cxn.prepareUpdate(QueryLanguage.SPARQL, "insert data {   <x:s> <x:p> \"d\" .   << <x:s> <x:p> \"d\" >> <x:order> \"5\"^^xsd:int . }");
            update.execute();
            TestSparqlStar.assertEquals((long)2L, (long)cxn.getTripleStore().getStatementCount(true));
            BigdataURI s = vf.createURI("x:s");
            BigdataURI p = vf.createURI("x:p");
            BigdataLiteral o = vf.createLiteral("d");
            BigdataURI p1 = vf.createURI("x:order");
            BigdataLiteral o1 = vf.createLiteral(5);
            try (RepositoryResult result = cxn.getStatements((Resource)s, (URI)p, (Value)o, true, new Resource[0]);){
                int cnt2 = 0;
                while (result.hasNext()) {
                    BigdataStatement resultStmt = (BigdataStatement)result.next();
                    BigdataBNode bNode = vf.createBNode(resultStmt);
                    TestSparqlStar.assertTrue((boolean)cxn.hasStatement((Resource)bNode, (URI)p1, (Value)o1, true, new Resource[0]));
                    ++cnt2;
                }
                TestSparqlStar.assertEquals((int)1, (int)cnt2);
            }
            String selectStr = "ASK {   << <x:s> <x:p> \"d\" >> <x:order> \"5\"^^xsd:int . }";
            BooleanQuery tq = cxn.prepareBooleanQuery(QueryLanguage.SPARQL, "ASK {   << <x:s> <x:p> \"d\" >> <x:order> \"5\"^^xsd:int . }");
            TestSparqlStar.assertTrue((boolean)tq.evaluate());
            selectStr = "select ?o {   << <x:s> <x:p> \"d\" >> <x:order> ?o . }";
            tq = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "select ?o {   << <x:s> <x:p> \"d\" >> <x:order> ?o . }");
            try (TupleQueryResult tqr = tq.evaluate();){
                o2 = vf.createLiteral(5);
                cnt = 0;
                while (tqr.hasNext()) {
                    bs = (BindingSet)tqr.next();
                    TestSparqlStar.assertEquals((Object)o2, (Object)bs.getBinding("o").getValue());
                    ++cnt;
                }
                TestSparqlStar.assertEquals((int)1, (int)cnt);
            }
            selectStr = "select ?o {   ?s <x:order> ?o .   bind ( << <x:s> <x:p> \"d\" >> as ?s ) }";
            tq = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "select ?o {   ?s <x:order> ?o .   bind ( << <x:s> <x:p> \"d\" >> as ?s ) }");
            tqr = tq.evaluate();
            try {
                o2 = vf.createLiteral(5);
                cnt = 0;
                while (tqr.hasNext()) {
                    bs = (BindingSet)tqr.next();
                    TestSparqlStar.assertEquals((Object)o2, (Object)bs.getBinding("o").getValue());
                    ++cnt;
                }
                TestSparqlStar.assertEquals((int)1, (int)cnt);
            }
            finally {
                tqr.close();
            }
            selectStr = "construct {   << <x:s> <x:p> \"d\" >> <x:order> ?o . } where {   << <x:s> <x:p> \"d\" >> <x:order> ?o . }";
            GraphQuery tg = cxn.prepareGraphQuery(QueryLanguage.SPARQL, "construct {   << <x:s> <x:p> \"d\" >> <x:order> ?o . } where {   << <x:s> <x:p> \"d\" >> <x:order> ?o . }");
            o2 = vf.createLiteral(5);
            try (GraphQueryResult tgr = tg.evaluate();){
                cnt = 0;
                while (tgr.hasNext()) {
                    Statement st = (Statement)tgr.next();
                    TestSparqlStar.assertEquals((Object)o2, (Object)st.getObject());
                    TestSparqlStar.assertTrue((boolean)((BigdataBNode)st.getSubject()).isStatementIdentifier());
                    ++cnt;
                }
                TestSparqlStar.assertEquals((int)1, (int)cnt);
            }
            String deleteStr = "delete data {   <x:s> <x:p> \"d\" .   << <x:s> <x:p> \"d\" >> <x:order> \"5\"^^xsd:int . }";
            Update delete = cxn.prepareUpdate(QueryLanguage.SPARQL, "delete data {   <x:s> <x:p> \"d\" .   << <x:s> <x:p> \"d\" >> <x:order> \"5\"^^xsd:int . }");
            delete.execute();
            TestSparqlStar.assertEquals((long)0L, (long)cxn.getTripleStore().getStatementCount(true));
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testObject() throws Exception {
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getProperties());
        try {
            BindingSet bs;
            int cnt;
            BigdataURI s2;
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            TestSparqlStar.assertEquals((long)0L, (long)cxn.getTripleStore().getStatementCount(true));
            BigdataValueFactory vf = (BigdataValueFactory)sail.getValueFactory();
            String updateStr = "insert data {   <x:s> <x:p> \"d\" .   <x:r> <x:refers> << <x:s> <x:p> \"d\" >> . }";
            Update update = cxn.prepareUpdate(QueryLanguage.SPARQL, "insert data {   <x:s> <x:p> \"d\" .   <x:r> <x:refers> << <x:s> <x:p> \"d\" >> . }");
            update.execute();
            TestSparqlStar.assertEquals((long)2L, (long)cxn.getTripleStore().getStatementCount(true));
            BigdataURI s = vf.createURI("x:s");
            BigdataURI p = vf.createURI("x:p");
            BigdataLiteral o = vf.createLiteral("d");
            BigdataURI s1 = vf.createURI("x:r");
            BigdataURI p1 = vf.createURI("x:refers");
            try (RepositoryResult result = cxn.getStatements((Resource)s, (URI)p, (Value)o, true, new Resource[0]);){
                int cnt2 = 0;
                while (result.hasNext()) {
                    BigdataStatement resultStmt = (BigdataStatement)result.next();
                    BigdataBNode bNode = vf.createBNode(resultStmt);
                    TestSparqlStar.assertTrue((boolean)cxn.hasStatement((Resource)s1, (URI)p1, (Value)bNode, true, new Resource[0]));
                    ++cnt2;
                }
                TestSparqlStar.assertEquals((int)1, (int)cnt2);
            }
            String selectStr = "ASK {   <x:r> <x:refers> << <x:s> <x:p> \"d\" >> . }";
            BooleanQuery tq = cxn.prepareBooleanQuery(QueryLanguage.SPARQL, "ASK {   <x:r> <x:refers> << <x:s> <x:p> \"d\" >> . }");
            TestSparqlStar.assertTrue((boolean)tq.evaluate());
            selectStr = "select ?s {   ?s <x:refers> << <x:s> <x:p> \"d\" >> . }";
            tq = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "select ?s {   ?s <x:refers> << <x:s> <x:p> \"d\" >> . }");
            try (TupleQueryResult tqr = tq.evaluate();){
                s2 = vf.createURI("x:r");
                cnt = 0;
                while (tqr.hasNext()) {
                    bs = (BindingSet)tqr.next();
                    TestSparqlStar.assertEquals((Object)s2, (Object)bs.getBinding("s").getValue());
                    ++cnt;
                }
                TestSparqlStar.assertEquals((int)1, (int)cnt);
            }
            selectStr = "select ?s {   ?s <x:refers> ?o .   bind ( << <x:s> <x:p> \"d\" >> as ?o ) }";
            tq = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "select ?s {   ?s <x:refers> ?o .   bind ( << <x:s> <x:p> \"d\" >> as ?o ) }");
            tqr = tq.evaluate();
            try {
                s2 = vf.createURI("x:r");
                cnt = 0;
                while (tqr.hasNext()) {
                    bs = (BindingSet)tqr.next();
                    TestSparqlStar.assertEquals((Object)s2, (Object)bs.getBinding("s").getValue());
                    ++cnt;
                }
                TestSparqlStar.assertEquals((int)1, (int)cnt);
            }
            finally {
                tqr.close();
            }
            selectStr = "construct {   ?s <x:refers> << <x:s> <x:p> \"d\" >> . } where {   ?s <x:refers> << <x:s> <x:p> \"d\" >> . }";
            GraphQuery tg = cxn.prepareGraphQuery(QueryLanguage.SPARQL, "construct {   ?s <x:refers> << <x:s> <x:p> \"d\" >> . } where {   ?s <x:refers> << <x:s> <x:p> \"d\" >> . }");
            s2 = vf.createURI("x:r");
            try (GraphQueryResult tgr = tg.evaluate();){
                cnt = 0;
                while (tgr.hasNext()) {
                    Statement st = (Statement)tgr.next();
                    TestSparqlStar.assertEquals((Object)s2, (Object)st.getSubject());
                    TestSparqlStar.assertTrue((boolean)((BigdataBNode)st.getObject()).isStatementIdentifier());
                    ++cnt;
                }
                TestSparqlStar.assertEquals((int)1, (int)cnt);
            }
            String deteleStr = "delete data {   <x:s> <x:p> \"d\" .   <x:r> <x:refers> << <x:s> <x:p> \"d\" >> . }";
            Update delete = cxn.prepareUpdate(QueryLanguage.SPARQL, "delete data {   <x:s> <x:p> \"d\" .   <x:r> <x:refers> << <x:s> <x:p> \"d\" >> . }");
            delete.execute();
            TestSparqlStar.assertEquals((long)0L, (long)cxn.getTripleStore().getStatementCount(true));
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRecursion() throws Exception {
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getProperties());
        try {
            BindingSet bs;
            int cnt;
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            TestSparqlStar.assertEquals((long)0L, (long)cxn.getTripleStore().getStatementCount(true));
            BigdataValueFactory vf = (BigdataValueFactory)sail.getValueFactory();
            String updateStr = "insert data {   <x:s> <x:p> \"d\" .   <x:r> <x:refers> << <x:s> <x:p> \"d\" >> .   <x:z> <x:recurs> << <x:r> <x:refers> << <x:s> <x:p> \"d\" >> >>.}";
            Update update = cxn.prepareUpdate(QueryLanguage.SPARQL, "insert data {   <x:s> <x:p> \"d\" .   <x:r> <x:refers> << <x:s> <x:p> \"d\" >> .   <x:z> <x:recurs> << <x:r> <x:refers> << <x:s> <x:p> \"d\" >> >>.}");
            update.execute();
            TestSparqlStar.assertEquals((long)3L, (long)cxn.getTripleStore().getStatementCount(true));
            BigdataURI s = vf.createURI("x:s");
            BigdataURI p = vf.createURI("x:p");
            BigdataLiteral o = vf.createLiteral("d");
            BigdataURI s1 = vf.createURI("x:r");
            BigdataURI p1 = vf.createURI("x:refers");
            BigdataURI s2 = vf.createURI("x:z");
            BigdataURI p2 = vf.createURI("x:recurs");
            try (RepositoryResult result = cxn.getStatements((Resource)s, (URI)p, (Value)o, true, new Resource[0]);){
                int cnt2 = 0;
                while (result.hasNext()) {
                    BigdataStatement resultStmt = (BigdataStatement)result.next();
                    BigdataBNode bNode = vf.createBNode(resultStmt);
                    try (RepositoryResult result2 = cxn.getStatements((Resource)s1, (URI)p1, (Value)bNode, true, new Resource[0]);){
                        while (result2.hasNext()) {
                            BigdataStatement result2Stmt = (BigdataStatement)result2.next();
                            BigdataBNode bNode2 = vf.createBNode(result2Stmt);
                            TestSparqlStar.assertTrue((boolean)cxn.hasStatement((Resource)s2, (URI)p2, (Value)bNode2, true, new Resource[0]));
                            ++cnt2;
                        }
                    }
                }
                TestSparqlStar.assertEquals((int)1, (int)cnt2);
            }
            String selectStr = "ASK {   <x:z> <x:recurs> << <x:r> <x:refers> << <x:s> <x:p> \"d\" >> >>.}";
            BooleanQuery tq = cxn.prepareBooleanQuery(QueryLanguage.SPARQL, "ASK {   <x:z> <x:recurs> << <x:r> <x:refers> << <x:s> <x:p> \"d\" >> >>.}");
            TestSparqlStar.assertTrue((boolean)tq.evaluate());
            selectStr = "select ?s {   ?s <x:recurs> << <x:r> <x:refers> << <x:s> <x:p> \"d\" >> >>.}";
            tq = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "select ?s {   ?s <x:recurs> << <x:r> <x:refers> << <x:s> <x:p> \"d\" >> >>.}");
            BigdataURI s22 = vf.createURI("x:z");
            try (TupleQueryResult tqr = tq.evaluate();){
                cnt = 0;
                while (tqr.hasNext()) {
                    bs = (BindingSet)tqr.next();
                    TestSparqlStar.assertEquals((Object)s22, (Object)bs.getBinding("s").getValue());
                    ++cnt;
                }
                TestSparqlStar.assertEquals((int)1, (int)cnt);
            }
            selectStr = "select ?s {   ?s <x:recurs> ?o .  bind (<< <x:r> <x:refers> << <x:s> <x:p> \"d\" >> >> as ?o ) }";
            tq = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "select ?s {   ?s <x:recurs> ?o .  bind (<< <x:r> <x:refers> << <x:s> <x:p> \"d\" >> >> as ?o ) }");
            tqr = tq.evaluate();
            s22 = vf.createURI("x:z");
            try {
                cnt = 0;
                while (tqr.hasNext()) {
                    bs = (BindingSet)tqr.next();
                    TestSparqlStar.assertEquals((Object)s22, (Object)bs.getBinding("s").getValue());
                    ++cnt;
                }
                TestSparqlStar.assertEquals((int)1, (int)cnt);
            }
            finally {
                tqr.close();
            }
            selectStr = "construct {   ?s <x:recurs> << <x:r> <x:refers> << <x:s> <x:p> \"d\" >> >>.} where {   ?s <x:recurs> << <x:r> <x:refers> << <x:s> <x:p> \"d\" >> >>.}";
            GraphQuery tg = cxn.prepareGraphQuery(QueryLanguage.SPARQL, "construct {   ?s <x:recurs> << <x:r> <x:refers> << <x:s> <x:p> \"d\" >> >>.} where {   ?s <x:recurs> << <x:r> <x:refers> << <x:s> <x:p> \"d\" >> >>.}");
            s22 = vf.createURI("x:z");
            try (GraphQueryResult tgr = tg.evaluate();){
                cnt = 0;
                while (tgr.hasNext()) {
                    Statement st = (Statement)tgr.next();
                    TestSparqlStar.assertEquals((Object)s22, (Object)st.getSubject());
                    TestSparqlStar.assertTrue((boolean)((BigdataBNode)st.getObject()).isStatementIdentifier());
                    ++cnt;
                }
                TestSparqlStar.assertEquals((int)1, (int)cnt);
            }
            String deleteStr = "delete data {   <x:s> <x:p> \"d\" .   <x:r> <x:refers> << <x:s> <x:p> \"d\" >> .   <x:z> <x:recurs> << <x:r> <x:refers> << <x:s> <x:p> \"d\" >> >>.}";
            Update delete = cxn.prepareUpdate(QueryLanguage.SPARQL, "delete data {   <x:s> <x:p> \"d\" .   <x:r> <x:refers> << <x:s> <x:p> \"d\" >> .   <x:z> <x:recurs> << <x:r> <x:refers> << <x:s> <x:p> \"d\" >> >>.}");
            delete.execute();
            TestSparqlStar.assertEquals((long)0L, (long)cxn.getTripleStore().getStatementCount(true));
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }
}

