/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.changesets.IChangeRecord;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import org.apache.log4j.Logger;
import org.openrdf.query.QueryLanguage;

public class TestSparqlUpdateCommit
extends ProxyBigdataSailTestCase {
    private static final Logger log = Logger.getLogger(TestSparqlUpdateCommit.class);

    public TestSparqlUpdateCommit() {
    }

    public TestSparqlUpdateCommit(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCountCommits() throws Exception {
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getProperties());
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            CommitCounter counter = new CommitCounter();
            cxn.addChangeLog((IChangeLog)counter);
            cxn.prepareUpdate(QueryLanguage.SPARQL, "insert data { <x:s> <x:p> \"foo\" . }").execute();
            cxn.prepareUpdate(QueryLanguage.SPARQL, "insert data { <x:s> <x:p> \"bar\" . }").execute();
            cxn.commit();
            TestSparqlUpdateCommit.assertTrue((counter.n == 1 ? 1 : 0) != 0);
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }

    public static class CommitCounter
    implements IChangeLog {
        int n = 0;

        public void transactionCommited(long commitTime) {
            ++this.n;
        }

        public void transactionPrepare() {
        }

        public void transactionBegin() {
        }

        public void transactionAborted() {
        }

        public void close() {
        }

        public void changeEvent(IChangeRecord record) {
        }
    }
}

