/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.QuadsTestCase;
import com.bigdata.rdf.sparql.ast.QueryOptimizerEnum;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.sail.SailTupleQuery;

public class TestStrBOp
extends QuadsTestCase {
    protected static final Logger log = Logger.getLogger(TestStrBOp.class);
    protected static final boolean INFO = log.isInfoEnabled();

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public TestStrBOp() {
    }

    public TestStrBOp(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStr() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                cxn.setAutoCommit(false);
                ValueFactory vf = sail.getValueFactory();
                URI X = vf.createURI("http://www.bigdata.com/rdf#X");
                URI dt = vf.createURI("http://www.bigdata.com/rdf#myDatatype");
                Literal _2 = vf.createLiteral("foo", XSD.STRING);
                Literal _3 = vf.createLiteral("foo", dt);
                Literal _4 = vf.createLiteral("foo", "EN");
                Literal _5 = vf.createLiteral(true);
                Literal _6 = vf.createLiteral(1000L);
                cxn.add((Resource)X, RDF.TYPE, (Value)RDFS.RESOURCE, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_2, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_3, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_4, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_5, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_6, new Resource[0]);
                cxn.commit();
                if (log.isInfoEnabled()) {
                    log.info((Object)cxn.getTripleStore().dumpStore());
                }
                String query = "prefix bd: <http://www.bigdata.com/rdf#> prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> select ?p ?o where {   hint:Query hint:optimizer \"" + QueryOptimizerEnum.None + "\"." + "  ?s rdf:type rdfs:Resource . " + "  ?s ?p ?o . " + "  filter(str(?o) = \"foo\") " + "  filter(str(?p) = \"" + RDFS.LABEL + "\") " + "}";
                SailTupleQuery tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                tupleQuery.setIncludeInferred(false);
                if (log.isInfoEnabled()) {
                    log.info((Object)query);
                    TupleQueryResult result = tupleQuery.evaluate();
                    while (result.hasNext()) {
                        log.info(result.next());
                    }
                }
            }
        }
        finally {
            if (sail instanceof BigdataSail) {
                sail.__tearDownUnitTest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegex() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                cxn.setAutoCommit(false);
                ValueFactory vf = sail.getValueFactory();
                URI X = vf.createURI("http://www.bigdata.com/rdf#X");
                URI dt = vf.createURI("http://www.bigdata.com/rdf#myDatatype");
                Literal _2 = vf.createLiteral("foo", XSD.STRING);
                Literal _3 = vf.createLiteral("foo", dt);
                Literal _4 = vf.createLiteral("foo", "EN");
                Literal _5 = vf.createLiteral(true);
                Literal _6 = vf.createLiteral(1000L);
                cxn.add((Resource)X, RDF.TYPE, (Value)RDFS.RESOURCE, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_2, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_3, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_4, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_5, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_6, new Resource[0]);
                cxn.commit();
                if (log.isInfoEnabled()) {
                    log.info((Object)cxn.getTripleStore().dumpStore());
                }
                String query = "prefix bd: <http://www.bigdata.com/rdf#> prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> select ?o where {   hint:Query hint:optimizer \"" + QueryOptimizerEnum.None + "\"." + "  ?s rdf:type rdfs:Resource . " + "  ?s ?p ?o . " + "  filter(regex(str(?o), \"FOO\", \"i\")) " + "}";
                SailTupleQuery tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                tupleQuery.setIncludeInferred(false);
                if (log.isInfoEnabled()) {
                    log.info((Object)query);
                    TupleQueryResult result = tupleQuery.evaluate();
                    while (result.hasNext()) {
                        log.info(result.next());
                    }
                }
            }
        }
        finally {
            if (sail instanceof BigdataSail) {
                sail.__tearDownUnitTest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCast() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection cxn = repo.getConnection();){
                cxn.setAutoCommit(false);
                ValueFactory vf = sail.getValueFactory();
                URI X = vf.createURI("http://www.bigdata.com/rdf#X");
                URI dt = vf.createURI("http://www.bigdata.com/rdf#myDatatype");
                Literal _2 = vf.createLiteral("foo", XSD.STRING);
                Literal _3 = vf.createLiteral("foo", dt);
                Literal _4 = vf.createLiteral("foo", "EN");
                Literal _5 = vf.createLiteral(true);
                Literal _6 = vf.createLiteral(1000L);
                cxn.add((Resource)X, RDF.TYPE, (Value)RDFS.RESOURCE, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_2, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_3, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_4, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_5, new Resource[0]);
                cxn.add((Resource)X, RDFS.LABEL, (Value)_6, new Resource[0]);
                cxn.commit();
                if (log.isInfoEnabled()) {
                    log.info((Object)cxn.getTripleStore().dumpStore());
                }
                String query = "prefix bd: <http://www.bigdata.com/rdf#> prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> select ?o where {   hint:Query hint:optimizer \"" + QueryOptimizerEnum.None + "\"." + "  ?s rdf:type rdfs:Resource . " + "  ?s ?p ?o . " + "  FILTER(datatype(xsd:boolean(?o)) = xsd:boolean) . " + "}";
                SailTupleQuery tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                tupleQuery.setIncludeInferred(false);
                if (log.isInfoEnabled()) {
                    log.info((Object)query);
                    TupleQueryResult result = tupleQuery.evaluate();
                    while (result.hasNext()) {
                        log.info(result.next());
                    }
                }
            }
        }
        finally {
            if (sail instanceof BigdataSail) {
                sail.__tearDownUnitTest();
            }
        }
    }
}

