/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.QuadsTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.SailTupleQuery;
import org.openrdf.rio.RDFFormat;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class TestTemplate
extends QuadsTestCase {
    protected static final Logger log = Logger.getLogger(TestTemplate.class);

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public TestTemplate() {
    }

    public TestTemplate(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug() throws Exception {
        MemoryStore sesameSail = new MemoryStore();
        BigdataSail bigdataSail = this.getSail();
        String data = "data.ttl";
        String baseURI = "";
        RDFFormat format = RDFFormat.TURTLE;
        String query = "prefix bd: <http://www.bigdata.com/rdf#> prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> SELECT DISTINCT ?neType ?majorType ?minorType WHERE {   {     ?neType <http://www.w3.org/2000/01/rdf-schema#subClassOf> <http://example/class/NamedEntity> .     FILTER(?neType != <http://example/class/NamedEntity>)   }   UNION   { ?lookup <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://example/class/Lookup> .     ?lookup <http://example/prop/lookup/majorType> ?majorType .     OPTIONAL { ?lookup <http://example/prop/lookup/minorType> ?minorType }   } }";
        try {
            TupleQueryResult result;
            SailTupleQuery tupleQuery;
            sesameSail.initialize();
            bigdataSail.initialize();
            SailRepository sesameRepo = new SailRepository((Sail)sesameSail);
            BigdataSailRepository bigdataRepo = new BigdataSailRepository(bigdataSail);
            try (RepositoryConnection cxn = sesameRepo.getConnection();){
                cxn.setAutoCommit(false);
                cxn.add(((Object)((Object)this)).getClass().getResourceAsStream("data.ttl"), "", format, new Resource[0]);
                cxn.commit();
            }
            cxn = bigdataRepo.getConnection();
            try {
                cxn.setAutoCommit(false);
                cxn.add(((Object)((Object)this)).getClass().getResourceAsStream("data.ttl"), "", format, new Resource[0]);
                cxn.commit();
            }
            finally {
                cxn.close();
            }
            LinkedList<BindingSet> answer = new LinkedList<BindingSet>();
            try (RepositoryConnection cxn = sesameRepo.getConnection();){
                tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, "prefix bd: <http://www.bigdata.com/rdf#> prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> SELECT DISTINCT ?neType ?majorType ?minorType WHERE {   {     ?neType <http://www.w3.org/2000/01/rdf-schema#subClassOf> <http://example/class/NamedEntity> .     FILTER(?neType != <http://example/class/NamedEntity>)   }   UNION   { ?lookup <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://example/class/Lookup> .     ?lookup <http://example/prop/lookup/majorType> ?majorType .     OPTIONAL { ?lookup <http://example/prop/lookup/minorType> ?minorType }   } }");
                tupleQuery.setIncludeInferred(false);
                result = tupleQuery.evaluate();
                if (log.isInfoEnabled()) {
                    log.info((Object)"sesame results:");
                    if (!result.hasNext()) {
                        log.info((Object)"no results.");
                    }
                }
                while (result.hasNext()) {
                    BindingSet bs = (BindingSet)result.next();
                    answer.add(bs);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)bs);
                }
            }
            cxn = bigdataRepo.getReadOnlyConnection();
            try {
                tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, "prefix bd: <http://www.bigdata.com/rdf#> prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> SELECT DISTINCT ?neType ?majorType ?minorType WHERE {   {     ?neType <http://www.w3.org/2000/01/rdf-schema#subClassOf> <http://example/class/NamedEntity> .     FILTER(?neType != <http://example/class/NamedEntity>)   }   UNION   { ?lookup <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://example/class/Lookup> .     ?lookup <http://example/prop/lookup/majorType> ?majorType .     OPTIONAL { ?lookup <http://example/prop/lookup/minorType> ?minorType }   } }");
                tupleQuery.setIncludeInferred(false);
                if (log.isInfoEnabled()) {
                    result = tupleQuery.evaluate();
                    log.info((Object)"bigdata results:");
                    if (!result.hasNext()) {
                        log.info((Object)"no results.");
                    }
                    while (result.hasNext()) {
                        log.info(result.next());
                    }
                }
                result = tupleQuery.evaluate();
                this.compare(result, answer);
            }
            finally {
                cxn.close();
            }
        }
        finally {
            bigdataSail.__tearDownUnitTest();
            sesameSail.shutDown();
        }
    }
}

