/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

public class TestTicket1086
extends ProxyBigdataSailTestCase {
    public Properties getTriplesNoInference() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.QUADS, "false");
        props.setProperty(BigdataSail.Options.STATEMENT_IDENTIFIERS, "false");
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public Properties getTriplesNoInferenceNoQuadsStripping() {
        Properties props = this.getTriplesNoInference();
        props.setProperty(BigdataSail.Options.REJECT_QUADS_IN_TRIPLE_MODE, "true");
        return props;
    }

    public TestTicket1086() {
    }

    public TestTicket1086(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQuadStripping() throws Exception {
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getTriplesNoInference());
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            BigdataValueFactory vf = (BigdataValueFactory)sail.getValueFactory();
            BigdataURI s = vf.createURI("http://test/s");
            BigdataURI p = vf.createURI("http://test/p");
            BigdataURI o = vf.createURI("http://test/o");
            BigdataURI c = vf.createURI("http://test/c");
            BigdataStatement stmt = vf.createStatement((Resource)s, (URI)p, (Value)o, (Resource)c);
            cxn.add((Statement)stmt, new Resource[0]);
            RepositoryResult stmts = cxn.getStatements(null, null, null, false, new Resource[0]);
            Statement res = (Statement)stmts.next();
            TestTicket1086.assertEquals((Object)s, (Object)res.getSubject());
            TestTicket1086.assertEquals((Object)p, (Object)res.getPredicate());
            TestTicket1086.assertEquals((Object)o, (Object)res.getObject());
            TestTicket1086.assertEquals(null, (Object)res.getContext());
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQuadStrippingRejected() throws Exception {
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getTriplesNoInferenceNoQuadsStripping());
        boolean exceptionEncountered = false;
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            BigdataValueFactory vf = (BigdataValueFactory)sail.getValueFactory();
            BigdataURI s = vf.createURI("http://test/s");
            BigdataURI p = vf.createURI("http://test/p");
            BigdataURI o = vf.createURI("http://test/o");
            BigdataURI c = vf.createURI("http://test/c");
            BigdataStatement stmt = vf.createStatement((Resource)s, (URI)p, (Value)o, (Resource)c);
            cxn.add((Statement)stmt, new Resource[0]);
        }
        catch (RepositoryException e) {
            exceptionEncountered = true;
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
        TestTicket1086.assertTrue((boolean)exceptionEncountered);
    }
}

