/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.Properties;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.BindingImpl;
import org.openrdf.rio.RDFFormat;

public class TestTicket1388
extends ProxyBigdataSailTestCase {
    public Properties getTriplesNoInference() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.QUADS, "false");
        props.setProperty(BigdataSail.Options.STATEMENT_IDENTIFIERS, "false");
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public TestTicket1388() {
    }

    public TestTicket1388(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDateFunction() throws Exception {
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getTriplesNoInference());
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            cxn.begin();
            try {
                InputStream is = TestTicket1388.class.getResourceAsStream("testTicket1388.n3");
                if (is == null) {
                    throw new IOException("Could not locate resource: testTicket1388.n3");
                }
                try (InputStreamReader reader = new InputStreamReader(new BufferedInputStream(is));){
                    cxn.add((Reader)reader, "", RDFFormat.N3, new Resource[0]);
                }
                cxn.commit();
            }
            catch (OpenRDFException ex) {
                cxn.rollback();
                throw ex;
            }
            cxn.commit();
            String query = "SELECT ?myDate (count(?doc) as ?countDoc) \n { ?doc rdf:type <http://www.example.com/Document> . \n  ?doc <http://www.example.com/created> ?date . \n  filter((<http://www.w3.org/2001/XMLSchema#date>(?date)) >= \"2014-04-11\"^^<http://www.w3.org/2001/XMLSchema#date>) .\n  filter((<http://www.w3.org/2001/XMLSchema#date>(?date)) < \"2014-05-30\"^^<http://www.w3.org/2001/XMLSchema#date>) .\n  bind((<http://www.w3.org/2001/XMLSchema#date>(?date)) as ?myDate) .\n } group by ?myDate";
            TupleQuery q = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT ?myDate (count(?doc) as ?countDoc) \n { ?doc rdf:type <http://www.example.com/Document> . \n  ?doc <http://www.example.com/created> ?date . \n  filter((<http://www.w3.org/2001/XMLSchema#date>(?date)) >= \"2014-04-11\"^^<http://www.w3.org/2001/XMLSchema#date>) .\n  filter((<http://www.w3.org/2001/XMLSchema#date>(?date)) < \"2014-05-30\"^^<http://www.w3.org/2001/XMLSchema#date>) .\n  bind((<http://www.w3.org/2001/XMLSchema#date>(?date)) as ?myDate) .\n } group by ?myDate");
            TupleQueryResult tqr = q.evaluate();
            LinkedList<BindingSet> solution = new LinkedList<BindingSet>();
            solution.add(this.createBindingSet(new Binding[]{new BindingImpl("myDate", (Value)new LiteralImpl("2014-04-11", XMLSchema.DATE)), new BindingImpl("countDoc", (Value)new LiteralImpl(Integer.toString(3), XMLSchema.INTEGER))}));
            solution.add(this.createBindingSet(new Binding[]{new BindingImpl("myDate", (Value)new LiteralImpl("2014-05-29", XMLSchema.DATE)), new BindingImpl("countDoc", (Value)new LiteralImpl(Integer.toString(2), XMLSchema.INTEGER))}));
            this.compare(tqr, solution);
            tqr.close();
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }
}

