/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.sparql.ast.QuadsOperationInTriplesModeException;
import com.bigdata.rdf.vocab.NoVocabulary;
import com.ibm.icu.impl.Assert;
import java.util.Properties;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.Update;

public class TestTicket1518
extends ProxyBigdataSailTestCase {
    public Properties getTriplesNoInference() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.QUADS, "false");
        props.setProperty(BigdataSail.Options.STATEMENT_IDENTIFIERS, "false");
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.TEXT_INDEX, "false");
        return props;
    }

    public TestTicket1518() {
    }

    public TestTicket1518(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQuadsInSPARQLInsertBlock() throws Exception {
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getTriplesNoInference());
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            cxn.begin();
            String update = "INSERT DATA  {GRAPH <http://graphA> {<s:s1> <p:p1> <o:o1> .} } ";
            Update q = cxn.prepareUpdate(QueryLanguage.SPARQL, "INSERT DATA  {GRAPH <http://graphA> {<s:s1> <p:p1> <o:o1> .} } ");
            try {
                q.execute();
                Assert.fail((String)"");
            }
            catch (QuadsOperationInTriplesModeException ex) {
                String expectedMessage = "Quads in SPARQL update data block are not supported in triples mode.";
                TestTicket1518.assertEquals((String)expectedMessage, (String)ex.getMessage());
            }
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQuadsInSPARQLDeleteDataBlock() throws Exception {
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getTriplesNoInference());
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            cxn.begin();
            String update = "DELETE DATA  {GRAPH <http://graphA> {<s:s1> <p:p1> <o:o1> .} } ";
            Update q = cxn.prepareUpdate(QueryLanguage.SPARQL, "DELETE DATA  {GRAPH <http://graphA> {<s:s1> <p:p1> <o:o1> .} } ");
            try {
                q.execute();
                Assert.fail((String)"");
            }
            catch (QuadsOperationInTriplesModeException ex) {
                String expectedMessage = "Quads in SPARQL update data block are not supported in triples mode.";
                TestTicket1518.assertEquals((String)expectedMessage, (String)ex.getMessage());
            }
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNamedGraphReferencedThroughWITHClause() throws Exception {
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getTriplesNoInference());
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            cxn.begin();
            String update = "with <c:graphA> INSERT { <s:s1> <p:p1> <o:o1> . } where {}";
            Update q = cxn.prepareUpdate(QueryLanguage.SPARQL, "with <c:graphA> INSERT { <s:s1> <p:p1> <o:o1> . } where {}");
            try {
                q.execute();
                Assert.fail((String)"");
            }
            catch (QuadsOperationInTriplesModeException ex) {
                String expectedMessage = "Use of WITH and GRAPH constructs in query body is not supported in triples mode.";
                TestTicket1518.assertEquals((String)expectedMessage, (String)ex.getMessage());
            }
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGRAPHConstructInQueryBody() throws Exception {
        BigdataSailRepositoryConnection cxn = null;
        BigdataSail sail = this.getSail(this.getTriplesNoInference());
        try {
            sail.initialize();
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            cxn = repo.getConnection();
            cxn.begin();
            String query = "SELECT ?g ?s ?p ?oWHERE { GRAPH ?g { ?s ?p ?o }}";
            TupleQuery q = cxn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT ?g ?s ?p ?oWHERE { GRAPH ?g { ?s ?p ?o }}");
            try {
                TupleQueryResult tqr = q.evaluate();
                Assert.fail((String)"");
            }
            catch (QuadsOperationInTriplesModeException ex) {
                String expectedMessage = "Use of WITH and GRAPH constructs in query body is not supported in triples mode.";
                TestTicket1518.assertEquals((String)expectedMessage, (String)ex.getMessage());
            }
        }
        finally {
            if (cxn != null) {
                cxn.close();
            }
            sail.__tearDownUnitTest();
        }
    }
}

