/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.bop.BOp;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.QuadsTestCase;
import com.bigdata.rdf.sail.sparql.Bigdata2ASTSPARQLParser;
import com.bigdata.rdf.sail.sparql.ast.VisitorException;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.eval.ASTDeferredIVResolution;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.io.IOException;
import java.util.List;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFParseException;

public class TestTicket1747
extends QuadsTestCase {
    public TestTicket1747() {
    }

    public TestTicket1747(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            this.executeQuery(new BigdataSailRepository(sail));
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery(BigdataSailRepository repo) throws RepositoryException, MalformedQueryException, QueryEvaluationException, RDFParseException, IOException, VisitorException {
        try {
            repo.initialize();
            try (BigdataSailRepositoryConnection conn = repo.getConnection();){
                BigdataValueFactory vf = conn.getValueFactory();
                IV xsdDateTimeIV = conn.getTripleStore().getLexiconRelation().resolve((URI)vf.createURI(XMLSchema.DATETIME.stringValue())).getIV();
                TestTicket1747.assertFalse((boolean)xsdDateTimeIV.isNullIV());
                TestTicket1747.assertTrue((boolean)xsdDateTimeIV.isVocabulary());
                String query = "PREFIX wdt: <http://www.wikidata.org/prop/direct/>\r\nPREFIX wikibase: <http://wikiba.se/ontology#>\r\nPREFIX p: <http://www.wikidata.org/prop/>\r\nPREFIX v: <http://www.wikidata.org/prop/statement/>\r\nPREFIX q: <http://www.wikidata.org/prop/qualifier/>\r\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\r\nSELECT ?entity (year(?date) as ?year)\r\nWHERE\r\n{\r\n?entityS wdt:P569 ?date .\r\nSERVICE wikibase:label {\r\nbd:serviceParam wikibase:language \"en\" .\r\n?entityS rdfs:label ?entity\r\n}\r\nFILTER (datatype(?date) = xsd:dateTime)\r\nFILTER (month(?date) = month(now()))\r\nFILTER (day(?date) = day(now()))\r\n}\r\nLIMIT 10";
                ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2(query, null);
                xsdDateTimeIV = conn.getTripleStore().getLexiconRelation().resolve(XMLSchema.DATETIME).getIV();
                TestTicket1747.assertFalse((boolean)xsdDateTimeIV.isNullIV());
                TestTicket1747.assertTrue((boolean)xsdDateTimeIV.isVocabulary());
                ASTDeferredIVResolution.resolveQuery((AbstractTripleStore)conn.getTripleStore(), (ASTContainer)astContainer);
                xsdDateTimeIV = conn.getTripleStore().getLexiconRelation().resolve(XMLSchema.DATETIME).getIV();
                TestTicket1747.assertFalse((boolean)xsdDateTimeIV.isNullIV());
                TestTicket1747.assertTrue((boolean)xsdDateTimeIV.isVocabulary());
                QueryRoot queryRoot = astContainer.getOriginalAST();
                GraphPatternGroup whereClause = queryRoot.getWhereClause();
                List filterNodes = whereClause.getChildren(FilterNode.class);
                for (FilterNode filterNode : filterNodes) {
                    this.checkNode((BOp)filterNode);
                }
            }
        }
        finally {
            repo.shutDown();
        }
    }

    private void checkNode(BOp bop) {
        if (bop instanceof ConstantNode) {
            BigdataValue value = ((ConstantNode)bop).getValue();
            if (XMLSchema.DATETIME.equals((Object)value)) {
                IV xsdDateTimeIV = value.getIV();
                TestTicket1747.assertFalse((boolean)xsdDateTimeIV.isNullIV());
                TestTicket1747.assertTrue((boolean)xsdDateTimeIV.isVocabulary());
            }
        } else {
            for (BOp arg : bop.args()) {
                this.checkNode(arg);
            }
        }
    }
}

