/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.literal.XSDBooleanIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.BigdataSailTupleQuery;
import com.bigdata.rdf.sail.QuadsTestCase;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import java.io.IOException;
import org.openrdf.model.Resource;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;

public class TestTicket1755
extends QuadsTestCase {
    public TestTicket1755() {
    }

    public TestTicket1755(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug() throws Exception {
        BigdataSail sail = this.getSail();
        try {
            this.executeQuery(new BigdataSailRepository(sail));
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery(BigdataSailRepository repo) throws RepositoryException, MalformedQueryException, QueryEvaluationException, RDFParseException, IOException {
        try {
            repo.initialize();
            conn.setAutoCommit(false);
            try (BigdataSailRepositoryConnection conn = repo.getConnection();){
                conn.add(((Object)((Object)this)).getClass().getResourceAsStream("TestTicket1755.n3"), "", RDFFormat.TURTLE, new Resource[0]);
                conn.commit();
                String query = "SELECT ?s WHERE {\r\n   ?s <http://begin> ?begin.\r\n   ?s <http://end> ?end.\r\n   FILTER(\"0521-01-01\"^^<http://www.w3.org/2001/XMLSchema#date> >= ?begin)\r\n}";
                int expectedIVs = 3;
                this.testQuery(conn, "SELECT ?s WHERE {\r\n   ?s <http://begin> ?begin.\r\n   ?s <http://end> ?end.\r\n   FILTER(\"0521-01-01\"^^<http://www.w3.org/2001/XMLSchema#date> >= ?begin)\r\n}", expectedIVs);
                query = "SELECT ?s WHERE {\r\n   ?s <http://begin> ?begin.\r\n   ?s <http://end> ?end.\r\n   FILTER((\"0521-01-01\"^^<http://www.w3.org/2001/XMLSchema#date> >= ?begin) && true)\r\n}";
                expectedIVs = 6;
                this.testQuery(conn, "SELECT ?s WHERE {\r\n   ?s <http://begin> ?begin.\r\n   ?s <http://end> ?end.\r\n   FILTER((\"0521-01-01\"^^<http://www.w3.org/2001/XMLSchema#date> >= ?begin) && true)\r\n}", expectedIVs);
            }
        }
        finally {
            repo.shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testQuery(BigdataSailRepositoryConnection conn, String query, int expectedIVs) throws MalformedQueryException, RepositoryException, QueryEvaluationException {
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult tqr = tq.evaluate();){
            int cnt = 0;
            while (tqr.hasNext()) {
                tqr.next();
                ++cnt;
            }
            QueryRoot queryRoot = ((BigdataSailTupleQuery)tq).getASTContainer().getOriginalAST();
            cnt = 0;
            for (Object filterNode : queryRoot.getWhereClause().getChildren(FilterNode.class)) {
                cnt += this.checkNode((BOp)filterNode);
            }
            TestTicket1755.assertEquals((String)"Expected inlined IV for date literal", (int)expectedIVs, (int)cnt);
        }
    }

    private int checkNode(BOp bop) {
        BigdataValue value;
        int cnt = 0;
        for (BOp arg : bop.args()) {
            cnt += this.checkNode(arg);
        }
        if (bop instanceof ValueExpressionNode) {
            for (BOp arg : ((ValueExpressionNode)bop).getValueExpression().args()) {
                cnt += this.checkNode(arg);
            }
        }
        if (bop instanceof ConstantNode && (value = ((ConstantNode)bop).getValue()) instanceof BigdataLiteral && XMLSchema.DATE.equals((Object)((BigdataLiteral)value).getDatatype())) {
            TestTicket1755.assertFalse((boolean)((BigdataLiteral)value).getIV().isNullIV());
            TestTicket1755.assertTrue((boolean)(value.getIV() instanceof LiteralExtensionIV));
            ++cnt;
        }
        if (bop instanceof Constant) {
            value = (IV)((Constant)bop).get();
            TestTicket1755.assertFalse((boolean)value.isNullIV());
            TestTicket1755.assertTrue((value instanceof LiteralExtensionIV || value instanceof XSDBooleanIV ? 1 : 0) != 0);
            ++cnt;
        }
        return cnt;
    }
}

