/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.TestTicket1889;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.Update;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;

public class TestTicket1889_2
extends TestTicket1889 {
    public TestTicket1889_2() {
    }

    public TestTicket1889_2(String arg0) {
        super(arg0);
    }

    @Override
    public Properties getProperties() {
        Properties properties = super.getProperties();
        properties.setProperty(BigdataSail.Options.QUEUE_CAPACITY, "0");
        properties.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "true");
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeQuery(BigdataSailRepository repo, int n, int k) throws RepositoryException, MalformedQueryException, QueryEvaluationException, RDFParseException, IOException, UpdateExecutionException {
        BigdataSailRepositoryConnection conn = repo.getConnection();
        conn.setAutoCommit(false);
        conn.clear(new Resource[0]);
        try {
            StringBuilder data = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                data.append("_:s").append(i % k).append(" <http://p> _:o").append(i).append(" <http://c> .\n");
            }
            conn.add((InputStream)new ByteArrayInputStream(data.toString().getBytes()), "", RDFFormat.NQUADS, new Resource[0]);
            conn.commit();
            String query = "prefix h: <http://>\r\n\r\nINSERT { \r\n    ?s h:p1 ?o .\r\n}\r\nWHERE {\r\n  ?s h:p ?o .\r\n}";
            Update q = conn.prepareUpdate(QueryLanguage.SPARQL, "prefix h: <http://>\r\n\r\nINSERT { \r\n    ?s h:p1 ?o .\r\n}\r\nWHERE {\r\n  ?s h:p ?o .\r\n}");
            q.execute();
            TestTicket1889_2.assertEquals((long)(n * 2 + 4), (long)conn.getTripleStore().getStatementCount(true));
        }
        finally {
            conn.close();
        }
    }
}

