/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.journal.IJournal;
import com.bigdata.rdf.lexicon.ITextIndexer;
import com.bigdata.rdf.lexicon.IValueCentricTextIndexer;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.LocalTripleStore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.UUID;
import org.openrdf.model.Resource;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.QueryLanguage;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;

public class TestTicket1893
extends ProxyBigdataSailTestCase {
    private static final String DATA = "<http://s> <http://p> 1 .\n<http://s> <http://p> \"2\"^^xsd:int .\n<http://s> <http://p> 3.0 .\n<http://s> <http://p> \"4.0\"^^xsd:double .\n<http://s> <http://p> true .\n<http://s> <http://p> \"false\"^^xsd:boolean .\n<http://s> <http://p> \"plain string\" .\n<http://s> <http://p> \"very long literal which length exceeds MAX_INLINE_TEXT_LENGTH\" .\n<http://s> <http://p> \"datatyped string\"^^xsd:string .\n<http://s> <http://p> \"english string\"@en .\n_:s1 <http://refers> _:s2 .\n";
    private static final RDFFormat DATA_FORMAT = RDFFormat.TURTLE;
    private static final String INSERT_SPARQL = "INSERT DATA {<http://s> <http://p> 1 .\n<http://s> <http://p> \"2\"^^xsd:int .\n<http://s> <http://p> 3.0 .\n<http://s> <http://p> \"4.0\"^^xsd:double .\n<http://s> <http://p> true .\n<http://s> <http://p> \"false\"^^xsd:boolean .\n<http://s> <http://p> \"plain string\" .\n<http://s> <http://p> \"very long literal which length exceeds MAX_INLINE_TEXT_LENGTH\" .\n<http://s> <http://p> \"datatyped string\"^^xsd:string .\n<http://s> <http://p> \"english string\"@en .\n_:s1 <http://refers> _:s2 .\n}";

    public TestTicket1893() {
    }

    public TestTicket1893(String name) {
        super(name);
    }

    public void test_1() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, true, true, true);
        this.loadData(cxn);
        IValueCentricTextIndexer searchEngine = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("1")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("2")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("3")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("4")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("true")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("false")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("plain")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("datatyped")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("english")));
        this.endTest(cxn);
    }

    public void test_2() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, true, true, true);
        this.insertSparql(cxn);
        IValueCentricTextIndexer searchEngine = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("1")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("2")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("3")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("4")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("true")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("false")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("plain")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("datatyped")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("english")));
        this.endTest(cxn);
    }

    public void test_3() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, false, false, true);
        this.loadData(cxn);
        IValueCentricTextIndexer searchEngine = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("1")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("2")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("3.0")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("4.0")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("true")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("false")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("plain")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("datatyped")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("english")));
        this.endTest(cxn);
    }

    public void test_4() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, false, false, true);
        this.insertSparql(cxn);
        IValueCentricTextIndexer searchEngine = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("1")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("2")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("3.0")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("4.0")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("true")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("false")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("plain")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("datatyped")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("english")));
        this.endTest(cxn);
    }

    public void test_5() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, true, false, true);
        this.loadData(cxn);
        IValueCentricTextIndexer searchEngine = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("1")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("2")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("3.0")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("4.0")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("true")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("false")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("plain")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("datatyped")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("english")));
        this.endTest(cxn);
    }

    public void test_6() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, true, false, true);
        this.insertSparql(cxn);
        IValueCentricTextIndexer searchEngine = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("1")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("2")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("3.0")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("4.0")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("true")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("false")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("plain")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("datatyped")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("english")));
        this.endTest(cxn);
    }

    public void test_7() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, false, true, true);
        this.loadData(cxn);
        IValueCentricTextIndexer searchEngine = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("1")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("2")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("3")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("4")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("true")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("false")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("plain")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("datatyped")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("english")));
        this.endTest(cxn);
    }

    public void test_8() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, false, true, true);
        this.insertSparql(cxn);
        IValueCentricTextIndexer searchEngine = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("1")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("2")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("3")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("4")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("true")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("false")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("plain")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("datatyped")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("english")));
        this.endTest(cxn);
    }

    public void test_9() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, true, true, false);
        this.loadData(cxn);
        IValueCentricTextIndexer searchEngine = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("1")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("2")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("3")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("4")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("true")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("false")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("plain")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("datatyped")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("english")));
        this.endTest(cxn);
    }

    public void test_10() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, true, true, false);
        this.insertSparql(cxn);
        IValueCentricTextIndexer searchEngine = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("1")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("2")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("3")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("4")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("true")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("false")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("plain")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("datatyped")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("english")));
        this.endTest(cxn);
    }

    public void test_11() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, false, false, false);
        this.loadData(cxn);
        IValueCentricTextIndexer searchEngine = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("1")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("2")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("3")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("4")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("true")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("false")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("plain")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("datatyped")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("english")));
        this.endTest(cxn);
    }

    public void test_12() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, false, false, false);
        this.insertSparql(cxn);
        IValueCentricTextIndexer searchEngine = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("1")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("2")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("3")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("4")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("true")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("false")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("plain")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("datatyped")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("english")));
        this.endTest(cxn);
    }

    public void test_13() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, true, false, false);
        this.loadData(cxn);
        IValueCentricTextIndexer searchEngine = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("1")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("2")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("3")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("4")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("true")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("false")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("plain")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("datatyped")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("english")));
        this.endTest(cxn);
    }

    public void test_14() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, true, false, false);
        this.insertSparql(cxn);
        IValueCentricTextIndexer searchEngine = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("1")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("2")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("3")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("4")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("true")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("false")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("plain")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("datatyped")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("english")));
        this.endTest(cxn);
    }

    public void test_15() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, false, true, false);
        this.loadData(cxn);
        IValueCentricTextIndexer searchEngine = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("1")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("2")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("3")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("4")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("true")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("false")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("plain")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("datatyped")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("english")));
        this.endTest(cxn);
    }

    public void test_16() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, false, true, false);
        this.insertSparql(cxn);
        IValueCentricTextIndexer searchEngine = cxn.getTripleStore().getLexiconRelation().getSearchEngine();
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("1")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("2")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("3")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("4")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("true")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("false")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("plain")));
        TestTicket1893.assertEquals((int)0, (int)searchEngine.count(this.query("datatyped")));
        TestTicket1893.assertEquals((int)1, (int)searchEngine.count(this.query("english")));
        this.endTest(cxn);
    }

    public void test_17() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, true, true);
        this.loadData(cxn);
        BigdataValueFactory vf = cxn.getValueFactory();
        BigdataValue[] values = new BigdataValue[]{vf.createURI("http://s"), vf.createLiteral("1", XMLSchema.INTEGER), vf.createLiteral(2), vf.createLiteral("3.0", XMLSchema.DECIMAL), vf.createLiteral(4.0), vf.createLiteral(true), vf.createLiteral(false), vf.createLiteral("plain string"), vf.createLiteral("datatyped string", XMLSchema.STRING), vf.createLiteral("english string", "en")};
        cxn.getTripleStore().getLexiconRelation().addTerms(values, values.length, true);
        TestTicket1893.assertTrue((boolean)values[0].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[1].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[2].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[3].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[4].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[5].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[6].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[7].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[8].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[9].getIV().isInline());
        this.endTest(cxn);
    }

    public void test_18() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, true, true);
        this.insertSparql(cxn);
        BigdataValueFactory vf = cxn.getValueFactory();
        BigdataValue[] values = new BigdataValue[]{vf.createURI("http://s"), vf.createLiteral("1", XMLSchema.INTEGER), vf.createLiteral(2), vf.createLiteral("3.0", XMLSchema.DECIMAL), vf.createLiteral(4.0), vf.createLiteral(true), vf.createLiteral(false), vf.createLiteral("plain string"), vf.createLiteral("datatyped string", XMLSchema.STRING), vf.createLiteral("english string", "en")};
        cxn.getTripleStore().getLexiconRelation().addTerms(values, values.length, true);
        TestTicket1893.assertTrue((boolean)values[0].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[1].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[2].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[3].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[4].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[5].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[6].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[7].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[8].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[9].getIV().isInline());
        this.endTest(cxn);
    }

    public void test_19() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, false, false);
        this.loadData(cxn);
        BigdataValueFactory vf = cxn.getValueFactory();
        BigdataValue[] values = new BigdataValue[]{vf.createURI("http://s"), vf.createLiteral("1", XMLSchema.INTEGER), vf.createLiteral(2), vf.createLiteral("3.0", XMLSchema.DECIMAL), vf.createLiteral(4.0), vf.createLiteral(true), vf.createLiteral(false), vf.createLiteral("plain string"), vf.createLiteral("datatyped string", XMLSchema.STRING), vf.createLiteral("english string", "en")};
        cxn.getTripleStore().getLexiconRelation().addTerms(values, values.length, true);
        TestTicket1893.assertFalse((boolean)values[0].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[1].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[2].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[3].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[4].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[5].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[6].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[7].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[8].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[9].getIV().isInline());
        this.endTest(cxn);
    }

    public void test_20() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, false, false);
        this.insertSparql(cxn);
        BigdataValueFactory vf = cxn.getValueFactory();
        BigdataValue[] values = new BigdataValue[]{vf.createURI("http://s"), vf.createLiteral("1", XMLSchema.INTEGER), vf.createLiteral(2), vf.createLiteral("3.0", XMLSchema.DECIMAL), vf.createLiteral(4.0), vf.createLiteral(true), vf.createLiteral(false), vf.createLiteral("plain string"), vf.createLiteral("datatyped string", XMLSchema.STRING), vf.createLiteral("english string", "en"), vf.createBNode("_:s1"), vf.createBNode("_:s2")};
        cxn.getTripleStore().getLexiconRelation().addTerms(values, values.length, true);
        TestTicket1893.assertFalse((boolean)values[0].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[1].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[2].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[3].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[4].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[5].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[6].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[7].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[8].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[9].getIV().isInline());
        this.endTest(cxn);
    }

    public void test_21() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, true, false);
        this.loadData(cxn);
        BigdataValueFactory vf = cxn.getValueFactory();
        BigdataValue[] values = new BigdataValue[]{vf.createURI("http://s"), vf.createLiteral("1", XMLSchema.INTEGER), vf.createLiteral(2), vf.createLiteral("3.0", XMLSchema.DECIMAL), vf.createLiteral(4.0), vf.createLiteral(true), vf.createLiteral(false), vf.createLiteral("plain string"), vf.createLiteral("datatyped string", XMLSchema.STRING), vf.createLiteral("english string", "en"), vf.createLiteral("very long literal which length exceeds MAX_INLINE_TEXT_LENGTH")};
        cxn.getTripleStore().getLexiconRelation().addTerms(values, values.length, true);
        TestTicket1893.assertTrue((boolean)values[0].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[1].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[2].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[3].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[4].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[5].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[6].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[7].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[8].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[9].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[10].getIV().isInline());
        this.endTest(cxn);
    }

    public void test_22() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, true, false);
        this.insertSparql(cxn);
        BigdataValueFactory vf = cxn.getValueFactory();
        BigdataValue[] values = new BigdataValue[]{vf.createURI("http://s"), vf.createLiteral("1", XMLSchema.INTEGER), vf.createLiteral(2), vf.createLiteral("3.0", XMLSchema.DECIMAL), vf.createLiteral(4.0), vf.createLiteral(true), vf.createLiteral(false), vf.createLiteral("plain string"), vf.createLiteral("datatyped string", XMLSchema.STRING), vf.createLiteral("english string", "en"), vf.createLiteral("very long literal which length exceeds MAX_INLINE_TEXT_LENGTH")};
        cxn.getTripleStore().getLexiconRelation().addTerms(values, values.length, true);
        TestTicket1893.assertTrue((boolean)values[0].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[1].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[2].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[3].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[4].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[5].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[6].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[7].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[8].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[9].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[10].getIV().isInline());
        this.endTest(cxn);
    }

    public void test_23() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, false, true);
        this.loadData(cxn);
        BigdataValueFactory vf = cxn.getValueFactory();
        BigdataValue[] values = new BigdataValue[]{vf.createURI("http://s"), vf.createLiteral("1", XMLSchema.INTEGER), vf.createLiteral(2), vf.createLiteral("3.0", XMLSchema.DECIMAL), vf.createLiteral(4.0), vf.createLiteral(true), vf.createLiteral(false), vf.createLiteral("plain string"), vf.createLiteral("datatyped string", XMLSchema.STRING), vf.createLiteral("english string", "en")};
        cxn.getTripleStore().getLexiconRelation().addTerms(values, values.length, true);
        TestTicket1893.assertFalse((boolean)values[0].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[1].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[2].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[3].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[4].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[5].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[6].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[7].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[8].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[9].getIV().isInline());
        this.endTest(cxn);
    }

    public void test_24() throws Exception {
        String namespace = "test" + UUID.randomUUID();
        BigdataSailRepositoryConnection cxn = this.prepareTest(namespace, false, true);
        this.insertSparql(cxn);
        BigdataValueFactory vf = cxn.getValueFactory();
        BigdataValue[] values = new BigdataValue[]{vf.createURI("http://s"), vf.createLiteral("1", XMLSchema.INTEGER), vf.createLiteral(2), vf.createLiteral("3.0", XMLSchema.DECIMAL), vf.createLiteral(4.0), vf.createLiteral(true), vf.createLiteral(false), vf.createLiteral("plain string"), vf.createLiteral("datatyped string", XMLSchema.STRING), vf.createLiteral("english string", "en")};
        cxn.getTripleStore().getLexiconRelation().addTerms(values, values.length, true);
        TestTicket1893.assertFalse((boolean)values[0].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[1].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[2].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[3].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[4].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[5].getIV().isInline());
        TestTicket1893.assertTrue((boolean)values[6].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[7].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[8].getIV().isInline());
        TestTicket1893.assertFalse((boolean)values[9].getIV().isInline());
        this.endTest(cxn);
    }

    private BigdataSailRepositoryConnection prepareTest(String namespace, boolean inlineTextLiterals, boolean inlineXSDDatatypeLiterals) throws Exception {
        return this.prepareTest(namespace, inlineTextLiterals, inlineXSDDatatypeLiterals, false);
    }

    private BigdataSailRepositoryConnection prepareTest(String namespace, boolean inlineTextLiterals, boolean inlineXSDDatatypeLiterals, boolean textIndexDatatypeLiterals) throws Exception {
        Properties properties = this.getProperties();
        properties.setProperty(BigdataSail.Options.NAMESPACE, namespace);
        properties.setProperty("com.bigdata.namespace." + namespace + ".lex." + AbstractTripleStore.Options.INLINE_TEXT_LITERALS, Boolean.toString(inlineTextLiterals));
        if (inlineTextLiterals) {
            properties.setProperty("com.bigdata.namespace." + namespace + ".lex." + AbstractTripleStore.Options.MAX_INLINE_TEXT_LENGTH, Integer.toString(45));
        }
        properties.setProperty("com.bigdata.namespace." + namespace + ".lex." + AbstractTripleStore.Options.INLINE_XSD_DATATYPE_LITERALS, Boolean.toString(inlineXSDDatatypeLiterals));
        properties.setProperty("com.bigdata.namespace." + namespace + ".lex." + AbstractTripleStore.Options.TEXT_INDEX_DATATYPE_LITERALS, Boolean.toString(textIndexDatatypeLiterals));
        properties.setProperty("com.bigdata.namespace." + namespace + ".lex." + AbstractTripleStore.Options.STORE_BLANK_NODES, Boolean.toString(true));
        BigdataSail sail = this.getSail(properties);
        sail.initialize();
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        return repo.getConnection();
    }

    private void endTest(BigdataSailRepositoryConnection cxn) throws Exception {
        cxn.close();
        cxn.getTripleStore().close();
        IJournal store = ((LocalTripleStore)cxn.getTripleStore()).getIndexManager();
        store.shutdownNow();
        store.destroy();
    }

    private void loadData(BigdataSailRepositoryConnection cxn) throws RepositoryException, RDFParseException, IOException {
        cxn.clear(new Resource[0]);
        cxn.add((InputStream)new ByteArrayInputStream(DATA.getBytes()), "", DATA_FORMAT, new Resource[0]);
        cxn.commit();
    }

    private void insertSparql(BigdataSailRepositoryConnection cxn) throws Exception {
        cxn.prepareUpdate(QueryLanguage.SPARQL, INSERT_SPARQL).execute();
    }

    private ITextIndexer.FullTextQuery query(String query) {
        return new ITextIndexer.FullTextQuery(query, null, false);
    }
}

