/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.QuadsTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.RDFHandlerBase;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class TestTicket276
extends QuadsTestCase {
    public TestTicket276() {
    }

    public TestTicket276(String arg0) {
        super(arg0);
    }

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.INLINE_DATE_TIMES, "true");
        props.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "true");
        props.setProperty(BigdataSail.Options.EXACT_SIZE, "true");
        props.setProperty(BigdataSail.Options.STATEMENT_IDENTIFIERS, "false");
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug() throws Exception {
        this.executeQuery(new SailRepository((Sail)new MemoryStore()));
        BigdataSail sail = this.getSail();
        try {
            this.executeQuery((SailRepository)new BigdataSailRepository(sail));
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery(SailRepository repo) throws RepositoryException, MalformedQueryException, QueryEvaluationException, RDFParseException, IOException, RDFHandlerException {
        try {
            repo.initialize();
            conn.setAutoCommit(false);
            try (SailRepositoryConnection conn = repo.getConnection();){
                ValueFactory vf = conn.getValueFactory();
                this.addData((RepositoryConnection)conn);
                conn.commit();
                String query = "SELECT ?x { ?x ?a ?t . ?x ?lookup ?l }";
                TupleQuery q = conn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT ?x { ?x ?a ?t . ?x ?lookup ?l }");
                q.setBinding("a", (Value)vf.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"));
                q.setBinding("t", (Value)vf.createURI("os:class/Location"));
                q.setBinding("lookup", (Value)vf.createURI("os:prop/lookupName"));
                q.setBinding("l", (Value)vf.createLiteral("amsterdam"));
                TupleQueryResult tqr = q.evaluate();
                while (tqr.hasNext()) {
                    Set bindingNames = ((BindingSet)tqr.next()).getBindingNames();
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("bindingNames=" + bindingNames));
                }
                tqr.close();
            }
        }
        finally {
            repo.shutDown();
        }
    }

    private void addData(final RepositoryConnection conn) throws IOException, RDFParseException, RepositoryException, RDFHandlerException {
        RDFParser rdfParser = Rio.createParser((RDFFormat)RDFFormat.NTRIPLES, (ValueFactory)conn.getValueFactory());
        rdfParser.setVerifyData(true);
        rdfParser.setStopAtFirstError(true);
        rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
        rdfParser.setRDFHandler((RDFHandler)new RDFHandlerBase(){

            public void handleStatement(Statement st) throws RDFHandlerException {
                try {
                    conn.add(st, new Resource[0]);
                }
                catch (OpenRDFException e) {
                    throw new RDFHandlerException((Throwable)e);
                }
            }
        });
        rdfParser.parse(((Object)((Object)this)).getClass().getResourceAsStream("TestTicket276.n3"), "");
    }
}

