/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.QuadsTestCase;
import com.bigdata.rdf.vocab.NoVocabulary;
import java.io.IOException;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class TestTicket355
extends QuadsTestCase {
    public TestTicket355() {
    }

    public TestTicket355(String arg0) {
        super(arg0);
    }

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.VOCABULARY_CLASS, NoVocabulary.class.getName());
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(BigdataSail.Options.JUSTIFY, "false");
        props.setProperty(BigdataSail.Options.INLINE_DATE_TIMES, "true");
        props.setProperty(BigdataSail.Options.ISOLATABLE_INDICES, "true");
        props.setProperty(BigdataSail.Options.EXACT_SIZE, "true");
        props.setProperty(BigdataSail.Options.STATEMENT_IDENTIFIERS, "false");
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug() throws Exception {
        this.executeQuery(new SailRepository((Sail)new MemoryStore()));
        BigdataSail sail = this.getSail();
        try {
            this.executeQuery((SailRepository)new BigdataSailRepository(sail));
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery(SailRepository repo) throws RepositoryException, MalformedQueryException, QueryEvaluationException, RDFParseException, IOException, RDFHandlerException {
        try {
            repo.initialize();
            conn.setAutoCommit(false);
            try (SailRepositoryConnection conn = repo.getConnection();){
                ValueFactory vf = conn.getValueFactory();
                conn.add((Resource)vf.createURI("os:subject"), vf.createURI("os:prop"), (Value)vf.createLiteral("value"), new Resource[0]);
                conn.commit();
                String query = "SELECT ?subj WHERE { ?subj <os:prop> ?val . FILTER(STR(?val) != ?arg)}";
                TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                tq.setBinding("arg", (Value)vf.createLiteral("notValue"));
                TupleQueryResult tqr = tq.evaluate();
                TestTicket355.assertTrue((boolean)tqr.hasNext());
                tqr.close();
            }
        }
        finally {
            repo.shutDown();
        }
    }
}

