/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.btree.IndexMetadata;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.Options;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.service.AbstractTransactionService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.helpers.RDFHandlerBase;
import org.openrdf.sail.SailException;

public class TestTicket473
extends TestCase {
    private static final Logger log = Logger.getLogger(TestTicket473.class);

    public TestTicket473() {
    }

    public TestTicket473(String arg0) {
        super(arg0);
    }

    private Properties getProperties() {
        Properties props = new Properties();
        props.setProperty(BigdataSail.Options.NAMESPACE, "foo.bar.snapdragon.kb");
        props.setProperty(Options.BUFFER_MODE, BufferMode.DiskRW.name());
        props.setProperty(IndexMetadata.Options.WRITE_RETENTION_QUEUE_CAPACITY, "4000");
        props.setProperty(IndexMetadata.Options.BTREE_BRANCHING_FACTOR, "128");
        props.setProperty(AbstractTransactionService.Options.MIN_RELEASE_AGE, "1");
        props.setProperty(AbstractTripleStore.Options.TEXT_INDEX, "false");
        props.setProperty(AbstractTripleStore.Options.AXIOMS_CLASS, NoAxioms.class.getName());
        props.setProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "false");
        props.setProperty(AbstractTripleStore.Options.JUSTIFY, "false");
        props.setProperty(AbstractTripleStore.Options.STATEMENT_IDENTIFIERS, "false");
        props.setProperty(AbstractTripleStore.Options.QUADS_MODE, "false");
        props.setProperty(Options.MAXIMUM_EXTENT, "209715200");
        props.setProperty(BigdataSail.Options.BUFFER_CAPACITY, "100000");
        props.setProperty(AbstractTripleStore.Options.BLOOM_FILTER, "false");
        props.setProperty(Options.FILE, "ticket473.jnl");
        return props;
    }

    private BigdataSail getSail(Properties properties) {
        return new BigdataSail(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_stressTicket473() throws Exception {
        BigdataSail sail = null;
        try {
            for (int i = 0; i < 20; ++i) {
                log.info((Object)"Opening sail");
                sail = this.getSail(this.getProperties());
                try {
                    sail.initialize();
                    this.loadOntology(sail, "data/lehigh/univ-bench.owl");
                    this.doTicket473Commit(sail);
                    continue;
                }
                finally {
                    sail.shutDown();
                }
            }
        }
        finally {
            if (sail != null) {
                sail.__tearDownUnitTest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTicket473Commit(BigdataSail sail) throws Exception {
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        conn.setAutoCommit(false);
        try (BigdataSailRepositoryConnection conn = repo.getUnisolatedConnection();){
            BigdataValueFactory vf = conn.getValueFactory();
            URI pred = vf.createURI("http://foo.bar/ontoloty/hasGate");
            for (int r = 0; r < 10; ++r) {
                for (int i = 0; i < 10; ++i) {
                    URI subj = vf.createURI("http://foo.bar/note/" + r + "_" + i);
                    URI obj = vf.createURI("http://foo.bar/gate/" + r + "_" + i);
                    conn.add((Resource)subj, pred, (Value)obj, new Resource[]{null});
                }
                conn.commit();
                Thread.sleep(100L);
            }
            Thread.sleep(10000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOntology(BigdataSail sail, String fileName) throws SailException, InterruptedException {
        File file = new File(fileName);
        String baseURI = file.toURI().toString();
        AtomicLong nmodified = new AtomicLong();
        Resource defaultContext = null;
        try (BigdataSail.BigdataSailConnection conn = sail.getUnisolatedConnection();){
            InputStream is;
            RDFParser rdfParser;
            block10: {
                RDFFormat format = RDFFormat.forFileName((String)fileName);
                RDFParserFactory rdfParserFactory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)format);
                rdfParser = rdfParserFactory.getParser();
                rdfParser.setValueFactory((ValueFactory)conn.getTripleStore().getValueFactory());
                rdfParser.setVerifyData(true);
                rdfParser.setStopAtFirstError(true);
                rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
                rdfParser.setRDFHandler((RDFHandler)new AddStatementHandler(conn, nmodified, defaultContext));
                is = null;
                try {
                    is = new BufferedInputStream(new FileInputStream(file));
                }
                catch (FileNotFoundException f) {
                    is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fileName);
                    if ($assertionsDisabled || is != null) break block10;
                    throw new AssertionError();
                }
            }
            try {
                rdfParser.parse(is, baseURI);
            }
            finally {
                is.close();
            }
            conn.commit();
        }
    }

    private static class AddStatementHandler
    extends RDFHandlerBase {
        private final BigdataSail.BigdataSailConnection conn;
        private final AtomicLong nmodified;
        private final Resource[] defaultContexts;

        public AddStatementHandler(BigdataSail.BigdataSailConnection conn, AtomicLong nmodified, Resource defaultContext) {
            this.conn = conn;
            this.nmodified = nmodified;
            boolean quads = conn.getTripleStore().isQuads();
            this.defaultContexts = quads && defaultContext != null ? new Resource[]{defaultContext} : new Resource[0];
        }

        public void handleStatement(Statement stmt) throws RDFHandlerException {
            try {
                Resource[] resourceArray;
                Resource resource = stmt.getSubject();
                URI uRI = stmt.getPredicate();
                Value value = stmt.getObject();
                if (stmt.getContext() == null) {
                    resourceArray = this.defaultContexts;
                } else {
                    Resource[] resourceArray2 = new Resource[1];
                    resourceArray = resourceArray2;
                    resourceArray2[0] = stmt.getContext();
                }
                this.conn.addStatement(resource, uRI, value, resourceArray);
            }
            catch (SailException e) {
                throw new RDFHandlerException((Throwable)e);
            }
            this.nmodified.incrementAndGet();
        }
    }
}

