/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.axioms.OwlAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.ProxyBigdataSailTestCase;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Arrays;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class TestTicket610
extends ProxyBigdataSailTestCase {
    protected static final Logger log = Logger.getLogger(TestTicket610.class);

    @Override
    public Properties getProperties() {
        Properties props = super.getProperties();
        props.setProperty(BigdataSail.Options.AXIOMS_CLASS, OwlAxioms.class.getName());
        return props;
    }

    public TestTicket610() {
    }

    public TestTicket610(String arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug() throws Exception {
        URIImpl a = new URIImpl(":a");
        URIImpl b = new URIImpl(":b");
        LinkedHashModel data = new LinkedHashModel(Arrays.asList(new StatementImpl((Resource)a, RDF.TYPE, (Value)OWL.TRANSITIVEPROPERTY), new StatementImpl((Resource)b, RDFS.SUBPROPERTYOF, (Value)a)));
        BigdataSail sail = this.getSail();
        try {
            sail.initialize();
            BigdataSailRepository bigdataRepo = new BigdataSailRepository(sail);
            try (BigdataSailRepositoryConnection cxn = bigdataRepo.getConnection();){
                cxn.setAutoCommit(false);
                cxn.add((Iterable)data, new Resource[0]);
                cxn.commit();
            }
            cxn = bigdataRepo.getReadOnlyConnection();
            try {
                AbstractTripleStore store = cxn.getTripleStore();
                if (log.isDebugEnabled()) {
                    log.info((Object)store.dumpStore(true, true, false));
                }
                TestTicket610.assertFalse((String)"should not have the (<b> rdf:type owl:TransitiveProperty) inference", (boolean)store.hasStatement((Resource)b, RDF.TYPE, (Value)OWL.TRANSITIVEPROPERTY));
            }
            finally {
                cxn.close();
            }
        }
        finally {
            sail.__tearDownUnitTest();
        }
    }
}

